/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.JavawsFactory;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.Patcher;
import com.sun.javaws.exceptions.BadJARFileException;
import com.sun.javaws.exceptions.BadMimeTypeResponseException;
import com.sun.javaws.exceptions.BadVersionResponseException;
import com.sun.javaws.exceptions.ErrorCodeResponseException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.InvalidJarDiffException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.MissingVersionResponseException;
import com.sun.javaws.jardiff.JarDiffPatcher;
import com.sun.javaws.net.CanceledDownloadException;
import com.sun.javaws.net.HttpDownloadListener;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import com.sun.javaws.security.SigningInfo;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class DownloadProtocol {
    public static final int JAR_DOWNLOAD = 0;
    public static final int NATIVE_DOWNLOAD = 1;
    public static final int IMAGE_DOWNLOAD = 2;
    public static final int APPLICATION_JNLP_DOWNLOAD = 3;
    public static final int EXTENSION_JNLP_DOWNLOAD = 4;
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JAR_MIME_TYPE = "application/x-java-archive";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String GIF_MIME_TYPE = "image/gif";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";

    private static void doDownload(DownloadInfo downloadInfo, DownloadAction downloadAction) throws JNLPException {
        try {
            boolean[] blArray = new boolean[1];
            DiskCacheEntry diskCacheEntry = DownloadProtocol.findBestDiskCacheEntry(downloadInfo.getEntryType(), downloadInfo.getLocation(), downloadInfo.getVersion(), blArray);
            boolean bl = blArray[0];
            if (diskCacheEntry != null && downloadInfo.isCacheOk(diskCacheEntry, bl)) {
                Trace.println((String)("Found in cache: " + diskCacheEntry), (TraceLevel)TraceLevel.NETWORK);
                downloadAction.actionInCache(diskCacheEntry);
                return;
            }
            if (Globals.isOffline()) {
                Trace.println((String)("Offline mode. No Web check. Cache lookup: " + diskCacheEntry), (TraceLevel)TraceLevel.NETWORK);
                downloadAction.actionOffline(diskCacheEntry, bl);
                return;
            }
            if (downloadAction.skipDownloadStep()) {
                Trace.println((String)"Skipping download step", (TraceLevel)TraceLevel.NETWORK);
                return;
            }
            URL uRL = downloadInfo.getRequestURL(diskCacheEntry);
            Trace.println((String)("Connection to: " + uRL), (TraceLevel)TraceLevel.NETWORK);
            HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
            HttpResponse httpResponse = null;
            try {
                httpResponse = downloadAction.useHeadRequest() ? httpRequest.doHeadRequest(uRL) : httpRequest.doGetRequest(uRL);
            }
            catch (IOException iOException) {
                HttpResponse httpResponse2 = httpResponse = downloadAction.useHeadRequest() ? httpRequest.doHeadRequest(uRL, false) : httpRequest.doGetRequest(uRL, false);
            }
            if (httpResponse.getStatusCode() == 404) {
                throw new FailedDownloadingResourceException(downloadInfo.getLocation(), downloadInfo.getVersion(), new IOException("HTTP response 404"));
            }
            int n = httpResponse.getContentLength();
            long l = httpResponse.getLastModified();
            String string = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            String string2 = downloadInfo.getVersion();
            if (string2 != null && string == null && Globals.getCodebaseOverride() != null && new VersionID(string2).isSimpleVersion()) {
                string = string2;
            }
            String string3 = httpResponse.getContentType();
            Trace.println((String)("Sever response: (length: " + n + ", lastModified: " + new Date(l) + ", downloadVersion " + string + ", mimeType: " + string3 + ")"), (TraceLevel)TraceLevel.NETWORK);
            if (string3 != null && string3.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string4 = bufferedReader.readLine();
                throw new ErrorCodeResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string4);
            }
            if (!downloadInfo.isValidMimeType(string3, diskCacheEntry)) {
                throw new BadMimeTypeResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string3);
            }
            if (downloadInfo.needsReplyVersion(diskCacheEntry)) {
                if (string == null) {
                    throw new MissingVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion());
                }
                if (!downloadInfo.isPlatformRequest()) {
                    if (!new VersionString(downloadInfo.getVersion()).contains(string)) {
                        throw new BadVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string);
                    }
                    VersionID versionID = new VersionID(string);
                    if (!versionID.isSimpleVersion()) {
                        throw new BadVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string);
                    }
                }
            }
            if (diskCacheEntry != null && !downloadInfo.isWebNewer(diskCacheEntry, n, l, string)) {
                downloadAction.actionInCache(diskCacheEntry);
                httpResponse.disconnect();
                return;
            }
            downloadAction.actionDownload(diskCacheEntry, downloadInfo, l, n, string, string3, httpResponse);
            httpResponse.disconnect();
        }
        catch (ZipException zipException) {
            throw new BadJARFileException(downloadInfo.getLocation(), downloadInfo.getVersion(), zipException);
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
        catch (Exception exception) {
            throw new FailedDownloadingResourceException(downloadInfo.getLocation(), downloadInfo.getVersion(), exception);
        }
    }

    private static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate) throws JNLPException {
        JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
        File file3 = null;
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            file3 = Cache.getTempCacheFile(uRL, string);
            outputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    public void patching(int n) {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new InvalidJarDiffException(uRL, string, iOException);
            }
            bl = true;
        }
        catch (IOException iOException) {
            Trace.println((String)("Got exception while patching: " + iOException), (TraceLevel)TraceLevel.NETWORK);
            throw new FailedDownloadingResourceException(uRL, string, iOException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                downloadDelegate.downloadFailed(uRL, string);
            }
        }
        return file3;
    }

    public static DiskCacheEntry getJRE(URL uRL, String string, boolean bl, String string2) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, false, string2, bl);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        return diskCacheEntry;
    }

    public static DiskCacheEntry getLaunchFile(URL uRL, boolean bl) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, false);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, null, null);
        }
        return diskCacheEntry;
    }

    public static DiskCacheEntry getCachedLaunchedFile(URL uRL) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, true);
        IsInCacheAction isInCacheAction = new IsInCacheAction();
        DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
        DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
        return diskCacheEntry;
    }

    public static boolean isLaunchFileUpdateAvailable(URL uRL) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction();
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    public static DiskCacheEntry getExtension(URL uRL, String string, String string2, boolean bl) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, bl, string2, false);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        return diskCacheEntry;
    }

    public static DiskCacheEntry getCachedExtension(URL uRL, String string, String string2) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, true, string2, false);
        IsInCacheAction isInCacheAction = new IsInCacheAction();
        DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
        DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
        return diskCacheEntry;
    }

    public static boolean isExtensionUpdateAvailable(URL uRL, String string, String string2) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, false, string2, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction();
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    public static DiskCacheEntry getResource(URL uRL, String string, int n, boolean bl, DownloadDelegate downloadDelegate) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, bl);
        RetrieveAction retrieveAction = new RetrieveAction(downloadDelegate);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        return diskCacheEntry;
    }

    public static boolean isInCache(URL uRL, String string, int n) {
        return DownloadProtocol.getCachedVersion(uRL, string, n) != null;
    }

    public static long getCachedSize(URL uRL, String string, int n) {
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(uRL, string, n);
        return diskCacheEntry != null ? diskCacheEntry.getSize() : 0L;
    }

    public static DiskCacheEntry getCachedVersion(URL uRL, String string, int n) {
        try {
            DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, true);
            IsInCacheAction isInCacheAction = new IsInCacheAction();
            DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
            DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
            return diskCacheEntry;
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
            return null;
        }
    }

    public static boolean isUpdateAvailable(URL uRL, String string, int n) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction();
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    public static long getDownloadSize(URL uRL, String string, int n) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, false);
        DownloadSizeAction downloadSizeAction = new DownloadSizeAction();
        DownloadProtocol.doDownload(downloadInfo, downloadSizeAction);
        return downloadSizeAction.getResult();
    }

    private static DiskCacheEntry findBestDiskCacheEntry(char c, URL uRL, String string, boolean[] blArray) throws IOException {
        Object object;
        if (string == null) {
            blArray[0] = true;
            return Cache.getCacheEntry(c, uRL, null);
        }
        VersionString versionString = new VersionString(string);
        if (versionString.isSimpleVersion() && (object = Cache.getCacheEntry(c, uRL, string)) != null) {
            blArray[0] = true;
            return object;
        }
        object = null;
        Object object2 = null;
        String[] stringArray = Cache.getCacheVersions(c, uRL);
        for (int i = 0; i < stringArray.length; ++i) {
            if (versionString.contains(stringArray[i])) {
                object2 = stringArray[i];
                break;
            }
            if (!versionString.containsGreaterThan(stringArray[i]) || object != null) continue;
            object = stringArray[i];
        }
        if (object2 == null) {
            blArray[0] = false;
            if (object == null) {
                return null;
            }
            object2 = object;
        } else {
            blArray[0] = true;
        }
        return Cache.getCacheEntry(c, uRL, (String)object2);
    }

    private static interface DownloadAction {
        public void actionInCache(DiskCacheEntry var1) throws IOException, JNLPException;

        public void actionOffline(DiskCacheEntry var1, boolean var2) throws IOException, JNLPException;

        public boolean skipDownloadStep();

        public void actionDownload(DiskCacheEntry var1, DownloadInfo var2, long var3, int var5, String var6, String var7, HttpResponse var8) throws IOException, JNLPException;

        public boolean useHeadRequest();
    }

    public static interface DownloadDelegate {
        public void downloading(URL var1, String var2, int var3, int var4, boolean var5);

        public void validating(URL var1, int var2, int var3);

        public void patching(URL var1, String var2, int var3);

        public void downloadFailed(URL var1, String var2);
    }

    static class DownloadInfo {
        private URL _location;
        private String _version;
        private int _kind;
        private boolean _isCacheOk;
        private String _knownPlatforms = null;
        private boolean _isPlatformVersion = false;

        public DownloadInfo(URL uRL, String string, int n, boolean bl) {
            this._location = uRL;
            this._version = string;
            this._kind = n;
            this._isCacheOk = bl;
        }

        public DownloadInfo(URL uRL, String string, boolean bl, String string2, boolean bl2) {
            this._location = uRL;
            this._version = string;
            this._kind = 4;
            this._isCacheOk = bl;
            this._knownPlatforms = string2;
            this._isPlatformVersion = bl2;
        }

        URL getLocation() {
            return this._location;
        }

        String getVersion() {
            return this._version;
        }

        int getKind() {
            return this._kind;
        }

        char getEntryType() {
            switch (this._kind) {
                case 0: {
                    return 'R';
                }
                case 2: {
                    return 'R';
                }
                case 1: {
                    return 'R';
                }
                case 3: {
                    return 'A';
                }
                case 4: {
                    return 'E';
                }
            }
            return 'a';
        }

        boolean isCacheOk(DiskCacheEntry diskCacheEntry, boolean bl) {
            return bl && (this._version != null || this._isCacheOk) && diskCacheEntry.getTimeStamp() != 0L;
        }

        URL getRequestURL(DiskCacheEntry diskCacheEntry) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._version != null && this._kind != 4) {
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_VERSION_ID, this._version);
                if ((this._kind == 0 || this._kind == 1) && diskCacheEntry != null && diskCacheEntry.getVersionId() != null) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_CURRENT_VERSION_ID, diskCacheEntry.getVersionId());
                }
            }
            if (this._kind == 4 && this._version != null) {
                if (this._isPlatformVersion) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_PLATFORM_VERSION_ID, this._version);
                } else {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_VERSION_ID, this._version);
                }
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_ARCH, Config.getOSArch());
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_OS, Config.getOSName());
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_LOCALE, Globals.getDefaultLocaleString());
                if (this._knownPlatforms != null) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_KNOWN_PLATFORMS, this._knownPlatforms);
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, '?');
            }
            try {
                if (Globals.getCodebaseOverride() != null && Globals.getCodebase() != null) {
                    return new URL(Globals.getCodebaseOverride() + this._location.getFile().substring(Globals.getCodebase().getFile().length()) + stringBuffer);
                }
                return new URL(this._location.getProtocol(), this._location.getHost(), this._location.getPort(), this._location.getFile() + stringBuffer);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
                return null;
            }
        }

        private void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
            stringBuffer.append(URLEncoder.encode(string));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2));
            stringBuffer.append('&');
        }

        boolean needsReplyVersion(DiskCacheEntry diskCacheEntry) {
            return this._version != null;
        }

        boolean isPlatformRequest() {
            return this._isPlatformVersion;
        }

        boolean isValidMimeType(String string, DiskCacheEntry diskCacheEntry) {
            if (string == null) {
                return false;
            }
            if (this._kind == 0 || this._kind == 1) {
                if (string.equalsIgnoreCase(DownloadProtocol.JARDIFF_MIME_TYPE)) {
                    return diskCacheEntry != null && diskCacheEntry.getVersionId() != null;
                }
                return true;
            }
            if (this._kind == 2) {
                return string.equalsIgnoreCase(DownloadProtocol.JPEG_MIME_TYPE) || string.equalsIgnoreCase(DownloadProtocol.GIF_MIME_TYPE);
            }
            return true;
        }

        boolean isWebNewer(DiskCacheEntry diskCacheEntry, long l, long l2, String string) {
            if (this._version == null) {
                return l2 == 0L && l > 0L || l2 > diskCacheEntry.getTimeStamp();
            }
            return true;
        }
    }

    private static class DownloadSizeAction
    implements DownloadAction {
        private long _result = -1L;

        private DownloadSizeAction() {
        }

        public long getResult() {
            return this._result;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = 0L;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = bl ? 0L : -1L;
        }

        public boolean skipDownloadStep() {
            return false;
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            this._result = n;
        }

        public boolean useHeadRequest() {
            return true;
        }
    }

    private static class IsInCacheAction
    implements DownloadAction {
        private DiskCacheEntry _dce = null;

        private IsInCacheAction() {
        }

        public DiskCacheEntry getResult() {
            return this._dce;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._dce = diskCacheEntry;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._dce = bl ? diskCacheEntry : null;
        }

        public boolean skipDownloadStep() {
            return true;
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
        }

        public boolean useHeadRequest() {
            return false;
        }
    }

    private static class RetrieveAction
    implements DownloadAction {
        private DiskCacheEntry _result = null;
        private DownloadDelegate _delegate = null;

        public DiskCacheEntry getResult() {
            return this._result;
        }

        public RetrieveAction(DownloadDelegate downloadDelegate) {
            this._delegate = downloadDelegate;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = diskCacheEntry;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = bl ? diskCacheEntry : null;
        }

        public boolean skipDownloadStep() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, final String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            final URL uRL = downloadInfo.getLocation();
            final boolean bl = string2.equalsIgnoreCase(DownloadProtocol.JARDIFF_MIME_TYPE);
            String string3 = downloadInfo.getVersion();
            String string4 = string3 != null ? string : null;
            Trace.println((String)"Doing download", (TraceLevel)TraceLevel.NETWORK);
            HttpDownloadListener httpDownloadListener = this._delegate == null ? null : new HttpDownloadListener(){

                public boolean downloadProgress(int n, int n2) {
                    RetrieveAction.this._delegate.downloading(uRL, string, n, n2, bl);
                    return true;
                }
            };
            File file = null;
            try {
                file = Cache.getTempCacheFile(uRL, string4);
                JavawsFactory.getHttpDownloadImpl().download(httpResponse, file, httpDownloadListener);
            }
            catch (IOException iOException) {
                Trace.println((String)("Got exception while downloading resource: " + iOException), (TraceLevel)TraceLevel.NETWORK);
                if (this._delegate != null) {
                    this._delegate.downloadFailed(uRL, string);
                }
                throw new FailedDownloadingResourceException(uRL, string, iOException);
            }
            catch (CanceledDownloadException canceledDownloadException) {
                Trace.ignoredException((Exception)canceledDownloadException);
            }
            if (bl) {
                file = DownloadProtocol.applyPatch(diskCacheEntry.getFile(), file, uRL, string, this._delegate);
            }
            if (downloadInfo.getKind() == 3 || downloadInfo.getKind() == 4 || downloadInfo.getKind() == 2) {
                Cache.insertEntry(downloadInfo.getEntryType(), uRL, string4, file, l);
                file = null;
            } else if (downloadInfo.getKind() == 0 || downloadInfo.getKind() == 1) {
                File file2 = downloadInfo.getKind() == 1 ? Cache.createNativeLibDir(uRL, string4) : null;
                JarFile jarFile = new JarFile(file);
                try {
                    SigningInfo.checkSigning(uRL, string4, jarFile, this._delegate, file2);
                    jarFile.close();
                    jarFile = null;
                    Cache.insertEntry(downloadInfo.getEntryType(), uRL, string4, file, l);
                    file = null;
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (file != null) {
                        file.delete();
                    }
                }
            }
            this._result = Cache.getCacheEntry(downloadInfo.getEntryType(), uRL, string4);
        }

        public boolean useHeadRequest() {
            return false;
        }
    }

    private static class UpdateAvailableAction
    implements DownloadAction {
        private boolean _result = false;

        private UpdateAvailableAction() {
        }

        public boolean getResult() {
            return this._result;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = false;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = false;
        }

        public boolean skipDownloadStep() {
            return false;
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            this._result = true;
        }

        public boolean useHeadRequest() {
            return true;
        }
    }
}

