/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.concurrent;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.concurrent.ReentrantMutex;
import com.sun.corba.se.impl.orbutil.concurrent.Sync;

public class CondVar {
    protected boolean debug_;
    protected final Sync mutex_;
    protected final ReentrantMutex remutex_;

    private int releaseMutex() {
        int n2 = 1;
        if (this.remutex_ != null) {
            n2 = this.remutex_.releaseAll();
        } else {
            this.mutex_.release();
        }
        return n2;
    }

    private void acquireMutex(int n2) throws InterruptedException {
        if (this.remutex_ != null) {
            this.remutex_.acquireAll(n2);
        } else {
            this.mutex_.acquire();
        }
    }

    public CondVar(Sync sync, boolean bl2) {
        this.debug_ = bl2;
        this.mutex_ = sync;
        this.remutex_ = sync instanceof ReentrantMutex ? (ReentrantMutex)sync : null;
    }

    public CondVar(Sync sync) {
        this(sync, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        int n2 = 0;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "await enter");
            }
            CondVar condVar = this;
            synchronized (condVar) {
                n2 = this.releaseMutex();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            boolean bl2 = false;
            while (true) {
                try {
                    this.acquireMutex(n2);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                break;
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "await exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timedwait(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl2 = false;
        int n2 = 0;
        try {
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "timedwait enter");
            }
            CondVar condVar = this;
            synchronized (condVar) {
                n2 = this.releaseMutex();
                try {
                    if (l2 > 0L) {
                        long l3 = System.currentTimeMillis();
                        this.wait(l2);
                        bl2 = System.currentTimeMillis() - l3 <= l2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            boolean bl3 = false;
            while (true) {
                try {
                    this.acquireMutex(n2);
                }
                catch (InterruptedException interruptedException) {
                    bl3 = true;
                    continue;
                }
                break;
            }
            if (bl3) {
                Thread.currentThread().interrupt();
            }
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "timedwait exit");
            }
        }
        return bl2;
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

