/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import sun.security.action.LoadLibraryAction;

class NativeUnpack {
    private long unpackerPtr;
    private BufferedInputStream in;
    private int _verbose;
    private long _byteCount;
    private int _segCount;
    private int _fileCount;
    private long _estByteLimit;
    private int _estSegLimit;
    private int _estFileLimit;
    private int _prevPercent = -1;
    private final CRC32 _crc32 = new CRC32();
    private byte[] _buf = new byte[16384];
    private UnpackerImpl _p200;
    private PropMap _props;

    private static synchronized native void initIDs();

    private synchronized native long start(ByteBuffer var1, long var2);

    private synchronized native boolean getNextFile(Object[] var1);

    private synchronized native ByteBuffer getUnusedInput();

    private synchronized native long finish();

    protected synchronized native boolean setOption(String var1, String var2);

    protected synchronized native String getOption(String var1);

    NativeUnpack(UnpackerImpl unpackerImpl) {
        this._p200 = unpackerImpl;
        this._props = unpackerImpl._props;
        unpackerImpl._nunp = this;
    }

    private static Object currentInstance() {
        UnpackerImpl unpackerImpl = (UnpackerImpl)Utils.currentInstance.get();
        return unpackerImpl == null ? null : unpackerImpl._nunp;
    }

    private long readInputFn(ByteBuffer byteBuffer, long l2) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        long l3 = byteBuffer.capacity() - byteBuffer.position();
        assert (l2 <= l3);
        long l4 = 0L;
        int n2 = 0;
        while (l4 < l2) {
            int n3;
            ++n2;
            int n4 = this._buf.length;
            if ((long)n4 > l3 - l4) {
                n4 = (int)(l3 - l4);
            }
            if ((n3 = this.in.read(this._buf, 0, n4)) <= 0) break;
            assert ((l4 += (long)n3) <= l3);
            byteBuffer.put(this._buf, 0, n3);
        }
        if (this._verbose > 1) {
            Utils.log.fine("readInputFn(" + l2 + "," + l3 + ") => " + l4 + " steps=" + n2);
        }
        this._estByteLimit = l3 > 100L ? this._byteCount + l3 : (this._byteCount + l4) * 20L;
        this._byteCount += l4;
        this.updateProgress();
        return l4;
    }

    private void updateProgress() {
        double d2 = this._segCount;
        if (this._estByteLimit > 0L && this._byteCount > 0L) {
            d2 += (double)this._byteCount / (double)this._estByteLimit;
        }
        double d3 = this._fileCount;
        double d4 = 0.33 * d2 / (double)Math.max(this._estSegLimit, 1) + 0.67 * d3 / (double)Math.max(this._estFileLimit, 1);
        int n2 = (int)Math.round(100.0 * d4);
        if (n2 > 100) {
            n2 = 100;
        }
        if (n2 > this._prevPercent) {
            this._prevPercent = n2;
            this._props.setInteger("unpack.progress", n2);
            if (this._verbose > 0) {
                Utils.log.info("progress = " + n2);
            }
        }
    }

    private void copyInOption(String string) {
        boolean bl2;
        String string2 = this._props.getProperty(string);
        if (this._verbose > 0) {
            Utils.log.info("set " + string + "=" + string2);
        }
        if (string2 != null && !(bl2 = this.setOption(string, string2))) {
            Utils.log.warning("Invalid option " + string + "=" + string2);
        }
    }

    void run(InputStream inputStream, JarOutputStream jarOutputStream, ByteBuffer byteBuffer) throws IOException {
        BufferedInputStream bufferedInputStream;
        this.in = bufferedInputStream = new BufferedInputStream(inputStream);
        this._verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
        int n2 = "keep".equals(this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "0")) ? 0 : this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time");
        this.copyInOption("com.sun.java.util.jar.pack.verbose");
        this.copyInOption("unpack.deflate.hint");
        if (n2 == 0) {
            this.copyInOption("com.sun.java.util.jar.pack.unpack.modification.time");
        }
        this.updateProgress();
        while (true) {
            long l2 = this.start(byteBuffer, 0L);
            this._estByteLimit = 0L;
            this._byteCount = 0L;
            ++this._segCount;
            int n3 = (int)(l2 >>> 32);
            int n4 = (int)(l2 >>> 0);
            this._estSegLimit = this._segCount + n3;
            double d2 = this._fileCount + n4;
            this._estFileLimit = (int)(d2 * (double)this._estSegLimit / (double)this._segCount);
            int[] nArray = new int[]{0, 0, 0, 0};
            Object[] objectArray = new Object[]{nArray, null, null, null};
            while (this.getNextFile(objectArray)) {
                String string = (String)objectArray[1];
                long l3 = ((long)nArray[0] << 32) + ((long)nArray[1] << 32 >>> 32);
                long l4 = n2 != 0 ? (long)n2 : (long)nArray[2];
                boolean bl2 = nArray[3] != 0;
                ByteBuffer byteBuffer2 = (ByteBuffer)objectArray[2];
                ByteBuffer byteBuffer3 = (ByteBuffer)objectArray[3];
                this.writeEntry(jarOutputStream, string, l4, l3, bl2, byteBuffer2, byteBuffer3);
                ++this._fileCount;
                this.updateProgress();
            }
            long l5 = this.finish();
            if (this._verbose > 0) {
                Utils.log.info("bytes consumed = " + l5);
            }
            if ((byteBuffer = this.getUnusedInput()) == null && !Utils.isPackMagic(Utils.readMagic(bufferedInputStream))) break;
            if (this._verbose <= 0 || byteBuffer == null) continue;
            Utils.log.info("unused input = " + byteBuffer);
        }
    }

    void run(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
        this.run(inputStream, jarOutputStream, null);
    }

    void run(File file, JarOutputStream jarOutputStream) throws IOException {
        ByteBuffer byteBuffer = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.run(fileInputStream, jarOutputStream, byteBuffer);
        fileInputStream.close();
    }

    private void writeEntry(JarOutputStream jarOutputStream, String string, long l2, long l3, boolean bl2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        int n2;
        int n3;
        int n4 = (int)l3;
        if ((long)n4 != l3) {
            throw new IOException("file too large: " + l3);
        }
        CRC32 cRC32 = this._crc32;
        if (this._verbose > 1) {
            Utils.log.fine("Writing entry: " + string + " size=" + n4 + (bl2 ? " deflated" : ""));
        }
        if (this._buf.length < n4) {
            n3 = n4;
            while (n3 < this._buf.length) {
                if ((n3 <<= 1) > 0) continue;
                n3 = n4;
                break;
            }
            this._buf = new byte[n3];
        }
        assert (this._buf.length >= n4);
        n3 = 0;
        if (byteBuffer != null) {
            n2 = byteBuffer.capacity();
            byteBuffer.get(this._buf, n3, n2);
            n3 += n2;
        }
        if (byteBuffer2 != null) {
            n2 = byteBuffer2.capacity();
            byteBuffer2.get(this._buf, n3, n2);
            n3 += n2;
        }
        while (n3 < n4) {
            n2 = this.in.read(this._buf, n3, n4 - n3);
            if (n2 <= 0) {
                throw new IOException("EOF at end of archive");
            }
            n3 += n2;
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l2 * 1000L);
        if (n4 == 0) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
            zipEntry.setCompressedSize(0L);
        } else if (!bl2) {
            zipEntry.setMethod(0);
            zipEntry.setSize(n4);
            zipEntry.setCompressedSize(n4);
            cRC32.reset();
            cRC32.update(this._buf, 0, n4);
            zipEntry.setCrc(cRC32.getValue());
        } else {
            zipEntry.setMethod(8);
            zipEntry.setSize(n4);
        }
        jarOutputStream.putNextEntry(zipEntry);
        if (n4 > 0) {
            jarOutputStream.write(this._buf, 0, n4);
        }
        jarOutputStream.closeEntry();
        if (this._verbose > 0) {
            Utils.log.info("Writing " + Utils.zeString(zipEntry));
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("unpack"));
        NativeUnpack.initIDs();
    }
}

