/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpUnknownModelException;
import com.sun.jmx.snmp.agent.LongList;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpAccessControlModel;
import com.sun.jmx.snmp.internal.SnmpEngineImpl;
import com.sun.jmx.trace.Trace;

class AcmChecker {
    SnmpAccessControlModel model;
    String principal;
    int securityLevel;
    int version;
    int pduType;
    int securityModel;
    byte[] contextName;
    SnmpEngineImpl engine;
    LongList l;

    AcmChecker(SnmpMibRequest snmpMibRequest) {
        block5: {
            this.model = null;
            this.principal = null;
            this.securityLevel = -1;
            this.version = -1;
            this.pduType = -1;
            this.securityModel = -1;
            this.contextName = null;
            this.engine = null;
            this.l = null;
            this.engine = (SnmpEngineImpl)snmpMibRequest.getEngine();
            if (this.engine != null && this.engine.isCheckOidActivated()) {
                try {
                    if (AcmChecker.isDebugOn()) {
                        AcmChecker.debug("AcmChecker", " SNMP V3 Access Control to be done.");
                    }
                    this.model = (SnmpAccessControlModel)this.engine.getAccessControlSubSystem().getModel(3);
                    this.principal = snmpMibRequest.getPrincipal();
                    this.securityLevel = snmpMibRequest.getSecurityLevel();
                    this.pduType = snmpMibRequest.getPdu().type;
                    this.version = snmpMibRequest.getRequestPduVersion();
                    this.securityModel = snmpMibRequest.getSecurityModel();
                    this.contextName = snmpMibRequest.getAccessContextName();
                    this.l = new LongList();
                    if (AcmChecker.isDebugOn()) {
                        AcmChecker.debug("AcmChecker", "Will check oid for : principal : " + this.principal + ";securityLevel : " + this.securityLevel + ";pduType : " + this.pduType + ";version : " + this.version + ";securityModel : " + this.securityModel + ";contextName : " + (this.contextName == null ? null : new String(this.contextName)));
                    }
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    if (!AcmChecker.isDebugOn()) break block5;
                    AcmChecker.debug("AcmChecker", " Unknown Model, no ACM check.");
                }
            }
        }
    }

    void add(int n2, long l2) {
        if (this.model != null) {
            this.l.add(n2, l2);
        }
    }

    void remove(int n2) {
        if (this.model != null) {
            this.l.remove(n2);
        }
    }

    void add(int n2, long[] lArray, int n3, int n4) {
        if (this.model != null) {
            this.l.add(n2, lArray, n3, n4);
        }
    }

    void remove(int n2, int n3) {
        if (this.model != null) {
            this.l.remove(n2, n3);
        }
    }

    void checkCurrentOid() throws SnmpStatusException {
        if (this.model != null) {
            SnmpOid snmpOid = new SnmpOid(this.l.toArray());
            if (AcmChecker.isDebugOn()) {
                AcmChecker.debug("check", " Checking access for : " + snmpOid);
            }
            this.model.checkAccess(this.version, this.principal, this.securityLevel, this.pduType, this.securityModel, this.contextName, snmpOid);
        }
    }

    private static final boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    private static final void debug(String string, String string2) {
        Trace.send(2, 256, "AcmChecker", string, string2);
    }
}

