/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import com.sun.jmx.trace.Trace;
import java.util.Vector;

class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected String dbgTag = this.makeDebugTag();
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        this(snmpMibAgent, snmpPdu);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl2) {
        this(snmpMibAgent, snmpPdu, bl2);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        if (this.isTraceOn()) {
            this.trace("constructor", "creating instance for request " + String.valueOf(snmpPdu.requestId));
        }
        this.version = snmpPdu.version;
        this.type = snmpPdu.type;
        this.agent = snmpMibAgent;
        this.reqPdu = snmpPdu;
        int n2 = snmpPdu.varBindList.length;
        this.translation = new int[n2];
        this.varBind = new NonSyncVector(n2);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl2) {
        this(snmpMibAgent, snmpPdu);
        int n2 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.translation[i2] = i2;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[i2]);
        }
    }

    SnmpMibRequest createMibRequest(Vector vector, int n2, Object object) {
        if (this.type == 163 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest snmpMibRequest = null;
        snmpMibRequest = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vector, n2, object, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vector, n2, object);
        if (this.type == 253) {
            this.mibRequest = snmpMibRequest;
        }
        return snmpMibRequest;
    }

    void setUserData(Object object) {
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block20: {
            try {
                var1_1 = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 160: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl10:
                            // 1 sources

                            break;
                        }
                        case 161: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 163: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        case 253: {
                            if (this.isTraceOn()) {
                                this.trace("run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (this.isDebugOn()) {
                                this.debug("run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 5;
                            this.errorIndex = 1;
                            break;
                        }
                    }
                }
                finally {
                    ThreadContext.restore(var1_1);
                }
            }
            catch (SnmpStatusException var1_2) {
                this.errorStatus = var1_2.getStatus();
                this.errorIndex = var1_2.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                    this.debug("run", var1_2);
                }
            }
            catch (Exception var1_3) {
                this.errorStatus = 5;
                if (this.isTraceOn()) {
                    this.trace("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
                }
                if (!this.isDebugOn()) break block20;
                this.debug("run", "Error is: " + var1_3);
                this.debug("run", var1_3);
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 5) {
            return 5;
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 224 || n2 == 225 || n2 == 6 || n2 == 18 || n2 == 16) {
            return 2;
        }
        if (n2 == 16 || n2 == 17) {
            if (n3 == 253) {
                return 4;
            }
            return 2;
        }
        if (n2 == 11) {
            return 2;
        }
        if (n2 == 7 || n2 == 8 || n2 == 9 || n2 == 10 || n2 == 8 || n2 == 12) {
            if (n3 == 163 || n3 == 253) {
                return 3;
            }
            return 2;
        }
        if (n2 == 13 || n2 == 14 || n2 == 15) {
            return 5;
        }
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 3 || n2 == 4) {
            if (n3 == 163 || n3 == 253) {
                return n2;
            }
            return 2;
        }
        return 5;
    }

    static final int mapErrorStatusToV2(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 5) {
            return 5;
        }
        if (n2 == 1) {
            return 1;
        }
        if (n3 != 163 && n3 != 253) {
            if (n2 == 16) {
                return n2;
            }
            return 5;
        }
        if (n2 == 2) {
            return 6;
        }
        if (n2 == 4) {
            return 17;
        }
        if (n2 == 3) {
            return 10;
        }
        if (n2 == 6 || n2 == 18 || n2 == 16 || n2 == 17 || n2 == 11 || n2 == 7 || n2 == 8 || n2 == 9 || n2 == 10 || n2 == 8 || n2 == 12 || n2 == 13 || n2 == 14 || n2 == 15) {
            return n2;
        }
        return 5;
    }

    static final int mapErrorStatus(int n2, int n3, int n4) {
        if (n2 == 0) {
            return 0;
        }
        if (n3 == 0) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(n2, n4);
        }
        if (n3 == 1 || n3 == 3) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(n2, n4);
        }
        return 5;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n2) {
        int n3 = this.varBind.size();
        this.translation[n3] = n2;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n2 = this.varBind.size();
        int n3 = snmpVarBindArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.translation[i2];
            if (n4 < n3) {
                snmpVarBindArray[n4] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(i2);
                continue;
            }
            this.debug("updateResult", "Position `" + n4 + "' is out of bound...");
        }
    }

    private void init(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest) {
        this.incRequest = snmpIncomingRequest;
        this.engine = snmpEngine;
    }

    protected boolean isTraceOn() {
        return Trace.isSelected(1, 256);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, 256, string, string2, string3);
    }

    protected void debug(String string, Throwable throwable) {
        Trace.send(2, 256, this.dbgTag, string, throwable);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected String makeDebugTag() {
        return "SnmpSubRequestHandler";
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n2) {
            super(n2);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n2) {
            return this.elementData[n2];
        }
    }
}

