/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.Connections;
import com.sun.jndi.ldap.pool.ConnectionsRef;
import com.sun.jndi.ldap.pool.ConnectionsWeakRef;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.naming.NamingException;

public final class Pool {
    static final boolean debug = LdapPoolManager.debug;
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Collection weakRefs = Collections.synchronizedList(new LinkedList());
    private final int maxSize;
    private final int prefSize;
    private final int initSize;
    private final Map map = new WeakHashMap();

    public Pool(int n2, int n3, int n4) {
        this.prefSize = n3;
        this.maxSize = n4;
        this.initSize = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(Object object, long l2, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        Connections connections;
        this.d("get(): ", object);
        this.d("size: ", this.map.size());
        Pool.expungeStaleConnections();
        Map map = this.map;
        synchronized (map) {
            connections = this.getConnections(object);
            if (connections == null) {
                this.d("get(): creating new connections list for ", object);
                connections = new Connections(object, this.initSize, this.prefSize, this.maxSize, pooledConnectionFactory);
                ConnectionsRef connectionsRef = new ConnectionsRef(connections);
                this.map.put(object, connectionsRef);
                ConnectionsWeakRef connectionsWeakRef = new ConnectionsWeakRef(connectionsRef, queue);
                weakRefs.add(connectionsWeakRef);
            }
        }
        this.d("get(): size after: ", this.map.size());
        return connections.get(l2, pooledConnectionFactory);
    }

    private Connections getConnections(Object object) {
        ConnectionsRef connectionsRef = (ConnectionsRef)this.map.get(object);
        return connectionsRef != null ? connectionsRef.getConnections() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(long l2) {
        Map map = this.map;
        synchronized (map) {
            Collection collection = this.map.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Connections connections = ((ConnectionsRef)iterator.next()).getConnections();
                if (!connections.expire(l2)) continue;
                this.d("expire(): removing ", connections);
                iterator.remove();
            }
        }
        Pool.expungeStaleConnections();
    }

    private static void expungeStaleConnections() {
        ConnectionsWeakRef connectionsWeakRef = null;
        while ((connectionsWeakRef = (ConnectionsWeakRef)queue.poll()) != null) {
            Connections connections = connectionsWeakRef.getConnections();
            if (debug) {
                System.err.println("weak reference cleanup: Closing Connections:" + connections);
            }
            connections.close();
            weakRefs.remove(connectionsWeakRef);
            connectionsWeakRef.clear();
        }
    }

    public void showStats(PrintStream printStream) {
        printStream.println("===== Pool start ======================");
        printStream.println("maximum pool size: " + this.maxSize);
        printStream.println("preferred pool size: " + this.prefSize);
        printStream.println("initial pool size: " + this.initSize);
        printStream.println("current pool size: " + this.map.size());
        Set set = this.map.entrySet();
        for (Map.Entry entry : set) {
            Object k2 = entry.getKey();
            Connections connections = ((ConnectionsRef)entry.getValue()).getConnections();
            printStream.println("   " + k2 + ":" + connections.getStats());
        }
        printStream.println("====== Pool end =====================");
    }

    public String toString() {
        return super.toString() + " " + this.map.toString();
    }

    private void d(String string, int n2) {
        if (debug) {
            System.err.println(this + "." + string + n2);
        }
    }

    private void d(String string, Object object) {
        if (debug) {
            System.err.println(this + "." + string + object);
        }
    }
}

