/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.HeadspaceInstrument;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.HeadspaceSoundbank;
import com.sun.media.sound.MixerMidiChannel;
import com.sun.media.sound.Platform;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.VoiceStatus;

abstract class AbstractPlayer
extends AbstractMidiDevice {
    private static final String[] defaultSoundbankNames = new String[]{"soundbank-deluxe.gm", "soundbank-mid.gm", "soundbank.gm", "soundbank-min.gm"};
    private static final String soundJarName = "sound.jar";
    private static final String jmfJarName = "jmf.jar";
    static HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
    private static Soundbank defaultSoundbank = null;
    AbstractMidiDevice internalSynth = null;
    protected MixerMidiChannel[] channels;
    private Vector instruments = new Vector();

    protected AbstractPlayer(MidiDevice.Info info) {
        super(info);
        this.channels = new MixerMidiChannel[16];
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2] = new MixerMidiChannel(this, i2);
        }
    }

    public int getMaxPolyphony() {
        return HeadspaceMixer.getMixerInstance().getMidiVoices();
    }

    public MidiChannel[] getChannels() {
        MidiChannel[] midiChannelArray = new MidiChannel[this.channels.length];
        System.arraycopy(this.channels, 0, midiChannelArray, 0, this.channels.length);
        return midiChannelArray;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof HeadspaceSoundbank;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (this.instruments.contains(instrument)) {
            return true;
        }
        try {
            if (this.nLoadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.addElement(instrument);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public void unloadInstrument(Instrument instrument) {
        try {
            if (this.nUnloadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.removeElement(instrument);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        try {
            return this.nRemapInstrument(this.id, ((HeadspaceInstrument)instrument).getId(), ((HeadspaceInstrument)instrument2).getId());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank() + " or " + instrument2.getSoundbank());
        }
    }

    public Soundbank getDefaultSoundbank() {
        return defaultSoundbank;
    }

    public Instrument[] getAvailableInstruments() {
        if (defaultSoundbank != null) {
            return defaultSoundbank.getInstruments();
        }
        return new Instrument[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument[] getLoadedInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
                instrumentArray[i2] = (Instrument)this.instruments.elementAt(i2);
            }
        }
        return instrumentArray;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        boolean bl2 = true;
        Instrument[] instrumentArray = soundbank.getInstruments();
        for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
            if (this.loadInstrument(instrumentArray[i2])) continue;
            bl2 = false;
        }
        return bl2;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
        Instrument[] instrumentArray = soundbank.getInstruments();
        for (int i2 = 0; i2 < instrumentArray.length; ++i2) {
            this.unloadInstrument(instrumentArray[i2]);
        }
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < patchArray.length; ++i2) {
            Instrument instrument = soundbank.getInstrument(patchArray[i2]);
            if (instrument != null) {
                if (this.loadInstrument(instrument)) continue;
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
        for (int i2 = 0; i2 < patchArray.length; ++i2) {
            Instrument instrument = soundbank.getInstrument(patchArray[i2]);
            if (instrument == null) continue;
            this.unloadInstrument(instrument);
        }
    }

    protected abstract long getTimeStamp();

    protected void openInternalSynth() throws MidiUnavailableException {
        if (this.internalSynth != null) {
            return;
        }
        if (defaultSoundbank == null) {
            defaultSoundbank = this.loadDefaultSoundbank();
        }
        this.internalSynth = this.openSoftwareSynth();
    }

    protected void closeInternalSynth() {
        if (this.internalSynth == this) {
            this.nRemoveReceiver(this.id, 0L);
        }
        this.internalSynth = null;
    }

    protected AbstractMidiDevice openSoftwareSynth() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToInternalSynth() {
        if (this.internalSynth == null) {
            return;
        }
        if (this.internalSynth == this) {
            AbstractPlayer abstractPlayer = this;
            synchronized (abstractPlayer) {
                this.nAddReceiver(this.id, 0L);
            }
        }
    }

    protected synchronized void implClose() {
        this.closeInternalSynth();
        long l2 = this.id;
        this.id = 0L;
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2].setId(this.id);
        }
        this.nClose(l2);
        super.implClose();
    }

    private Soundbank loadDefaultSoundbank() {
        HeadspaceSoundbank headspaceSoundbank = null;
        for (int i2 = 0; i2 < defaultSoundbankNames.length; ++i2) {
            String string;
            String string2 = defaultSoundbankNames[i2];
            try {
                string = "file:" + string2;
                URL uRL = new URL(string);
                headspaceSoundbank = new HeadspaceSoundbank(uRL);
                if (headspaceSoundbank != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String string3 = Platform.getClasspath();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && headspaceSoundbank == null) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1, string4.length());
                if (!string5.equals(soundJarName) && !string5.equals(jmfJarName)) continue;
                string = string4.substring(0, string4.lastIndexOf(File.separatorChar));
                string = string + File.separatorChar + string2;
                try {
                    headspaceSoundbank = new HeadspaceSoundbank(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (headspaceSoundbank != null) break;
            string = Platform.getJavahome();
            string = string + File.separatorChar + "lib" + File.separatorChar + "audio" + File.separatorChar + string2;
            try {
                headspaceSoundbank = new HeadspaceSoundbank(string);
                if (headspaceSoundbank == null) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return headspaceSoundbank;
    }

    protected native void nClose(long var1);

    protected native void nAddReceiver(long var1, long var3);

    protected native void nRemoveReceiver(long var1, long var3);

    private native boolean nLoadInstrument(long var1, int var3);

    private native boolean nUnloadInstrument(long var1, int var3);

    private native boolean nRemapInstrument(long var1, int var3, int var4);
}

