/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int n2, int n3, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n2, n3, constantPool);
        this.setStackMap(stackMapEntryArray);
    }

    StackMap(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n2, n3, (StackMapEntry[])null, constantPool);
        this.map_length = dataInputStream.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            this.map[i2] = new StackMapEntry(dataInputStream, constantPool);
        }
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map_length);
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            this.map[i2].dump(dataOutputStream);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        this.map_length = stackMapEntryArray == null ? 0 : stackMapEntryArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap(");
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            stringBuffer.append(this.map[i2].toString());
            if (i2 >= this.map_length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.map = new StackMapEntry[this.map_length];
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            stackMap.map[i2] = this.map[i2].copy();
        }
        stackMap.constant_pool = constantPool;
        return stackMap;
    }

    public void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

