/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.regexp.internal;

import com.sun.org.apache.regexp.internal.RE;
import com.sun.org.apache.regexp.internal.REDebugCompiler;
import com.sun.org.apache.regexp.internal.REProgram;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class RETest {
    RE r = new RE();
    REDebugCompiler compiler = new REDebugCompiler();
    static final boolean showSuccesses = false;
    char[] re1Instructions = new char[]{'|', '\u0000', '\u001a', '|', '\u0000', '\r', 'A', '\u0001', '\u0004', 'a', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff6', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', 'b', 'E', '\u0000', '\u0000'};
    REProgram re1 = new REProgram(this.re1Instructions);
    String expr;
    int n = 0;
    int failures = 0;

    public static void _main(String[] stringArray) {
        try {
            RETest.test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean test() throws Exception {
        RETest rETest = new RETest();
        rETest.runAutomatedTests("docs/RETest.txt");
        return rETest.failures == 0;
    }

    public RETest() {
    }

    public RETest(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                this.runInteractiveTests(stringArray[1]);
            } else if (stringArray.length == 1) {
                this.runAutomatedTests(stringArray[0]);
            } else {
                System.out.println("Usage: RETest ([-i] [regex]) ([/path/to/testfile.txt])");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void runInteractiveTests(String string) {
        try {
            this.r.setProgram(this.compiler.compile(string));
            this.say("\n" + string + "\n");
            this.compiler.dumpProgram(new PrintWriter(System.out));
            while (true) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("> ");
                System.out.flush();
                String string2 = bufferedReader.readLine();
                if (this.r.match(string2)) {
                    this.say("Match successful.");
                } else {
                    this.say("Match failed.");
                }
                this.showParens(this.r);
            }
        }
        catch (Exception exception) {
            this.say("Error: " + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    void die(String string) {
        this.say("FATAL ERROR: " + string);
        System.exit(0);
    }

    void fail(String string) {
        ++this.failures;
        this.say("\n");
        this.say("*******************************************************");
        this.say("*********************  FAILURE!  **********************");
        this.say("*******************************************************");
        this.say("\n");
        this.say(string);
        this.say("");
        this.compiler.dumpProgram(new PrintWriter(System.out));
        this.say("\n");
    }

    void success(String string) {
    }

    void say(String string) {
        System.out.println(string);
    }

    void show() {
        this.say("\n-----------------------\n");
        this.say("Expression #" + this.n + " \"" + this.expr + "\" ");
    }

    void showParens(RE rE) {
        for (int i2 = 0; i2 < rE.getParenCount(); ++i2) {
            this.say("$" + i2 + " = " + rE.getParen(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAutomatedTests(String string) throws Exception {
        long l2;
        block24: {
            l2 = System.currentTimeMillis();
            RE rE = new RE(this.re1);
            this.say("a*b");
            this.say("aaaab = " + rE.match("aaab"));
            this.showParens(rE);
            this.say("b = " + rE.match("b"));
            this.showParens(rE);
            this.say("c = " + rE.match("c"));
            this.showParens(rE);
            this.say("ccccaaaaab = " + rE.match("ccccaaaaab"));
            this.showParens(rE);
            rE = new RE("a*b");
            Object[] objectArray = rE.split("xxxxaabxxxxbyyyyaaabzzz");
            rE = new RE("x+");
            objectArray = rE.grep(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                System.out.println("s[" + i2 + "] = " + (String)objectArray[i2]);
            }
            rE = new RE("a*b");
            String string2 = rE.subst("aaaabfooaaabgarplyaaabwackyb", "-");
            System.out.println("s = " + string2);
            File file = new File(string);
            if (!file.exists()) {
                throw new Exception("Could not find: " + string);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            block10: while (true) {
                while (bufferedReader.ready()) {
                    String string3;
                    String string4 = "";
                    while (bufferedReader.ready() && (string4 = bufferedReader.readLine()) != null && !(string4 = string4.trim()).startsWith("#")) {
                        if (string4.equals("")) continue;
                        System.out.println("Script error.  Line = " + string4);
                        System.exit(0);
                    }
                    if (!bufferedReader.ready()) {
                        break block24;
                    }
                    this.expr = bufferedReader.readLine();
                    ++this.n;
                    this.say("");
                    this.say(this.n + ". " + this.expr);
                    this.say("");
                    try {
                        rE.setProgram(this.compiler.compile(this.expr));
                    }
                    catch (Exception exception) {
                        string3 = bufferedReader.readLine().trim();
                        if (string3.equals("ERR")) {
                            this.say("   Match: ERR");
                            this.success("Produces an error (" + exception.toString() + "), as expected.");
                            continue;
                        }
                        this.fail("Produces the unexpected error \"" + exception.getMessage() + "\"");
                    }
                    catch (Error error) {
                        this.fail("Compiler threw fatal error \"" + error.getMessage() + "\"");
                        error.printStackTrace();
                    }
                    String string5 = bufferedReader.readLine().trim();
                    this.say("   Match against: '" + string5 + "'");
                    if (string5.equals("ERR")) {
                        this.fail("Was expected to be an error, but wasn't.");
                        continue;
                    }
                    try {
                        boolean bl2 = rE.match(string5);
                        string3 = bufferedReader.readLine().trim();
                        if (bl2) {
                            this.say("   Match: YES");
                            if (string3.equals("NO")) {
                                this.fail("Matched \"" + string5 + "\", when not expected to.");
                                continue block10;
                            }
                            if (string3.equals("YES")) {
                                this.success("Matched \"" + string5 + "\", as expected:");
                                this.say("   Paren count: " + rE.getParenCount());
                                int n2 = 0;
                                while (true) {
                                    if (n2 >= rE.getParenCount()) continue block10;
                                    String string6 = bufferedReader.readLine().trim();
                                    this.say("   Paren " + n2 + " : " + rE.getParen(n2));
                                    if (!string6.equals(rE.getParen(n2))) {
                                        this.fail("Register " + n2 + " should be = \"" + string6 + "\", but is \"" + rE.getParen(n2) + "\" instead.");
                                    }
                                    ++n2;
                                }
                            }
                            this.die("Test script error!");
                            continue block10;
                        }
                        this.say("   Match: NO");
                        if (string3.equals("YES")) {
                            this.fail("Did not match \"" + string5 + "\", when expected to.");
                            continue block10;
                        }
                        if (string3.equals("NO")) {
                            this.success("Did not match \"" + string5 + "\", as expected.");
                            continue block10;
                        }
                        this.die("Test script error!");
                        continue block10;
                    }
                    catch (Exception exception) {
                        this.fail("Matcher threw exception: " + exception.toString());
                        exception.printStackTrace();
                    }
                    catch (Error error) {
                        this.fail("Matcher threw fatal error \"" + error.getMessage() + "\"");
                        error.printStackTrace();
                    }
                }
                break block24;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                bufferedReader.close();
            }
        }
        System.out.println("\n\nMatch time = " + (System.currentTimeMillis() - l2) + " ms.");
        System.out.println("\nTests complete.  " + this.n + " tests, " + this.failures + " failure(s).");
    }
}

