/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.CollatorFactory;
import com.sun.org.apache.xalan.internal.xsltc.DOM;
import com.sun.org.apache.xalan.internal.xsltc.TransletException;
import com.sun.org.apache.xalan.internal.xsltc.dom.ObjectFactory;
import com.sun.org.apache.xalan.internal.xsltc.dom.SortSettings;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xml.internal.utils.StringComparable;
import java.text.Collator;
import java.util.Locale;

public abstract class NodeSortRecord {
    public static final int COMPARE_STRING = 0;
    public static final int COMPARE_NUMERIC = 1;
    public static final int COMPARE_ASCENDING = 0;
    public static final int COMPARE_DESCENDING = 1;
    private static final Collator DEFAULT_COLLATOR = Collator.getInstance();
    protected Collator _collator = DEFAULT_COLLATOR;
    protected Collator[] _collators;
    protected Locale _locale;
    protected CollatorFactory _collatorFactory;
    protected SortSettings _settings;
    private DOM _dom = null;
    private int _node;
    private int _last = 0;
    private int _scanned = 0;
    private Object[] _values;

    public NodeSortRecord(int n2) {
        this._node = n2;
    }

    public NodeSortRecord() {
        this(0);
    }

    public final void initialize(int n2, int n3, DOM dOM, SortSettings sortSettings) throws TransletException {
        this._dom = dOM;
        this._node = n2;
        this._last = n3;
        this._settings = sortSettings;
        int n4 = sortSettings.getSortOrders().length;
        this._values = new Object[n4];
        String string = System.getProperty("com.sun.org.apache.xalan.internal.xsltc.COLLATOR_FACTORY");
        if (string != null) {
            Locale[] localeArray;
            try {
                localeArray = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
                this._collatorFactory = (CollatorFactory)localeArray;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TransletException(classNotFoundException);
            }
            localeArray = sortSettings.getLocales();
            this._collators = new Collator[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                this._collators[i2] = this._collatorFactory.getCollator(localeArray[i2]);
            }
            this._collator = this._collators[0];
        } else {
            this._collators = sortSettings.getCollators();
            this._collator = this._collators[0];
        }
    }

    public final int getNode() {
        return this._node;
    }

    public final int compareDocOrder(NodeSortRecord nodeSortRecord) {
        return this._node - nodeSortRecord._node;
    }

    private final Comparable stringValue(int n2) {
        if (this._scanned <= n2) {
            AbstractTranslet abstractTranslet = this._settings.getTranslet();
            Locale[] localeArray = this._settings.getLocales();
            String[] stringArray = this._settings.getCaseOrders();
            String string = this.extractValueFromDOM(this._dom, this._node, n2, abstractTranslet, this._last);
            Comparable comparable = StringComparable.getComparator(string, localeArray[n2], this._collators[n2], stringArray[n2]);
            this._values[this._scanned++] = comparable;
            return comparable;
        }
        return (Comparable)this._values[n2];
    }

    private final Double numericValue(int n2) {
        if (this._scanned <= n2) {
            Double d2;
            AbstractTranslet abstractTranslet = this._settings.getTranslet();
            String string = this.extractValueFromDOM(this._dom, this._node, n2, abstractTranslet, this._last);
            try {
                d2 = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = new Double(Double.NEGATIVE_INFINITY);
            }
            this._values[this._scanned++] = d2;
            return d2;
        }
        return (Double)this._values[n2];
    }

    public int compareTo(NodeSortRecord nodeSortRecord) {
        int[] nArray = this._settings.getSortOrders();
        int n2 = this._settings.getSortOrders().length;
        int[] nArray2 = this._settings.getTypes();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Comparable<Double> comparable;
            Comparable<Double> comparable2;
            if (nArray2[i2] == 1) {
                comparable2 = this.numericValue(i2);
                comparable = nodeSortRecord.numericValue(i2);
                n3 = ((Double)comparable2).compareTo((Double)comparable);
            } else {
                comparable2 = this.stringValue(i2);
                comparable = nodeSortRecord.stringValue(i2);
                n3 = comparable2.compareTo((Double)comparable);
            }
            if (n3 == 0) continue;
            return nArray[i2] == 1 ? 0 - n3 : n3;
        }
        return this._node - nodeSortRecord._node;
    }

    public Collator[] getCollator() {
        return this._collators;
    }

    public abstract String extractValueFromDOM(DOM var1, int var2, int var3, AbstractTranslet var4, int var5);
}

