/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected static final int TABLE_SIZE = 101;
    protected static final int SIZE_LIMIT = 20;
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int n2) {
        this.fTableViewBuckets = n2;
        for (int i2 = 0; i2 < this.fAttributes.length; ++i2) {
            this.fAttributes[i2] = new Attribute();
        }
    }

    public void setNamespaces(boolean bl2) {
        this.fNamespaces = bl2;
    }

    public int addAttribute(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n2;
        if (this.fLength < 20) {
            int n3 = n2 = qName.uri != null && !qName.uri.equals("") ? this.getIndexFast(qName.uri, qName.localpart) : this.getIndexFast(qName.rawname);
            if (n2 == -1) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    attributeArray = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                    for (int i2 = this.fAttributes.length; i2 < attributeArray.length; ++i2) {
                        attributeArray[i2] = new Attribute();
                    }
                    this.fAttributes = attributeArray;
                }
            }
        } else if (qName.uri == null || qName.uri.length() == 0 || (n2 = this.getIndexFast(qName.uri, qName.localpart)) == -1) {
            int n4;
            if (!this.fIsTableViewConsistent || this.fLength == 20) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[n4 = this.getTableViewBucket(qName.rawname)] != this.fLargeCount) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributeArray2 = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributeArray2, 0, this.fAttributes.length);
                    for (int i3 = this.fAttributes.length; i3 < attributeArray2.length; ++i3) {
                        attributeArray2[i3] = new Attribute();
                    }
                    this.fAttributes = attributeArray2;
                }
                this.fAttributeTableViewChainState[n4] = this.fLargeCount;
                this.fAttributes[n2].next = null;
                this.fAttributeTableView[n4] = this.fAttributes[n2];
            } else {
                Attribute attribute = this.fAttributeTableView[n4];
                while (attribute != null && attribute.name.rawname != qName.rawname) {
                    attribute = attribute.next;
                }
                if (attribute == null) {
                    n2 = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributeArray3 = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributeArray3, 0, this.fAttributes.length);
                        for (int i4 = this.fAttributes.length; i4 < attributeArray3.length; ++i4) {
                            attributeArray3[i4] = new Attribute();
                        }
                        this.fAttributes = attributeArray3;
                    }
                    this.fAttributes[n2].next = this.fAttributeTableView[n4];
                    this.fAttributeTableView[n4] = this.fAttributes[n2];
                } else {
                    n2 = this.getIndexFast(qName.rawname);
                }
            }
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        return n2;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int n2) {
        this.fIsTableViewConsistent = false;
        if (n2 < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n2];
            System.arraycopy(this.fAttributes, n2 + 1, this.fAttributes, n2, this.fLength - n2 - 1);
            this.fAttributes[this.fLength - 1] = attribute;
        }
        --this.fLength;
    }

    public void setName(int n2, QName qName) {
        this.fAttributes[n2].name.setValues(qName);
    }

    public void getName(int n2, QName qName) {
        qName.setValues(this.fAttributes[n2].name);
    }

    public void setType(int n2, String string) {
        this.fAttributes[n2].type = string;
    }

    public void setValue(int n2, String string) {
        Attribute attribute = this.fAttributes[n2];
        attribute.value = string;
        attribute.nonNormalizedValue = string;
    }

    public void setNonNormalizedValue(int n2, String string) {
        if (string == null) {
            string = this.fAttributes[n2].value;
        }
        this.fAttributes[n2].nonNormalizedValue = string;
    }

    public String getNonNormalizedValue(int n2) {
        String string = this.fAttributes[n2].nonNormalizedValue;
        return string;
    }

    public void setSpecified(int n2, boolean bl2) {
        this.fAttributes[n2].specified = bl2;
    }

    public boolean isSpecified(int n2) {
        return this.fAttributes[n2].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[n2].type);
    }

    public String getType(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    public String getValue(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].value;
    }

    public String getValue(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].value : null;
    }

    public String getName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.rawname;
    }

    public int getIndex(String string) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.rawname == null || !attribute.name.rawname.equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(string2) || string != attribute.name.uri && (string == null || attribute.name.uri == null || !attribute.name.uri.equals(string))) continue;
            return i2;
        }
        return -1;
    }

    public String getLocalName(int n2) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.localpart;
    }

    public String getQName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.rawname;
        return string != null ? string : "";
    }

    public String getType(String string, String string2) {
        if (!this.fNamespaces) {
            return null;
        }
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getType(n2) : null;
    }

    public int getIndexFast(String string) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.rawname != string) continue;
            return i2;
        }
        return -1;
    }

    public void addAttributeNS(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n2 = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            attributeArray = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
            for (int i2 = this.fAttributes.length; i2 < attributeArray.length; ++i2) {
                attributeArray[i2] = new Attribute();
            }
            this.fAttributes = attributeArray;
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
    }

    public QName checkDuplicatesNS() {
        if (this.fLength <= 20) {
            for (int i2 = 0; i2 < this.fLength - 1; ++i2) {
                Attribute attribute = this.fAttributes[i2];
                for (int i3 = i2 + 1; i3 < this.fLength; ++i3) {
                    Attribute attribute2 = this.fAttributes[i3];
                    if (attribute.name.localpart != attribute2.name.localpart || attribute.name.uri != attribute2.name.uri) continue;
                    return attribute2.name;
                }
            }
        } else {
            this.fIsTableViewConsistent = false;
            this.prepareTableView();
            for (int i4 = this.fLength - 1; i4 >= 0; --i4) {
                Attribute attribute = this.fAttributes[i4];
                int n2 = this.getTableViewBucket(attribute.name.localpart, attribute.name.uri);
                if (this.fAttributeTableViewChainState[n2] != this.fLargeCount) {
                    this.fAttributeTableViewChainState[n2] = this.fLargeCount;
                    attribute.next = null;
                    this.fAttributeTableView[n2] = attribute;
                    continue;
                }
                Attribute attribute3 = this.fAttributeTableView[n2];
                while (attribute3 != null) {
                    if (attribute3.name.localpart == attribute.name.localpart && attribute3.name.uri == attribute.name.uri) {
                        return attribute.name;
                    }
                    attribute3 = attribute3.next;
                }
                attribute.next = this.fAttributeTableView[n2];
                this.fAttributeTableView[n2] = attribute;
            }
        }
        return null;
    }

    public int getIndexFast(String string, String string2) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.localpart != string2 || attribute.name.uri != string) continue;
            return i2;
        }
        return -1;
    }

    private String getReportableType(String string) {
        if (string.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return string;
    }

    protected int getTableViewBucket(String string) {
        return (string.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String string, String string2) {
        if (string2 == null) {
            return (string.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (string.hashCode() + string2.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                for (int i2 = this.fTableViewBuckets - 1; i2 >= 0; --i2) {
                    this.fAttributeTableViewChainState[i2] = 0;
                }
            }
            this.fLargeCount = 1;
        }
    }

    protected void prepareTableView() {
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareTableView();
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            int n2 = this.getTableViewBucket(attribute.name.rawname);
            if (this.fAttributeTableViewChainState[n2] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n2] = this.fLargeCount;
                attribute.next = null;
                this.fAttributeTableView[n2] = attribute;
                continue;
            }
            attribute.next = this.fAttributeTableView[n2];
            this.fAttributeTableView[n2] = attribute;
        }
    }

    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.prefix;
        return string != null ? string : "";
    }

    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.uri;
        return string;
    }

    public String getValue(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getValue(n2) : null;
    }

    public Augmentations getAugmentations(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].augs;
    }

    public void setAugmentations(int n2, Augmentations augmentations) {
        this.fAttributes[n2].augs = augmentations;
    }

    public void setURI(int n2, String string) {
        this.fAttributes[n2].name.uri = string;
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public Augmentations augs = new AugmentationsImpl();
        public Attribute next;

        Attribute() {
        }
    }
}

