/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMWSFilter;
import com.sun.org.apache.xml.internal.utils.SystemIDResolver;
import com.sun.org.apache.xpath.internal.SourceTree;
import com.sun.org.apache.xpath.internal.XPathContext;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public String findURIFromDoc(int n2) {
        int n3 = this.m_sourceTree.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (n2 != sourceTree.m_root) continue;
            return sourceTree.m_url;
        }
        return null;
    }

    public Source resolveURI(String string, String string2, SourceLocator sourceLocator) throws TransformerException, IOException {
        Source source = null;
        if (null != this.m_uriResolver) {
            source = this.m_uriResolver.resolve(string2, string);
        }
        if (null == source) {
            String string3 = SystemIDResolver.getAbsoluteURI(string2, string);
            source = new StreamSource(string3);
        }
        return source;
    }

    public void removeDocumentFromCache(int n2) {
        if (-1 == n2) {
            return;
        }
        for (int i2 = this.m_sourceTree.size() - 1; i2 >= 0; --i2) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (sourceTree == null || sourceTree.m_root != n2) continue;
            this.m_sourceTree.removeElementAt(i2);
            return;
        }
    }

    public void putDocumentInCache(int n2, Source source) {
        int n3 = this.getNode(source);
        if (-1 != n3) {
            if (n3 != n2) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (null != source.getSystemId()) {
            this.m_sourceTree.addElement(new SourceTree(n2, source.getSystemId()));
        }
    }

    public int getNode(Source source) {
        String string = source.getSystemId();
        if (null == string) {
            return -1;
        }
        int n2 = this.m_sourceTree.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(i2);
            if (!string.equals(sourceTree.m_url)) continue;
            return sourceTree.m_root;
        }
        return -1;
    }

    public int getSourceTree(String string, String string2, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        try {
            Source source = this.resolveURI(string, string2, sourceLocator);
            return this.getSourceTree(source, sourceLocator, xPathContext);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException.getMessage(), sourceLocator, iOException);
        }
    }

    public int getSourceTree(Source source, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        int n2 = this.getNode(source);
        if (-1 != n2) {
            return n2;
        }
        n2 = this.parseToNode(source, sourceLocator, xPathContext);
        if (-1 != n2) {
            this.putDocumentInCache(n2, source);
        }
        return n2;
    }

    public int parseToNode(Source source, SourceLocator sourceLocator, XPathContext xPathContext) throws TransformerException {
        try {
            Object object = xPathContext.getOwnerObject();
            DTM dTM = null != object && object instanceof DTMWSFilter ? xPathContext.getDTM(source, false, (DTMWSFilter)object, false, true) : xPathContext.getDTM(source, false, null, false, true);
            return dTM.getDocument();
        }
        catch (Exception exception) {
            throw new TransformerException(exception.getMessage(), sourceLocator, exception);
        }
    }

    public static XMLReader getXMLReader(Source source, SourceLocator sourceLocator) throws TransformerException {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException.getMessage(), sourceLocator, sAXException);
        }
    }
}

