/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.CramMD5Base;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class CramMD5Server
extends CramMD5Base
implements SaslServer {
    private String fqdn;
    private byte[] challengeData = null;
    private String authzid;
    private CallbackHandler cbh;

    CramMD5Server(String string, String string2, Map map, CallbackHandler callbackHandler) throws SaslException {
        if (string2 == null) {
            throw new SaslException("CRAM-MD5: fully qualified server name must be specified");
        }
        this.fqdn = string2;
        this.cbh = callbackHandler;
    }

    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 authentication already completed");
        }
        if (this.aborted) {
            throw new IllegalStateException("CRAM-MD5 authentication previously aborted due to error");
        }
        try {
            if (this.challengeData == null) {
                if (byArray.length != 0) {
                    this.aborted = true;
                    throw new SaslException("CRAM-MD5 does not expect any initial response");
                }
                Random random = new Random();
                long l2 = random.nextLong();
                long l3 = System.currentTimeMillis();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('<');
                stringBuffer.append(l2);
                stringBuffer.append('.');
                stringBuffer.append(l3);
                stringBuffer.append('@');
                stringBuffer.append(this.fqdn);
                stringBuffer.append('>');
                String string = stringBuffer.toString();
                logger.log(Level.FINE, "CRAMSRV01:Generated challenge: {0}", string);
                this.challengeData = string.getBytes("UTF8");
                return (byte[])this.challengeData.clone();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "CRAMSRV02:Received response: {0}", new String(byArray, "UTF8"));
            }
            int n2 = 0;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] != 32) continue;
                n2 = i2;
                break;
            }
            if (n2 == 0) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: Invalid response; space missing");
            }
            String string = new String(byArray, 0, n2, "UTF8");
            logger.log(Level.FINE, "CRAMSRV03:Extracted username: {0}", string);
            NameCallback nameCallback = new NameCallback("CRAM-MD5 authentication ID: ", string);
            PasswordCallback passwordCallback = new PasswordCallback("CRAM-MD5 password: ", false);
            this.cbh.handle(new Callback[]{nameCallback, passwordCallback});
            char[] cArray = passwordCallback.getPassword();
            if (cArray == null || cArray.length == 0) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: username not found: " + string);
            }
            passwordCallback.clearPassword();
            String string2 = new String(cArray);
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                cArray[i3] = '\u0000';
            }
            this.pw = string2.getBytes("UTF8");
            String string3 = CramMD5Server.HMAC_MD5(this.pw, this.challengeData);
            logger.log(Level.FINE, "CRAMSRV04:Expecting digest: {0}", string3);
            this.clearPassword();
            byte[] byArray2 = string3.getBytes("UTF8");
            int n3 = byArray.length - n2 - 1;
            if (byArray2.length != n3) {
                this.aborted = true;
                throw new SaslException("Invalid response");
            }
            int n4 = 0;
            for (int i4 = n2 + 1; i4 < byArray.length; ++i4) {
                if (byArray2[n4++] == byArray[i4]) continue;
                this.aborted = true;
                throw new SaslException("Invalid response");
            }
            AuthorizeCallback authorizeCallback = new AuthorizeCallback(string, string);
            this.cbh.handle(new Callback[]{authorizeCallback});
            if (!authorizeCallback.isAuthorized()) {
                this.aborted = true;
                throw new SaslException("CRAM-MD5: user not authorized: " + string);
            }
            this.authzid = authorizeCallback.getAuthorizedID();
            logger.log(Level.FINE, "CRAMSRV05:Authorization id: {0}", this.authzid);
            this.completed = true;
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.aborted = true;
            throw new SaslException("UTF8 not available on platform", unsupportedEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.aborted = true;
            throw new SaslException("MD5 algorithm not available on platform", noSuchAlgorithmException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            this.aborted = true;
            throw new SaslException("CRAM-MD5 authentication failed", unsupportedCallbackException);
        }
        catch (SaslException saslException) {
            throw saslException;
        }
        catch (IOException iOException) {
            this.aborted = true;
            throw new SaslException("CRAM-MD5 authentication failed", iOException);
        }
    }

    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }
}

