/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType defaultSelection;
    private DestinationType destination;
    private DialogType dialog;
    private String fileName;
    private int fromPage;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multipleDocumentHandling;
    private int[][] pageRanges;
    private int prFirst;
    private int prLast;
    private String printer;
    private SidesType sides;
    private int toPage;

    public JobAttributes() {
        this.setCopiesToDefault();
        this.setDefaultSelection(DefaultSelectionType.ALL);
        this.setDestination(DestinationType.PRINTER);
        this.setDialog(DialogType.NATIVE);
        this.setMaxPage(Integer.MAX_VALUE);
        this.setMinPage(1);
        this.setMultipleDocumentHandlingToDefault();
        this.setSidesToDefault();
    }

    public JobAttributes(JobAttributes jobAttributes) {
        this.set(jobAttributes);
    }

    public JobAttributes(int n2, DefaultSelectionType defaultSelectionType, DestinationType destinationType, DialogType dialogType, String string, int n3, int n4, MultipleDocumentHandlingType multipleDocumentHandlingType, int[][] nArray, String string2, SidesType sidesType) {
        this.setCopies(n2);
        this.setDefaultSelection(defaultSelectionType);
        this.setDestination(destinationType);
        this.setDialog(dialogType);
        this.setFileName(string);
        this.setMaxPage(n3);
        this.setMinPage(n4);
        this.setMultipleDocumentHandling(multipleDocumentHandlingType);
        this.setPageRanges(nArray);
        this.setPrinter(string2);
        this.setSides(sidesType);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void set(JobAttributes jobAttributes) {
        this.copies = jobAttributes.copies;
        this.defaultSelection = jobAttributes.defaultSelection;
        this.destination = jobAttributes.destination;
        this.dialog = jobAttributes.dialog;
        this.fileName = jobAttributes.fileName;
        this.fromPage = jobAttributes.fromPage;
        this.maxPage = jobAttributes.maxPage;
        this.minPage = jobAttributes.minPage;
        this.multipleDocumentHandling = jobAttributes.multipleDocumentHandling;
        this.pageRanges = jobAttributes.pageRanges;
        this.prFirst = jobAttributes.prFirst;
        this.prLast = jobAttributes.prLast;
        this.printer = jobAttributes.printer;
        this.sides = jobAttributes.sides;
        this.toPage = jobAttributes.toPage;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid value for attribute copies");
        }
        this.copies = n2;
    }

    public void setCopiesToDefault() {
        this.setCopies(1);
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(DefaultSelectionType defaultSelectionType) {
        if (defaultSelectionType == null) {
            throw new IllegalArgumentException("Invalid value for attribute defaultSelection");
        }
        this.defaultSelection = defaultSelectionType;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException("Invalid value for attribute destination");
        }
        this.destination = destinationType;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialogType) {
        if (dialogType == null) {
            throw new IllegalArgumentException("Invalid value for attribute dialog");
        }
        this.dialog = dialogType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.toPage != 0) {
            return this.getMinPage();
        }
        if (this.pageRanges != null) {
            return this.prFirst;
        }
        return this.getMinPage();
    }

    public void setFromPage(int n2) {
        if (n2 <= 0 || this.toPage != 0 && n2 > this.toPage || n2 < this.minPage || n2 > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute fromPage");
        }
        this.fromPage = n2;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int n2) {
        if (n2 <= 0 || n2 < this.minPage) {
            throw new IllegalArgumentException("Invalid value for attribute maxPage");
        }
        this.maxPage = n2;
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int n2) {
        if (n2 <= 0 || n2 > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute minPage");
        }
        this.minPage = n2;
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multipleDocumentHandling;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandlingType) {
        if (multipleDocumentHandlingType == null) {
            throw new IllegalArgumentException("Invalid value for attribute multipleDocumentHandling");
        }
        this.multipleDocumentHandling = multipleDocumentHandlingType;
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.setMultipleDocumentHandling(MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
    }

    public int[][] getPageRanges() {
        if (this.pageRanges != null) {
            int[][] nArray = new int[this.pageRanges.length][2];
            for (int i2 = 0; i2 < this.pageRanges.length; ++i2) {
                nArray[i2][0] = this.pageRanges[i2][0];
                nArray[i2][1] = this.pageRanges[i2][1];
            }
            return nArray;
        }
        if (this.fromPage != 0 || this.toPage != 0) {
            int n2 = this.getFromPage();
            int n3 = this.getToPage();
            return new int[][]{{n2, n3}};
        }
        int n4 = this.getMinPage();
        return new int[][]{{n4, n4}};
    }

    public void setPageRanges(int[][] nArray) {
        String string = "Invalid value for attribute pageRanges";
        int n2 = 0;
        int n3 = 0;
        if (nArray == null) {
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == null || nArray[i2].length != 2 || nArray[i2][0] <= n3 || nArray[i2][1] < nArray[i2][0]) {
                throw new IllegalArgumentException(string);
            }
            n3 = nArray[i2][1];
            if (n2 != 0) continue;
            n2 = nArray[i2][0];
        }
        if (n2 < this.minPage || n3 > this.maxPage) {
            throw new IllegalArgumentException(string);
        }
        int[][] nArray2 = new int[nArray.length][2];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray2[i3][0] = nArray[i3][0];
            nArray2[i3][1] = nArray[i3][1];
        }
        this.pageRanges = nArray2;
        this.prFirst = n2;
        this.prLast = n3;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String string) {
        this.printer = string;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sidesType) {
        if (sidesType == null) {
            throw new IllegalArgumentException("Invalid value for attribute sides");
        }
        this.sides = sidesType;
    }

    public void setSidesToDefault() {
        this.setSides(SidesType.ONE_SIDED);
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.prLast;
        }
        return this.getMinPage();
    }

    public void setToPage(int n2) {
        if (n2 <= 0 || this.fromPage != 0 && n2 < this.fromPage || n2 < this.minPage || n2 > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute toPage");
        }
        this.toPage = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JobAttributes)) {
            return false;
        }
        JobAttributes jobAttributes = (JobAttributes)object;
        if (this.fileName == null ? jobAttributes.fileName != null : !this.fileName.equals(jobAttributes.fileName)) {
            return false;
        }
        if (this.pageRanges == null) {
            if (jobAttributes.pageRanges != null) {
                return false;
            }
        } else {
            if (jobAttributes.pageRanges == null || this.pageRanges.length != jobAttributes.pageRanges.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.pageRanges.length; ++i2) {
                if (this.pageRanges[i2][0] == jobAttributes.pageRanges[i2][0] && this.pageRanges[i2][1] == jobAttributes.pageRanges[i2][1]) continue;
                return false;
            }
        }
        if (this.printer == null ? jobAttributes.printer != null : !this.printer.equals(jobAttributes.printer)) {
            return false;
        }
        return this.copies == jobAttributes.copies && this.defaultSelection == jobAttributes.defaultSelection && this.destination == jobAttributes.destination && this.dialog == jobAttributes.dialog && this.fromPage == jobAttributes.fromPage && this.maxPage == jobAttributes.maxPage && this.minPage == jobAttributes.minPage && this.multipleDocumentHandling == jobAttributes.multipleDocumentHandling && this.prFirst == jobAttributes.prFirst && this.prLast == jobAttributes.prLast && this.sides == jobAttributes.sides && this.toPage == jobAttributes.toPage;
    }

    public int hashCode() {
        int n2 = (this.copies + this.fromPage + this.maxPage + this.minPage + this.prFirst + this.prLast + this.toPage) * 31 << 21;
        if (this.pageRanges != null) {
            int n3 = 0;
            for (int i2 = 0; i2 < this.pageRanges.length; ++i2) {
                n3 += this.pageRanges[i2][0] + this.pageRanges[i2][1];
            }
            n2 ^= n3 * 31 << 11;
        }
        if (this.fileName != null) {
            n2 ^= this.fileName.hashCode();
        }
        if (this.printer != null) {
            n2 ^= this.printer.hashCode();
        }
        return this.defaultSelection.hashCode() << 6 ^ this.destination.hashCode() << 5 ^ this.dialog.hashCode() << 3 ^ this.multipleDocumentHandling.hashCode() << 2 ^ this.sides.hashCode() ^ n2;
    }

    public String toString() {
        int[][] nArray = this.getPageRanges();
        String string = "[";
        boolean bl2 = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (bl2) {
                bl2 = false;
            } else {
                string = string + ",";
            }
            string = string + nArray[i2][0] + ":" + nArray[i2][1];
        }
        string = string + "]";
        return "copies=" + this.getCopies() + ",defaultSelection=" + this.getDefaultSelection() + ",destination=" + this.getDestination() + ",dialog=" + this.getDialog() + ",fileName=" + this.getFileName() + ",fromPage=" + this.getFromPage() + ",maxPage=" + this.getMaxPage() + ",minPage=" + this.getMinPage() + ",multiple-document-handling=" + this.getMultipleDocumentHandling() + ",page-ranges=" + string + ",printer=" + this.getPrinter() + ",sides=" + this.getSides() + ",toPage=" + this.getToPage();
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final int I_ALL = 0;
        private static final int I_RANGE = 1;
        private static final int I_SELECTION = 2;
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int n2) {
            super(n2, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final int I_FILE = 0;
        private static final int I_PRINTER = 1;
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int n2) {
            super(n2, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final int I_COMMON = 0;
        private static final int I_NATIVE = 1;
        private static final int I_NONE = 2;
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int n2) {
            super(n2, NAMES);
        }
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final int I_SEPARATE_DOCUMENTS_COLLATED_COPIES = 0;
        private static final int I_SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = 1;
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int n2) {
            super(n2, NAMES);
        }
    }

    public static final class SidesType
    extends AttributeValue {
        private static final int I_ONE_SIDED = 0;
        private static final int I_TWO_SIDED_LONG_EDGE = 1;
        private static final int I_TWO_SIDED_SHORT_EDGE = 2;
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int n2) {
            super(n2, NAMES);
        }
    }
}

