/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.ArcIterator;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    private int type;

    protected Arc2D(int n2) {
        this.setArcType(n2);
    }

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double d2 = Math.toRadians(-this.getAngleStart());
        double d3 = this.getX() + (Math.cos(d2) * 0.5 + 0.5) * this.getWidth();
        double d4 = this.getY() + (Math.sin(d2) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(d3, d4);
    }

    public Point2D getEndPoint() {
        double d2 = Math.toRadians(-this.getAngleStart() - this.getAngleExtent());
        double d3 = this.getX() + (Math.cos(d2) * 0.5 + 0.5) * this.getWidth();
        double d4 = this.getY() + (Math.sin(d2) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(d3, d4);
    }

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public void setArc(Point2D point2D, Dimension2D dimension2D, double d2, double d3, int n2) {
        this.setArc(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight(), d2, d3, n2);
    }

    public void setArc(Rectangle2D rectangle2D, double d2, double d3, int n2) {
        this.setArc(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d2, d3, n2);
    }

    public void setArc(Arc2D arc2D) {
        this.setArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.type);
    }

    public void setArcByCenter(double d2, double d3, double d4, double d5, double d6, int n2) {
        this.setArc(d2 - d4, d3 - d4, d4 * 2.0, d4 * 2.0, d5, d6, n2);
    }

    public void setArcByTangent(Point2D point2D, Point2D point2D2, Point2D point2D3, double d2) {
        double d3 = Math.atan2(point2D.getY() - point2D2.getY(), point2D.getX() - point2D2.getX());
        double d4 = Math.atan2(point2D3.getY() - point2D2.getY(), point2D3.getX() - point2D2.getX());
        double d5 = d4 - d3;
        if (d5 > Math.PI) {
            d4 -= Math.PI * 2;
        } else if (d5 < -Math.PI) {
            d4 += Math.PI * 2;
        }
        double d6 = (d3 + d4) / 2.0;
        double d7 = Math.abs(d4 - d6);
        double d8 = d2 / Math.sin(d7);
        double d9 = point2D2.getX() + d8 * Math.cos(d6);
        double d10 = point2D2.getY() + d8 * Math.sin(d6);
        if (d3 < d4) {
            d3 -= 1.5707963267948966;
            d4 += 1.5707963267948966;
        } else {
            d3 += 1.5707963267948966;
            d4 -= 1.5707963267948966;
        }
        d3 = Math.toDegrees(-d3);
        d4 = Math.toDegrees(-d4);
        d5 = d4 - d3;
        d5 = d5 < 0.0 ? (d5 += 360.0) : (d5 -= 360.0);
        this.setArcByCenter(d9, d10, d2, d3, d5, this.type);
    }

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public void setAngleStart(Point2D point2D) {
        double d2 = this.getHeight() * (point2D.getX() - this.getCenterX());
        double d3 = this.getWidth() * (point2D.getY() - this.getCenterY());
        this.setAngleStart(-Math.toDegrees(Math.atan2(d3, d2)));
    }

    public void setAngles(double d2, double d3, double d4, double d5) {
        double d6 = this.getCenterX();
        double d7 = this.getCenterY();
        double d8 = this.getWidth();
        double d9 = this.getHeight();
        double d10 = Math.atan2(d8 * (d7 - d3), d9 * (d2 - d6));
        double d11 = Math.atan2(d8 * (d7 - d5), d9 * (d4 - d6));
        if ((d11 -= d10) <= 0.0) {
            d11 += Math.PI * 2;
        }
        this.setAngleStart(Math.toDegrees(d10));
        this.setAngleExtent(Math.toDegrees(d11));
    }

    public void setAngles(Point2D point2D, Point2D point2D2) {
        this.setAngles(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setArcType(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("invalid type for Arc: " + n2);
        }
        this.type = n2;
    }

    public void setFrame(double d2, double d3, double d4, double d5) {
        this.setArc(d2, d3, d4, d5, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    public Rectangle2D getBounds2D() {
        double d2;
        double d3;
        double d4;
        double d5;
        if (this.isEmpty()) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.getArcType() == 2) {
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
        } else {
            d3 = 1.0;
            d2 = 1.0;
            d5 = -1.0;
            d4 = -1.0;
        }
        double d6 = 0.0;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (i2 < 4) {
                if (!this.containsAngle(d6 += 90.0)) {
                    continue;
                }
            } else {
                d6 = i2 == 4 ? this.getAngleStart() : (d6 += this.getAngleExtent());
            }
            double d7 = Math.toRadians(-d6);
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            d2 = Math.min(d2, d8);
            d3 = Math.min(d3, d9);
            d4 = Math.max(d4, d8);
            d5 = Math.max(d5, d9);
        }
        double d10 = this.getWidth();
        double d11 = this.getHeight();
        d4 = (d4 - d2) * 0.5 * d10;
        d5 = (d5 - d3) * 0.5 * d11;
        d2 = this.getX() + (d2 * 0.5 + 0.5) * d10;
        d3 = this.getY() + (d3 * 0.5 + 0.5) * d11;
        return this.makeBounds(d2, d3, d4, d5);
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    static double normalizeDegrees(double d2) {
        if (d2 > 180.0) {
            if (d2 <= 540.0) {
                d2 -= 360.0;
            } else if ((d2 = Math.IEEEremainder(d2, 360.0)) == -180.0) {
                d2 = 180.0;
            }
        } else if (d2 <= -180.0) {
            if (d2 > -540.0) {
                d2 += 360.0;
            } else if ((d2 = Math.IEEEremainder(d2, 360.0)) == -180.0) {
                d2 = 180.0;
            }
        }
        return d2;
    }

    public boolean containsAngle(double d2) {
        boolean bl2;
        double d3 = this.getAngleExtent();
        boolean bl3 = bl2 = d3 < 0.0;
        if (bl2) {
            d3 = -d3;
        }
        if (d3 >= 360.0) {
            return true;
        }
        d2 = Arc2D.normalizeDegrees(d2) - Arc2D.normalizeDegrees(this.getAngleStart());
        if (bl2) {
            d2 = -d2;
        }
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2 >= 0.0 && d2 < d3;
    }

    public boolean contains(double d2, double d3) {
        double d4;
        double d5;
        double d6;
        boolean bl2;
        double d7 = this.getWidth();
        if (d7 <= 0.0) {
            return false;
        }
        double d8 = (d2 - this.getX()) / d7 - 0.5;
        double d9 = this.getHeight();
        if (d9 <= 0.0) {
            return false;
        }
        double d10 = (d3 - this.getY()) / d9 - 0.5;
        double d11 = d8 * d8 + d10 * d10;
        if (d11 >= 0.25) {
            return false;
        }
        double d12 = Math.abs(this.getAngleExtent());
        if (d12 >= 360.0) {
            return true;
        }
        boolean bl3 = this.containsAngle(-Math.toDegrees(Math.atan2(d10, d8)));
        if (this.type == 2) {
            return bl3;
        }
        if (bl3) {
            if (d12 >= 180.0) {
                return true;
            }
        } else if (d12 <= 180.0) {
            return false;
        }
        double d13 = Math.toRadians(-this.getAngleStart());
        double d14 = Math.cos(d13);
        boolean bl4 = bl2 = Line2D.relativeCCW(d14, d6 = Math.sin(d13), d5 = Math.cos(d13 += Math.toRadians(-this.getAngleExtent())), d4 = Math.sin(d13), 2.0 * d8, 2.0 * d10) * Line2D.relativeCCW(d14, d6, d5, d4, 0.0, 0.0) >= 0;
        return bl3 ? !bl2 : bl2;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        double d6 = this.getWidth();
        double d7 = this.getHeight();
        if (d4 <= 0.0 || d5 <= 0.0 || d6 <= 0.0 || d7 <= 0.0) {
            return false;
        }
        double d8 = this.getAngleExtent();
        if (d8 == 0.0) {
            return false;
        }
        double d9 = this.getX();
        double d10 = this.getY();
        double d11 = d9 + d6;
        double d12 = d10 + d7;
        double d13 = d2 + d4;
        double d14 = d3 + d5;
        if (d2 >= d11 || d3 >= d12 || d13 <= d9 || d14 <= d10) {
            return false;
        }
        double d15 = this.getCenterX();
        double d16 = this.getCenterY();
        Point2D point2D = this.getStartPoint();
        Point2D point2D2 = this.getEndPoint();
        double d17 = point2D.getX();
        double d18 = point2D.getY();
        double d19 = point2D2.getX();
        double d20 = point2D2.getY();
        if (d16 >= d3 && d16 <= d14 && (d17 < d13 && d19 < d13 && d15 < d13 && d11 > d2 && this.containsAngle(0.0) || d17 > d2 && d19 > d2 && d15 > d2 && d9 < d13 && this.containsAngle(180.0))) {
            return true;
        }
        if (d15 >= d2 && d15 <= d13 && (d18 > d3 && d20 > d3 && d16 > d3 && d10 < d14 && this.containsAngle(90.0) || d18 < d14 && d20 < d14 && d16 < d14 && d12 > d3 && this.containsAngle(270.0))) {
            return true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        if (this.type == 2 || Math.abs(d8) > 180.0 ? double_.intersectsLine(d15, d16, d17, d18) || double_.intersectsLine(d15, d16, d19, d20) : double_.intersectsLine(d17, d18, d19, d20)) {
            return true;
        }
        return this.contains(d2, d3) || this.contains(d2 + d4, d3) || this.contains(d2, d3 + d5) || this.contains(d2 + d4, d3 + d5);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3, d4, d5, null);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), rectangle2D);
    }

    private boolean contains(double d2, double d3, double d4, double d5, Rectangle2D rectangle2D) {
        double d6;
        double d7;
        double d8;
        double d9;
        if (!(this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2, d3 + d5) && this.contains(d2 + d4, d3 + d5))) {
            return false;
        }
        if (this.type != 2 || Math.abs(this.getAngleExtent()) <= 180.0) {
            return true;
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(d2, d3, d4, d5);
        }
        double d10 = this.getWidth() / 2.0;
        double d11 = this.getHeight() / 2.0;
        double d12 = this.getX() + d10;
        if (rectangle2D.intersectsLine(d12, d9 = this.getY() + d11, d8 = d12 + d10 * Math.cos(d7 = Math.toRadians(-this.getAngleStart())), d6 = d9 + d11 * Math.sin(d7))) {
            return false;
        }
        d8 = d12 + d10 * Math.cos(d7 += Math.toRadians(-this.getAngleExtent()));
        return !rectangle2D.intersectsLine(d12, d9, d8, d6 = d9 + d11 * Math.sin(d7));
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new ArcIterator(this, affineTransform);
    }

    public static class Double
    extends Arc2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;

        public Double() {
            super(0);
        }

        public Double(int n2) {
            super(n2);
        }

        public Double(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
            super(n2);
            this.x = d2;
            this.y = d3;
            this.width = d4;
            this.height = d5;
            this.start = d6;
            this.extent = d7;
        }

        public Double(Rectangle2D rectangle2D, double d2, double d3, int n2) {
            super(n2);
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
            this.start = d2;
            this.extent = d3;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setArc(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
            this.setArcType(n2);
            this.x = d2;
            this.y = d3;
            this.width = d4;
            this.height = d5;
            this.start = d6;
            this.extent = d7;
        }

        public void setAngleStart(double d2) {
            this.start = d2;
        }

        public void setAngleExtent(double d2) {
            this.extent = d2;
        }

        protected Rectangle2D makeBounds(double d2, double d3, double d4, double d5) {
            return new Rectangle2D.Double(d2, d3, d4, d5);
        }
    }

    public static class Float
    extends Arc2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;

        public Float() {
            super(0);
        }

        public Float(int n2) {
            super(n2);
        }

        public Float(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
            super(n2);
            this.x = f2;
            this.y = f3;
            this.width = f4;
            this.height = f5;
            this.start = f6;
            this.extent = f7;
        }

        public Float(Rectangle2D rectangle2D, float f2, float f3, int n2) {
            super(n2);
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
            this.start = f2;
            this.extent = f3;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            return (double)this.width <= 0.0 || (double)this.height <= 0.0;
        }

        public void setArc(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
            this.setArcType(n2);
            this.x = (float)d2;
            this.y = (float)d3;
            this.width = (float)d4;
            this.height = (float)d5;
            this.start = (float)d6;
            this.extent = (float)d7;
        }

        public void setAngleStart(double d2) {
            this.start = (float)d2;
        }

        public void setAngleExtent(double d2) {
            this.extent = (float)d2;
        }

        protected Rectangle2D makeBounds(double d2, double d3, double d4, double d5) {
            return new Rectangle2D.Float((float)d2, (float)d3, (float)d4, (float)d5);
        }
    }
}

