/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import sun.awt.geom.Curve;

class AreaIterator
implements PathIterator {
    private AffineTransform transform;
    private Vector curves;
    private int index;
    private Curve prevcurve;
    private Curve thiscurve;

    public AreaIterator(Vector vector, AffineTransform affineTransform) {
        this.curves = vector;
        this.transform = affineTransform;
        if (vector.size() >= 1) {
            this.thiscurve = (Curve)vector.get(0);
        }
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.prevcurve == null && this.thiscurve == null;
    }

    public void next() {
        if (this.prevcurve != null) {
            this.prevcurve = null;
        } else {
            this.prevcurve = this.thiscurve;
            ++this.index;
            if (this.index < this.curves.size()) {
                this.thiscurve = (Curve)this.curves.get(this.index);
                if (this.thiscurve.getOrder() != 0 && this.prevcurve.getX1() == this.thiscurve.getX0() && this.prevcurve.getY1() == this.thiscurve.getY0()) {
                    this.prevcurve = null;
                }
            } else {
                this.thiscurve = null;
            }
        }
    }

    public int currentSegment(float[] fArray) {
        double[] dArray = new double[6];
        int n2 = this.currentSegment(dArray);
        int n3 = n2 == 4 ? 0 : (n2 == 2 ? 2 : (n2 == 3 ? 3 : 1));
        for (int i2 = 0; i2 < n3 * 2; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return n2;
    }

    public int currentSegment(double[] dArray) {
        int n2;
        int n3;
        if (this.prevcurve != null) {
            if (this.thiscurve == null || this.thiscurve.getOrder() == 0) {
                return 4;
            }
            dArray[0] = this.thiscurve.getX0();
            dArray[1] = this.thiscurve.getY0();
            n3 = 1;
            n2 = 1;
        } else {
            if (this.thiscurve == null) {
                throw new NoSuchElementException("area iterator out of bounds");
            }
            n3 = this.thiscurve.getSegment(dArray);
            n2 = this.thiscurve.getOrder();
            if (n2 == 0) {
                n2 = 1;
            }
        }
        if (this.transform != null) {
            this.transform.transform(dArray, 0, dArray, 0, n2);
        }
        return n3;
    }
}

