/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s2) {
        return Integer.toString(s2, 10);
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static short parseShort(String string, int n2) throws NumberFormatException {
        int n3 = Integer.parseInt(string, n2);
        if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n2);
        }
        return (short)n3;
    }

    public static Short valueOf(String string, int n2) throws NumberFormatException {
        return new Short(Short.parseShort(string, n2));
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return Short.valueOf(string, 10);
    }

    public static Short valueOf(short s2) {
        short s3 = s2;
        if (s3 >= -128 && s3 <= 127) {
            return ShortCache.cache[s3 + 128];
        }
        return new Short(s2);
    }

    public static Short decode(String string) throws NumberFormatException {
        Short s2;
        int n2 = 10;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            s2 = Short.valueOf(string.substring(n3), n2);
            s2 = bl2 ? new Short(-s2.shortValue()) : s2;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n3)) : string.substring(n3);
            s2 = Short.valueOf(string2, n2);
        }
        return s2;
    }

    public Short(short s2) {
        this.value = s2;
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Short) {
            return this.value == (Short)object;
        }
        return false;
    }

    @Override
    public int compareTo(Short s2) {
        return this.value - s2.value;
    }

    public static short reverseBytes(short s2) {
        return (short)((s2 & 0xFF00) >> 8 | s2 << 8);
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                ShortCache.cache[i2] = new Short((short)(i2 - 128));
            }
        }
    }
}

