/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import sun.text.Utility;

public class ChoiceFormat
extends NumberFormat {
    private static final long serialVersionUID = 1795184449645032964L;
    private double[] choiceLimits;
    private String[] choiceFormats;
    static final long SIGN = Long.MIN_VALUE;
    static final long EXPONENT = 0x7FF0000000000000L;
    static final long POSITIVEINFINITY = 0x7FF0000000000000L;

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        for (int i2 = 0; i2 < stringBufferArray.length; ++i2) {
            stringBufferArray[i2] = new StringBuffer();
        }
        double[] dArray = new double[30];
        String[] stringArray = new String[30];
        int n2 = 0;
        int n3 = 0;
        double d2 = 0.0;
        double d3 = Double.NaN;
        boolean bl2 = false;
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c2 = string.charAt(i3);
            if (c2 == '\'') {
                if (i3 + 1 < string.length() && string.charAt(i3 + 1) == c2) {
                    stringBufferArray[n3].append(c2);
                    ++i3;
                    continue;
                }
                bl2 = !bl2;
                continue;
            }
            if (bl2) {
                stringBufferArray[n3].append(c2);
                continue;
            }
            if (c2 == '<' || c2 == '#' || c2 == '\u2264') {
                if (stringBufferArray[0].equals("")) {
                    throw new IllegalArgumentException();
                }
                try {
                    String string2 = stringBufferArray[0].toString();
                    d2 = string2.equals("\u221e") ? Double.POSITIVE_INFINITY : (string2.equals("-\u221e") ? Double.NEGATIVE_INFINITY : Double.valueOf(stringBufferArray[0].toString()));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException();
                }
                if (c2 == '<' && d2 != Double.POSITIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY) {
                    d2 = ChoiceFormat.nextDouble(d2);
                }
                if (d2 <= d3) {
                    throw new IllegalArgumentException();
                }
                stringBufferArray[0].setLength(0);
                n3 = 1;
                continue;
            }
            if (c2 == '|') {
                if (n2 == dArray.length) {
                    dArray = ChoiceFormat.doubleArraySize(dArray);
                    stringArray = this.doubleArraySize(stringArray);
                }
                dArray[n2] = d2;
                stringArray[n2] = stringBufferArray[1].toString();
                ++n2;
                d3 = d2;
                stringBufferArray[1].setLength(0);
                n3 = 0;
                continue;
            }
            stringBufferArray[n3].append(c2);
        }
        if (n3 == 1) {
            if (n2 == dArray.length) {
                dArray = ChoiceFormat.doubleArraySize(dArray);
                stringArray = this.doubleArraySize(stringArray);
            }
            dArray[n2] = d2;
            stringArray[n2] = stringBufferArray[1].toString();
            ++n2;
        }
        this.choiceLimits = new double[n2];
        System.arraycopy(dArray, 0, this.choiceLimits, 0, n2);
        this.choiceFormats = new String[n2];
        System.arraycopy(stringArray, 0, this.choiceFormats, 0, n2);
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.choiceLimits.length; ++i2) {
            boolean bl2;
            double d2;
            if (i2 != 0) {
                stringBuffer.append('|');
            }
            double d3 = ChoiceFormat.previousDouble(this.choiceLimits[i2]);
            double d4 = Math.abs(Math.IEEEremainder(this.choiceLimits[i2], 1.0));
            if (d4 < (d2 = Math.abs(Math.IEEEremainder(d3, 1.0)))) {
                stringBuffer.append("" + this.choiceLimits[i2]);
                stringBuffer.append('#');
            } else {
                if (this.choiceLimits[i2] == Double.POSITIVE_INFINITY) {
                    stringBuffer.append("\u221e");
                } else if (this.choiceLimits[i2] == Double.NEGATIVE_INFINITY) {
                    stringBuffer.append("-\u221e");
                } else {
                    stringBuffer.append("" + d3);
                }
                stringBuffer.append('<');
            }
            String string = this.choiceFormats[i2];
            boolean bl3 = bl2 = string.indexOf(60) >= 0 || string.indexOf(35) >= 0 || string.indexOf(8804) >= 0 || string.indexOf(124) >= 0;
            if (bl2) {
                stringBuffer.append('\'');
            }
            if (string.indexOf(39) < 0) {
                stringBuffer.append(string);
            } else {
                for (int i3 = 0; i3 < string.length(); ++i3) {
                    char c2 = string.charAt(i3);
                    stringBuffer.append(c2);
                    if (c2 != '\'') continue;
                    stringBuffer.append(c2);
                }
            }
            if (!bl2) continue;
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException("Array and limit arrays must be of the same length.");
        }
        this.choiceLimits = dArray;
        this.choiceFormats = stringArray;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l2, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n2;
        for (n2 = 0; n2 < this.choiceLimits.length && d2 >= this.choiceLimits[n2]; ++n2) {
        }
        if (--n2 < 0) {
            n2 = 0;
        }
        return stringBuffer.append(this.choiceFormats[n2]);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n2;
        int n3 = n2 = parsePosition.index;
        double d2 = Double.NaN;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.choiceFormats.length; ++i2) {
            String string2 = this.choiceFormats[i2];
            if (!string.regionMatches(n2, string2, 0, string2.length())) continue;
            parsePosition.index = n2 + string2.length();
            d3 = this.choiceLimits[i2];
            if (parsePosition.index <= n3) continue;
            n3 = parsePosition.index;
            d2 = d3;
            if (n3 == string.length()) break;
        }
        parsePosition.index = n3;
        if (parsePosition.index == n2) {
            parsePosition.errorIndex = n3;
        }
        return new Double(d2);
    }

    public static final double nextDouble(double d2) {
        return ChoiceFormat.nextDouble(d2, true);
    }

    public static final double previousDouble(double d2) {
        return ChoiceFormat.nextDouble(d2, false);
    }

    public Object clone() {
        ChoiceFormat choiceFormat = (ChoiceFormat)super.clone();
        choiceFormat.choiceLimits = (double[])this.choiceLimits.clone();
        choiceFormat.choiceFormats = (String[])this.choiceFormats.clone();
        return choiceFormat;
    }

    public int hashCode() {
        int n2 = this.choiceLimits.length;
        if (this.choiceFormats.length > 0) {
            n2 ^= this.choiceFormats[this.choiceFormats.length - 1].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        return Utility.arrayEquals(this.choiceLimits, (Object)choiceFormat.choiceLimits) && Utility.arrayEquals(this.choiceFormats, (Object)choiceFormat.choiceFormats);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.choiceLimits.length != this.choiceFormats.length) {
            throw new InvalidObjectException("limits and format arrays of different length.");
        }
    }

    public static double nextDouble(double d2, boolean bl2) {
        if (Double.isNaN(d2)) {
            return d2;
        }
        if (d2 == 0.0) {
            double d3 = Double.longBitsToDouble(1L);
            if (bl2) {
                return d3;
            }
            return -d3;
        }
        long l2 = Double.doubleToLongBits(d2);
        long l3 = l2 & Long.MAX_VALUE;
        if (l2 > 0L == bl2) {
            if (l3 != 0x7FF0000000000000L) {
                ++l3;
            }
        } else {
            --l3;
        }
        long l4 = l2 & Long.MIN_VALUE;
        return Double.longBitsToDouble(l3 | l4);
    }

    private static double[] doubleArraySize(double[] dArray) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2 * 2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        return dArray2;
    }

    private String[] doubleArraySize(String[] stringArray) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 * 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }
}

