/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.ParseException;
import java.text.RBTableBuilder;
import java.util.Vector;
import sun.text.IntHashtable;
import sun.text.UCompactIntArray;

final class RBCollationTables {
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private String rules = null;
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private IntHashtable contractFlags = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBCollationTables(String string, int n2) throws ParseException {
        this.rules = string;
        RBTableBuilder rBTableBuilder = new RBTableBuilder(new BuildAPI());
        rBTableBuilder.build(string, n2);
    }

    public String getRules() {
        return this.rules;
    }

    public boolean isFrenchSec() {
        return this.frenchSec;
    }

    public boolean isSEAsianSwapping() {
        return this.seAsianSwapping;
    }

    Vector getContractValues(int n2) {
        int n3 = this.mapping.elementAt(n2);
        return this.getContractValuesImpl(n3 - 0x7F000000);
    }

    private Vector getContractValuesImpl(int n2) {
        if (n2 >= 0) {
            return (Vector)this.contractTable.elementAt(n2);
        }
        return null;
    }

    boolean usedInContractSeq(int n2) {
        return this.contractFlags.get(n2) == 1;
    }

    int getMaxExpansion(int n2) {
        int n3 = 1;
        if (this.expandTable != null) {
            for (int i2 = 0; i2 < this.expandTable.size(); ++i2) {
                int[] nArray = (int[])this.expandTable.elementAt(i2);
                int n4 = nArray.length;
                if (n4 <= n3 || nArray[n4 - 1] != n2) continue;
                n3 = n4;
            }
        }
        return n3;
    }

    final int[] getExpandValueList(int n2) {
        return (int[])this.expandTable.elementAt(n2 - 0x7E000000);
    }

    int getUnicodeOrder(int n2) {
        return this.mapping.elementAt(n2);
    }

    short getMaxSecOrder() {
        return this.maxSecOrder;
    }

    short getMaxTerOrder() {
        return this.maxTerOrder;
    }

    static void reverse(StringBuffer stringBuffer, int n2, int n3) {
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            char c2 = stringBuffer.charAt(n4);
            stringBuffer.setCharAt(n4, stringBuffer.charAt(i2));
            stringBuffer.setCharAt(i2, c2);
        }
    }

    static final int getEntry(Vector vector, String string, boolean bl2) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            EntryPair entryPair = (EntryPair)vector.elementAt(i2);
            if (entryPair.fwd != bl2 || !entryPair.entryName.equals(string)) continue;
            return i2;
        }
        return -1;
    }

    final class BuildAPI {
        private BuildAPI() {
        }

        void fillInTables(boolean bl2, boolean bl3, UCompactIntArray uCompactIntArray, Vector vector, Vector vector2, IntHashtable intHashtable, short s2, short s3) {
            RBCollationTables.this.frenchSec = bl2;
            RBCollationTables.this.seAsianSwapping = bl3;
            RBCollationTables.this.mapping = uCompactIntArray;
            RBCollationTables.this.contractTable = vector;
            RBCollationTables.this.expandTable = vector2;
            RBCollationTables.this.contractFlags = intHashtable;
            RBCollationTables.this.maxSecOrder = s2;
            RBCollationTables.this.maxTerOrder = s3;
        }
    }
}

