/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int n2) {
        return n2 >> 6;
    }

    private static long bit(int n2) {
        return 1L << (n2 & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int n2;
        for (n2 = this.unitsInUse - 1; n2 >= 0 && this.bits[n2] == 0L; --n2) {
        }
        this.unitsInUse = n2 + 1;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n2);
        }
        this.bits = new long[BitSet.unitIndex(n2 - 1) + 1];
    }

    private void ensureCapacity(int n2) {
        if (this.bits.length < n2) {
            int n3 = Math.max(2 * this.bits.length, n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.bits, 0, lArray, 0, this.unitsInUse);
            this.bits = lArray;
        }
    }

    public void flip(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            int n5 = n3;
            this.bits[n5] = this.bits[n5] ^ BitSet.bit(n2);
            this.unitsInUse = n4;
        } else {
            int n6 = n3;
            this.bits[n6] = this.bits[n6] ^ BitSet.bit(n2);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
        }
    }

    public void flip(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = BitSet.unitIndex(n3);
        int n5 = n4 + 1;
        if (this.unitsInUse < n5) {
            this.ensureCapacity(n5);
            this.unitsInUse = n5;
        }
        int n6 = BitSet.unitIndex(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.bits[n7] = this.bits[n7] ^ l2;
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l2 = BitSet.bitsLeftOf(n2 & 0x3F);
        int n8 = n6;
        this.bits[n8] = this.bits[n8] ^ l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.bits[n10] = this.bits[n10] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = BitSet.bitsRightOf(n3 & 0x3F);
        int n11 = n4;
        this.bits[n11] = this.bits[n11] ^ l2;
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    private static long bitsRightOf(int n2) {
        return n2 == 0 ? 0L : -1L >>> 64 - n2;
    }

    private static long bitsLeftOf(int n2) {
        return -1L << n2;
    }

    public void set(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            int n5 = n3;
            this.bits[n5] = this.bits[n5] | BitSet.bit(n2);
            this.unitsInUse = n4;
        } else {
            int n6 = n3;
            this.bits[n6] = this.bits[n6] | BitSet.bit(n2);
        }
    }

    public void set(int n2, boolean bl2) {
        if (bl2) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    public void set(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = BitSet.unitIndex(n3);
        int n5 = n4 + 1;
        if (this.unitsInUse < n5) {
            this.ensureCapacity(n5);
            this.unitsInUse = n5;
        }
        int n6 = BitSet.unitIndex(n2);
        long l2 = 0L;
        if (n6 == n4) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n7 = n6;
            this.bits[n7] = this.bits[n7] | l2;
            return;
        }
        l2 = BitSet.bitsLeftOf(n2 & 0x3F);
        int n8 = n6;
        this.bits[n8] = this.bits[n8] | l2;
        if (n4 - n6 > 1) {
            int n9 = n6 + 1;
            while (n9 < n4) {
                int n10 = n9++;
                this.bits[n10] = this.bits[n10] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l2 = BitSet.bitsRightOf(n3 & 0x3F);
        int n11 = n4;
        this.bits[n11] = this.bits[n11] | l2;
    }

    public void set(int n2, int n3, boolean bl2) {
        if (bl2) {
            this.set(n2, n3);
        } else {
            this.clear(n2, n3);
        }
    }

    public void clear(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        if (n3 >= this.unitsInUse) {
            return;
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] & (BitSet.bit(n2) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        int n4 = BitSet.unitIndex(n2);
        if (n4 >= this.unitsInUse) {
            return;
        }
        int n5 = BitSet.unitIndex(n3);
        long l2 = 0L;
        if (n4 == n5) {
            l2 = (1L << (n3 & 0x3F)) - (1L << (n2 & 0x3F));
            int n6 = n4;
            this.bits[n6] = this.bits[n6] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l2 = BitSet.bitsLeftOf(n2 & 0x3F);
        int n7 = n4;
        this.bits[n7] = this.bits[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (n5 - n4 > 1) {
            for (int i2 = n4 + 1; i2 < n5; ++i2) {
                if (i2 >= this.unitsInUse) continue;
                this.bits[i2] = 0L;
            }
        }
        if (n5 < this.unitsInUse) {
            l2 = BitSet.bitsRightOf(n3 & 0x3F);
            int n8 = n5;
            this.bits[n8] = this.bits[n8] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    public boolean get(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n2);
        }
        boolean bl2 = false;
        int n3 = BitSet.unitIndex(n2);
        if (n3 < this.unitsInUse) {
            bl2 = (this.bits[n3] & BitSet.bit(n2)) != 0L;
        }
        return bl2;
    }

    public BitSet get(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("fromIndex: " + n2 + " > toIndex: " + n3);
        }
        if (this.length() <= n2 || n2 == n3) {
            return new BitSet(0);
        }
        if (this.length() < n3) {
            n3 = this.length();
        }
        BitSet bitSet = new BitSet(n3 - n2);
        int n4 = n2 & 0x3F;
        int n5 = n3 & 0x3F;
        int n6 = (n3 - n2 + 63) / 64;
        int n7 = BitSet.unitIndex(n3) - BitSet.unitIndex(n2) + 1;
        int n8 = 64 - n4;
        int n9 = 0;
        int n10 = BitSet.unitIndex(n2);
        while (n9 < n6 - 1) {
            bitSet.bits[n9++] = this.bits[n10++] >>> n4 | (n8 == 64 ? 0L : this.bits[n10] << n8);
        }
        bitSet.bits[n9] = n7 == n6 ? (this.bits[n10] & BitSet.bitsRightOf(n5)) >>> n4 : this.bits[n10++] >>> n4 | (n8 == 64 ? 0L : (this.getBits(n10) & BitSet.bitsRightOf(n5)) << n8);
        bitSet.unitsInUse = n6;
        bitSet.recalculateUnitsInUse();
        return bitSet;
    }

    private long getBits(int n2) {
        return n2 < this.unitsInUse ? this.bits[n2] : 0L;
    }

    public int nextSetBit(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        if (n3 >= this.unitsInUse) {
            return -1;
        }
        int n4 = n2 & 0x3F;
        long l2 = this.bits[n3] >> n4;
        if (l2 == 0L) {
            n4 = 0;
        }
        while (l2 == 0L && n3 < this.unitsInUse - 1) {
            l2 = this.bits[++n3];
        }
        if (l2 == 0L) {
            return -1;
        }
        return n3 * 64 + (n4 += BitSet.trailingZeroCnt(l2));
    }

    private static int trailingZeroCnt(long l2) {
        int n2 = (int)l2 & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2];
        }
        n2 = (int)(l2 >>> 8) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 8;
        }
        n2 = (int)(l2 >>> 16) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 16;
        }
        n2 = (int)(l2 >>> 24) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 24;
        }
        n2 = (int)(l2 >>> 32) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 32;
        }
        n2 = (int)(l2 >>> 40) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 40;
        }
        n2 = (int)(l2 >>> 48) & 0xFF;
        if (n2 != 0) {
            return trailingZeroTable[n2] + 48;
        }
        n2 = (int)(l2 >>> 56) & 0xFF;
        return trailingZeroTable[n2] + 56;
    }

    public int nextClearBit(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        if (n3 >= this.unitsInUse) {
            return n2;
        }
        int n4 = n2 & 0x3F;
        long l2 = this.bits[n3] >> n4;
        if (l2 == -1L >> n4) {
            n4 = 0;
        }
        while (l2 == -1L && n3 < this.unitsInUse - 1) {
            l2 = this.bits[++n3];
        }
        if (l2 == -1L) {
            return this.length();
        }
        if (l2 == 0L) {
            return n3 * 64 + n4;
        }
        return n3 * 64 + (n4 += BitSet.trailingZeroCnt(l2 ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long l2 = this.bits[this.unitsInUse - 1];
        int n2 = (int)(l2 >>> 32);
        return 64 * (this.unitsInUse - 1) + (n2 == 0 ? BitSet.bitLen((int)l2) : 32 + BitSet.bitLen(n2));
    }

    private static int bitLen(int n2) {
        return n2 < 32768 ? (n2 < 128 ? (n2 < 8 ? (n2 < 2 ? (n2 < 1 ? (n2 < 0 ? 32 : 0) : 1) : (n2 < 4 ? 2 : 3)) : (n2 < 32 ? (n2 < 16 ? 4 : 5) : (n2 < 64 ? 6 : 7))) : (n2 < 2048 ? (n2 < 512 ? (n2 < 256 ? 8 : 9) : (n2 < 1024 ? 10 : 11)) : (n2 < 8192 ? (n2 < 4096 ? 12 : 13) : (n2 < 16384 ? 14 : 15)))) : (n2 < 0x800000 ? (n2 < 524288 ? (n2 < 131072 ? (n2 < 65536 ? 16 : 17) : (n2 < 262144 ? 18 : 19)) : (n2 < 0x200000 ? (n2 < 0x100000 ? 20 : 21) : (n2 < 0x400000 ? 22 : 23))) : (n2 < 0x8000000 ? (n2 < 0x2000000 ? (n2 < 0x1000000 ? 24 : 25) : (n2 < 0x4000000 ? 26 : 27)) : (n2 < 0x20000000 ? (n2 < 0x10000000 ? 28 : 29) : (n2 < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.unitsInUse == 0;
    }

    public boolean intersects(BitSet bitSet) {
        for (int i2 = Math.min(this.unitsInUse, bitSet.unitsInUse) - 1; i2 >= 0; --i2) {
            if ((this.bits[i2] & bitSet.bits[i2]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.unitsInUse; ++i2) {
            n2 += BitSet.bitCount(this.bits[i2]);
        }
        return n2;
    }

    private static int bitCount(long l2) {
        l2 -= (l2 & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l2 = (l2 & 0x3333333333333333L) + (l2 >>> 2 & 0x3333333333333333L);
        l2 = l2 + (l2 >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l2 += l2 >>> 8;
        l2 += l2 >>> 16;
        return (int)l2 + (int)(l2 >>> 32) & 0xFF;
    }

    public void and(BitSet bitSet) {
        int n2;
        if (this == bitSet) {
            return;
        }
        int n3 = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n2 = 0; n2 < this.unitsInUse; ++n2) {
            int n4 = n2;
            this.bits[n4] = this.bits[n4] & bitSet.bits[n2];
        }
        while (n2 < n3) {
            this.bits[n2] = 0L;
            ++n2;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(BitSet bitSet) {
        int n2;
        if (this == bitSet) {
            return;
        }
        this.ensureCapacity(bitSet.unitsInUse);
        int n3 = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2;
            this.bits[n4] = this.bits[n4] | bitSet.bits[n2];
        }
        while (n2 < bitSet.unitsInUse) {
            this.bits[n2] = bitSet.bits[n2];
            ++n2;
        }
        if (this.unitsInUse < bitSet.unitsInUse) {
            this.unitsInUse = bitSet.unitsInUse;
        }
    }

    public void xor(BitSet bitSet) {
        int n2;
        int n3;
        if (this.unitsInUse >= bitSet.unitsInUse) {
            n3 = bitSet.unitsInUse;
        } else {
            n3 = this.unitsInUse;
            n2 = bitSet.unitsInUse;
            this.ensureCapacity(n2);
            this.unitsInUse = n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2;
            this.bits[n4] = this.bits[n4] ^ bitSet.bits[n2];
        }
        while (n2 < bitSet.unitsInUse) {
            this.bits[n2] = bitSet.bits[n2];
            ++n2;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(BitSet bitSet) {
        int n2 = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.bits[n3] = this.bits[n3] & (bitSet.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateUnitsInUse();
    }

    public int hashCode() {
        long l2 = 1234L;
        int n2 = this.bits.length;
        while (--n2 >= 0) {
            l2 ^= this.bits[n2] * (long)(n2 + 1);
        }
        return (int)(l2 >> 32 ^ l2);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        int n3 = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.bits[n2] == bitSet.bits[n2]) continue;
            return false;
        }
        if (this.unitsInUse > n3) {
            for (n2 = n3; n2 < this.unitsInUse; ++n2) {
                if (this.bits[n2] == 0L) continue;
                return false;
            }
        } else {
            for (n2 = n3; n2 < bitSet.unitsInUse; ++n2) {
                if (bitSet.bits[n2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        BitSet bitSet = null;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, this.unitsInUse);
        return bitSet;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    public String toString() {
        int n2 = this.unitsInUse << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n2 + 2);
        String string = "";
        stringBuffer.append('{');
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.get(i2)) continue;
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(i2);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

