/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.ZoneInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date
implements Serializable,
Cloneable,
Comparable<Date> {
    private static final BaseCalendar gcal = CalendarSystem.getGregorianCalendar();
    private static BaseCalendar jcal;
    private transient long fastTime;
    private transient BaseCalendar.Date cdate;
    private static int defaultCenturyStart;
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] wtb;
    private static final int[] ttb;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l2) {
        this.fastTime = l2;
    }

    @Deprecated
    public Date(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, 0, 0);
    }

    @Deprecated
    public Date(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, 0);
    }

    @Deprecated
    public Date(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + 1900;
        if (n3 >= 12) {
            n8 += n3 / 12;
            n3 %= 12;
        } else if (n3 < 0) {
            n8 += CalendarUtils.floorDivide(n3, 12);
            n3 = CalendarUtils.mod(n3, 12);
        }
        BaseCalendar baseCalendar = Date.getCalendarSystem(n8);
        this.cdate = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.getDefaultRef());
        this.cdate.setNormalizedDate(n8, n3 + 1, n4).setTimeOfDay(n5, n6, n7, 0);
        this.getTimeImpl();
        this.cdate = null;
    }

    @Deprecated
    public Date(String string) {
        this(Date.parse(string));
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (this.cdate != null) {
                date.cdate = (BaseCalendar.Date)this.cdate.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    @Deprecated
    public static long UTC(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 + 1900;
        if (n3 >= 12) {
            n8 += n3 / 12;
            n3 %= 12;
        } else if (n3 < 0) {
            n8 += CalendarUtils.floorDivide(n3, 12);
            n3 = CalendarUtils.mod(n3, 12);
        }
        int n9 = n3 + 1;
        BaseCalendar baseCalendar = Date.getCalendarSystem(n8);
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(null);
        date.setNormalizedDate(n8, n9, n4).setTimeOfDay(n5, n6, n7, 0);
        date = Date.normalize(date);
        baseCalendar = Date.getCalendarSystem(date);
        return baseCalendar.getTime(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static long parse(String string) {
        int n2 = Integer.MIN_VALUE;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n15 = string.length();
        block2: while (true) {
            int n16;
            block52: {
                block51: {
                    block50: {
                        if (n10 >= n15) break block50;
                        n9 = string.charAt(n10);
                        ++n10;
                        if (n9 <= 32 || n9 == 44) continue;
                        if (n9 == 40) break block51;
                        if (48 <= n9 && n9 <= 57) {
                            n11 = n9 - 48;
                            while (n10 < n15) {
                                char c2 = string.charAt(n10);
                                n9 = c2;
                                if ('0' > c2 || n9 > 57) break;
                                n11 = n11 * 10 + n9 - 48;
                                ++n10;
                            }
                            if (n14 == 43 || n14 == 45 && n2 != Integer.MIN_VALUE) {
                                n11 = n11 < 24 ? (n11 *= 60) : n11 % 100 + n11 / 100 * 60;
                                if (n14 == 43) {
                                    n11 = -n11;
                                }
                                if (n13 != 0 && n13 != -1) {
                                    throw new IllegalArgumentException();
                                }
                                n13 = n11;
                            } else if (n11 >= 70) {
                                if (n2 != Integer.MIN_VALUE) {
                                    throw new IllegalArgumentException();
                                }
                                if (n9 > 32 && n9 != 44 && n9 != 47) {
                                    if (n10 < n15) throw new IllegalArgumentException();
                                }
                                n2 = n11;
                            } else if (n9 == 58) {
                                if (n5 < 0) {
                                    n5 = (byte)n11;
                                } else {
                                    if (n6 >= 0) throw new IllegalArgumentException();
                                    n6 = (byte)n11;
                                }
                            } else if (n9 == 47) {
                                if (n3 < 0) {
                                    n3 = (byte)(n11 - 1);
                                } else {
                                    if (n4 >= 0) throw new IllegalArgumentException();
                                    n4 = (byte)n11;
                                }
                            } else {
                                if (n10 < n15 && n9 != 44 && n9 > 32 && n9 != 45) {
                                    throw new IllegalArgumentException();
                                }
                                if (n5 >= 0 && n6 < 0) {
                                    n6 = (byte)n11;
                                } else if (n6 >= 0 && n7 < 0) {
                                    n7 = (byte)n11;
                                } else if (n4 < 0) {
                                    n4 = (byte)n11;
                                } else {
                                    if (n2 != Integer.MIN_VALUE) throw new IllegalArgumentException();
                                    if (n3 < 0) throw new IllegalArgumentException();
                                    if (n4 < 0) throw new IllegalArgumentException();
                                    n2 = n11;
                                }
                            }
                            n14 = 0;
                            continue;
                        }
                        if (n9 == 47 || n9 == 58 || n9 == 43 || n9 == 45) {
                            n14 = n9;
                            continue;
                        }
                        n16 = n10 - 1;
                        break block52;
                    }
                    if (n2 == Integer.MIN_VALUE) throw new IllegalArgumentException();
                    if (n3 < 0) throw new IllegalArgumentException();
                    if (n4 < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (n2 < 100) {
                        Class<Date> clazz = Date.class;
                        // MONITORENTER : java.util.Date.class
                        if (defaultCenturyStart == 0) {
                            defaultCenturyStart = gcal.getCalendarDate().getYear() - 80;
                        }
                        // MONITOREXIT : clazz
                        if ((n2 += defaultCenturyStart / 100 * 100) < defaultCenturyStart) {
                            n2 += 100;
                        }
                    }
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    BaseCalendar baseCalendar = Date.getCalendarSystem(n2);
                    if (n13 == -1) {
                        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.getDefaultRef());
                        date.setDate(n2, n3 + 1, n4);
                        date.setTimeOfDay(n5, n6, n7, 0);
                        return baseCalendar.getTime(date);
                    }
                    BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(null);
                    date.setDate(n2, n3 + 1, n4);
                    date.setTimeOfDay(n5, n6, n7, 0);
                    return baseCalendar.getTime(date) + (long)(n13 * 60000);
                }
                n16 = 1;
                while (true) {
                    if (n10 >= n15) continue block2;
                    n9 = string.charAt(n10);
                    ++n10;
                    if (n9 == 40) {
                        ++n16;
                        continue;
                    }
                    if (n9 == 41 && --n16 <= 0) break;
                }
                continue;
            }
            while (n10 < n15 && (65 <= (n9 = (int)string.charAt(n10)) && n9 <= 90 || 97 <= n9 && n9 <= 122)) {
                ++n10;
            }
            if (n10 <= n16 + 1) {
                throw new IllegalArgumentException();
            }
            int n17 = wtb.length;
            while (--n17 >= 0) {
                if (!wtb[n17].regionMatches(true, 0, string, n16, n10 - n16)) continue;
                int n18 = ttb[n17];
                if (n18 == 0) break;
                if (n18 == 1) {
                    if (n5 > 12) throw new IllegalArgumentException();
                    if (n5 < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (n5 >= 12) break;
                    n5 += 12;
                    break;
                }
                if (n18 == 14) {
                    if (n5 > 12) throw new IllegalArgumentException();
                    if (n5 < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (n5 != 12) break;
                    n5 = 0;
                    break;
                }
                if (n18 <= 13) {
                    if (n3 >= 0) throw new IllegalArgumentException();
                    n3 = (byte)(n18 - 2);
                    break;
                }
                n13 = n18 - 10000;
                break;
            }
            if (n17 < 0) {
                throw new IllegalArgumentException();
            }
            n14 = 0;
        }
    }

    @Deprecated
    public int getYear() {
        return this.normalize().getYear() - 1900;
    }

    @Deprecated
    public void setYear(int n2) {
        this.getCalendarDate().setNormalizedYear(n2 + 1900);
    }

    @Deprecated
    public int getMonth() {
        return this.normalize().getMonth() - 1;
    }

    @Deprecated
    public void setMonth(int n2) {
        int n3 = 0;
        if (n2 >= 12) {
            n3 = n2 / 12;
            n2 %= 12;
        } else if (n2 < 0) {
            n3 = CalendarUtils.floorDivide(n2, 12);
            n2 = CalendarUtils.mod(n2, 12);
        }
        BaseCalendar.Date date = this.getCalendarDate();
        if (n3 != 0) {
            date.setNormalizedYear(date.getNormalizedYear() + n3);
        }
        date.setMonth(n2 + 1);
    }

    @Deprecated
    public int getDate() {
        return this.normalize().getDayOfMonth();
    }

    @Deprecated
    public void setDate(int n2) {
        this.getCalendarDate().setDayOfMonth(n2);
    }

    @Deprecated
    public int getDay() {
        return this.normalize().getDayOfWeek() - 1;
    }

    @Deprecated
    public int getHours() {
        return this.normalize().getHours();
    }

    @Deprecated
    public void setHours(int n2) {
        this.getCalendarDate().setHours(n2);
    }

    @Deprecated
    public int getMinutes() {
        return this.normalize().getMinutes();
    }

    @Deprecated
    public void setMinutes(int n2) {
        this.getCalendarDate().setMinutes(n2);
    }

    @Deprecated
    public int getSeconds() {
        return this.normalize().getSeconds();
    }

    @Deprecated
    public void setSeconds(int n2) {
        this.getCalendarDate().setSeconds(n2);
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        if (this.cdate != null) {
            this.normalize();
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.cdate);
            this.fastTime = baseCalendar.getTime(this.cdate);
        }
        return this.fastTime;
    }

    public void setTime(long l2) {
        this.fastTime = l2;
        this.cdate = null;
    }

    public boolean before(Date date) {
        return Date.getMillisOf(this) < Date.getMillisOf(date);
    }

    public boolean after(Date date) {
        return Date.getMillisOf(this) > Date.getMillisOf(date);
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    static final long getMillisOf(Date date) {
        if (date.cdate == null) {
            return date.fastTime;
        }
        BaseCalendar.Date date2 = (BaseCalendar.Date)date.cdate.clone();
        return gcal.getTime(date2);
    }

    @Override
    public int compareTo(Date date) {
        long l2;
        long l3 = Date.getMillisOf(this);
        return l3 < (l2 = Date.getMillisOf(date)) ? -1 : (l3 == l2 ? 0 : 1);
    }

    public int hashCode() {
        long l2 = this.getTime();
        return (int)l2 ^ (int)(l2 >> 32);
    }

    public String toString() {
        BaseCalendar.Date date = this.normalize();
        StringBuilder stringBuilder = new StringBuilder(28);
        int n2 = date.getDayOfWeek();
        if (n2 == 1) {
            n2 = 8;
        }
        Date.convertToAbbr(stringBuilder, wtb[n2]).append(' ');
        Date.convertToAbbr(stringBuilder, wtb[date.getMonth() - 1 + 2 + 7]).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getDayOfMonth(), 2).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getSeconds(), 2).append(' ');
        TimeZone timeZone = date.getZone();
        if (timeZone != null) {
            stringBuilder.append(timeZone.getDisplayName(date.isDaylightTime(), 0, Locale.US));
        } else {
            stringBuilder.append("GMT");
        }
        stringBuilder.append(' ').append(date.getYear());
        return stringBuilder.toString();
    }

    private static final StringBuilder convertToAbbr(StringBuilder stringBuilder, String string) {
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.charAt(1)).append(string.charAt(2));
        return stringBuilder;
    }

    @Deprecated
    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(this);
    }

    @Deprecated
    public String toGMTString() {
        long l2 = this.getTime();
        BaseCalendar baseCalendar = Date.getCalendarSystem(l2);
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.getTime(), (TimeZone)null);
        StringBuilder stringBuilder = new StringBuilder(32);
        CalendarUtils.sprintf0d(stringBuilder, date.getDayOfMonth(), 1).append(' ');
        Date.convertToAbbr(stringBuilder, wtb[date.getMonth() - 1 + 2 + 7]).append(' ');
        stringBuilder.append(date.getYear()).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getSeconds(), 2);
        stringBuilder.append(" GMT");
        return stringBuilder.toString();
    }

    @Deprecated
    public int getTimezoneOffset() {
        int n2;
        if (this.cdate == null) {
            TimeZone timeZone = TimeZone.getDefaultRef();
            n2 = timeZone instanceof ZoneInfo ? ((ZoneInfo)timeZone).getOffsets(this.fastTime, null) : timeZone.getOffset(this.fastTime);
        } else {
            this.normalize();
            n2 = this.cdate.getZoneOffset();
        }
        return -n2 / 60000;
    }

    private final BaseCalendar.Date getCalendarDate() {
        if (this.cdate == null) {
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.fastTime);
            this.cdate = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.fastTime, TimeZone.getDefaultRef());
        }
        return this.cdate;
    }

    private final BaseCalendar.Date normalize() {
        if (this.cdate == null) {
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.fastTime);
            this.cdate = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.fastTime, TimeZone.getDefaultRef());
        } else {
            TimeZone timeZone = TimeZone.getDefaultRef();
            if (timeZone != this.cdate.getZone()) {
                BaseCalendar baseCalendar = Date.getCalendarSystem(this.cdate);
                long l2 = baseCalendar.getTime(this.cdate);
                this.cdate.setZone(timeZone);
                baseCalendar.getCalendarDate(l2, this.cdate);
            }
            this.cdate = Date.normalize(this.cdate);
        }
        return this.cdate;
    }

    private static final BaseCalendar.Date normalize(BaseCalendar.Date date) {
        long l2;
        BaseCalendar baseCalendar;
        int n2 = date.getNormalizedYear();
        int n3 = date.getMonth();
        int n4 = date.getDayOfMonth();
        int n5 = date.getHours();
        int n6 = date.getMinutes();
        int n7 = date.getSeconds();
        int n8 = date.getMillis();
        TimeZone timeZone = date.getZone();
        if (n2 == 1582 || n2 > 280000000 || n2 < -280000000) {
            if (timeZone == null) {
                timeZone = TimeZone.getTimeZone("GMT");
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.clear();
            gregorianCalendar.set(14, n8);
            gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, n7);
            long l3 = gregorianCalendar.getTimeInMillis();
            BaseCalendar baseCalendar2 = Date.getCalendarSystem(l3);
            date = (BaseCalendar.Date)baseCalendar2.getCalendarDate(l3, timeZone);
            return date;
        }
        BaseCalendar baseCalendar3 = Date.getCalendarSystem(n2);
        if (baseCalendar3 != Date.getCalendarSystem(date)) {
            date = (BaseCalendar.Date)baseCalendar3.newCalendarDate(timeZone);
            date.setNormalizedDate(n2, n3, n4).setTimeOfDay(n5, n6, n7, n8);
        }
        if ((baseCalendar = Date.getCalendarSystem(l2 = baseCalendar3.getTime(date))) != baseCalendar3) {
            date = (BaseCalendar.Date)baseCalendar.newCalendarDate(date.getZone());
            date.setNormalizedDate(n2, n3, n4).setTimeOfDay(n5, n6, n7, n8);
            baseCalendar.getTime(date);
        }
        return date;
    }

    private static final BaseCalendar getCalendarSystem(int n2) {
        if (n2 >= 1582) {
            return gcal;
        }
        return Date.getJulianCalendar();
    }

    private static final BaseCalendar getCalendarSystem(long l2) {
        if (l2 >= -12219292800000L) {
            return gcal;
        }
        return Date.getJulianCalendar();
    }

    private static final BaseCalendar getCalendarSystem(BaseCalendar.Date date) {
        if (jcal == null) {
            return gcal;
        }
        if (date.getEra() != null) {
            return jcal;
        }
        return gcal;
    }

    private static final synchronized BaseCalendar getJulianCalendar() {
        if (jcal == null) {
            jcal = (BaseCalendar)CalendarSystem.forName("julian");
        }
        return jcal;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTimeImpl());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    static {
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    }
}

