/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import sun.util.calendar.AbstractCalendar;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Gregorian;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final Gregorian gcal = CalendarSystem.getGregorianCalendar();
    private transient long cacheYear;
    private transient long cacheStart;
    private transient long cacheEnd;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    public static final int WALL_TIME = 0;
    public static final int STANDARD_TIME = 1;
    public static final int UTC_TIME = 2;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;

    public SimpleTimeZone(int n2, String string) {
        this.rawOffset = n2;
        this.setID(string);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this(n2, string, n3, n4, n5, n6, 0, n7, n8, n9, n10, 0, 3600000);
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this(n2, string, n3, n4, n5, n6, 0, n7, n8, n9, n10, 0, n11);
    }

    public SimpleTimeZone(int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.setID(string);
        this.rawOffset = n2;
        this.startMonth = n3;
        this.startDay = n4;
        this.startDayOfWeek = n5;
        this.startTime = n6;
        this.startTimeMode = n7;
        this.endMonth = n8;
        this.endDay = n9;
        this.endDayOfWeek = n10;
        this.endTime = n11;
        this.endTimeMode = n12;
        this.dstSavings = n13;
        this.decodeRules();
        if (n13 <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + n13);
        }
    }

    public void setStartYear(int n2) {
        this.startYear = n2;
        this.invalidateCache();
    }

    public void setStartRule(int n2, int n3, int n4, int n5) {
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.startTimeMode = 0;
        this.decodeStartRule();
        this.invalidateCache();
    }

    public void setStartRule(int n2, int n3, int n4) {
        this.setStartRule(n2, n3, 0, n4);
    }

    public void setStartRule(int n2, int n3, int n4, int n5, boolean bl2) {
        if (bl2) {
            this.setStartRule(n2, n3, -n4, n5);
        } else {
            this.setStartRule(n2, -n3, -n4, n5);
        }
    }

    public void setEndRule(int n2, int n3, int n4, int n5) {
        this.endMonth = n2;
        this.endDay = n3;
        this.endDayOfWeek = n4;
        this.endTime = n5;
        this.endTimeMode = 0;
        this.decodeEndRule();
        this.invalidateCache();
    }

    public void setEndRule(int n2, int n3, int n4) {
        this.setEndRule(n2, n3, 0, n4);
    }

    public void setEndRule(int n2, int n3, int n4, int n5, boolean bl2) {
        if (bl2) {
            this.setEndRule(n2, n3, -n4, n5);
        } else {
            this.setEndRule(n2, -n3, -n4, n5);
        }
    }

    public int getOffset(long l2) {
        return this.getOffsets(l2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOffsets(long l2, int[] nArray) {
        int n2;
        block7: {
            n2 = this.rawOffset;
            if (this.useDaylight) {
                Object object = this;
                synchronized (object) {
                    if (this.cacheStart != 0L && l2 >= this.cacheStart && l2 < this.cacheEnd) {
                        n2 += this.dstSavings;
                        break block7;
                    }
                }
                object = l2 >= -12219292800000L ? gcal : (BaseCalendar)CalendarSystem.forName("julian");
                BaseCalendar.Date date = (BaseCalendar.Date)((CalendarSystem)object).newCalendarDate(TimeZone.NO_TIMEZONE);
                ((AbstractCalendar)object).getCalendarDate(l2 + (long)this.rawOffset, date);
                int n3 = date.getNormalizedYear();
                if (n3 >= this.startYear) {
                    date.setTimeOfDay(0, 0, 0, 0);
                    n2 = this.getOffset((BaseCalendar)object, date, n3, l2);
                }
            }
        }
        if (nArray != null) {
            nArray[0] = this.rawOffset;
            nArray[1] = n2 - this.rawOffset;
        }
        return n2;
    }

    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Illegal era " + n2);
        }
        int n8 = n3;
        if (n2 == 0) {
            n8 = 1 - n8;
        }
        if (n8 >= 292278994) {
            n8 = 2800 + n8 % 2800;
        } else if (n8 <= -292269054) {
            n8 = (int)CalendarUtils.mod((long)n8, 28L);
        }
        int n9 = n4 + 1;
        BaseCalendar baseCalendar = gcal;
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
        date.setDate(n8, n9, n5);
        long l2 = baseCalendar.getTime(date);
        if ((l2 += (long)(n7 - this.rawOffset)) < -12219292800000L) {
            baseCalendar = (BaseCalendar)CalendarSystem.forName("julian");
            date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
            date.setNormalizedDate(n8, n9, n5);
            l2 = baseCalendar.getTime(date) + (long)n7 - (long)this.rawOffset;
        }
        if (date.getNormalizedYear() != n8 || date.getMonth() != n9 || date.getDayOfMonth() != n5 || n6 < 1 || n6 > 7 || n7 < 0 || n7 >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (!this.useDaylight || n3 < this.startYear || n2 != 1) {
            return this.rawOffset;
        }
        return this.getOffset(baseCalendar, date, n8, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOffset(BaseCalendar baseCalendar, BaseCalendar.Date date, int n2, long l2) {
        SimpleTimeZone simpleTimeZone = this;
        synchronized (simpleTimeZone) {
            if (this.cacheStart != 0L) {
                if (l2 >= this.cacheStart && l2 < this.cacheEnd) {
                    return this.rawOffset + this.dstSavings;
                }
                if ((long)n2 == this.cacheYear) {
                    return this.rawOffset;
                }
            }
        }
        long l3 = this.getStart(baseCalendar, date, n2);
        long l4 = this.getEnd(baseCalendar, date, n2);
        int n3 = this.rawOffset;
        if (l3 <= l4) {
            if (l2 >= l3 && l2 < l4) {
                n3 += this.dstSavings;
            }
            SimpleTimeZone simpleTimeZone2 = this;
            synchronized (simpleTimeZone2) {
                this.cacheYear = n2;
                this.cacheStart = l3;
                this.cacheEnd = l4;
            }
        }
        if (l2 < l4) {
            l3 = this.getStart(baseCalendar, date, n2 - 1);
            if (l2 >= l3) {
                n3 += this.dstSavings;
            }
        } else if (l2 >= l3 && l2 < (l4 = this.getEnd(baseCalendar, date, n2 + 1))) {
            n3 += this.dstSavings;
        }
        if (l3 <= l4) {
            SimpleTimeZone simpleTimeZone3 = this;
            synchronized (simpleTimeZone3) {
                this.cacheYear = (long)this.startYear - 1L;
                this.cacheStart = l3;
                this.cacheEnd = l4;
            }
        }
        return n3;
    }

    private long getStart(BaseCalendar baseCalendar, BaseCalendar.Date date, int n2) {
        int n3 = this.startTime;
        if (this.startTimeMode != 2) {
            n3 -= this.rawOffset;
        }
        return this.getTransition(baseCalendar, date, this.startMode, n2, this.startMonth, this.startDay, this.startDayOfWeek, n3);
    }

    private long getEnd(BaseCalendar baseCalendar, BaseCalendar.Date date, int n2) {
        int n3 = this.endTime;
        if (this.startTimeMode != 2) {
            n3 -= this.rawOffset;
        }
        if (this.startTimeMode == 0) {
            n3 -= this.dstSavings;
        }
        return this.getTransition(baseCalendar, date, this.endMode, n2, this.endMonth, this.endDay, this.endDayOfWeek, n3);
    }

    private long getTransition(BaseCalendar baseCalendar, BaseCalendar.Date date, int n2, int n3, int n4, int n5, int n6, int n7) {
        date.setNormalizedYear(n3);
        date.setMonth(n4 + 1);
        switch (n2) {
            case 1: {
                date.setDayOfMonth(n5);
                break;
            }
            case 2: {
                date.setDayOfMonth(1);
                if (n5 < 0) {
                    date.setDayOfMonth(baseCalendar.getMonthLength(date));
                }
                date = (BaseCalendar.Date)baseCalendar.getNthDayOfWeek(n5, n6, date);
                break;
            }
            case 3: {
                date.setDayOfMonth(n5);
                date = (BaseCalendar.Date)baseCalendar.getNthDayOfWeek(1, n6, date);
                break;
            }
            case 4: {
                date.setDayOfMonth(n5);
                date = (BaseCalendar.Date)baseCalendar.getNthDayOfWeek(-1, n6, date);
            }
        }
        return baseCalendar.getTime(date) + (long)n7;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n2) {
        this.rawOffset = n2;
    }

    public void setDSTSavings(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + n2);
        }
        this.dstSavings = n2;
    }

    public int getDSTSavings() {
        if (this.useDaylight) {
            return this.dstSavings;
        }
        return 0;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        return this.getOffset(date.getTime()) != this.rawOffset;
    }

    public Object clone() {
        return super.clone();
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        return this.getID().equals(simpleTimeZone.getID()) && this.hasSameRules(simpleTimeZone);
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        return this.rawOffset == simpleTimeZone.rawOffset && this.useDaylight == simpleTimeZone.useDaylight && (!this.useDaylight || this.dstSavings == simpleTimeZone.dstSavings && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode && this.startYear == simpleTimeZone.startYear);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode + ']';
    }

    private synchronized void invalidateCache() {
        this.cacheYear = this.startYear - 1;
        this.cacheEnd = 0L;
        this.cacheStart = 0L;
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl2 = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime >= 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void decodeEndRule() {
        boolean bl2 = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime >= 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                this.startDay = this.startDay >= 30 ? -1 : 1 + this.startDay / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                break;
            }
            case 4: {
                this.endDay = this.endDay >= 30 ? -1 : 1 + this.endDay / 7;
            }
        }
        switch (this.startTimeMode) {
            case 2: {
                this.startTime += this.rawOffset;
            }
        }
        while (this.startTime < 0) {
            this.startTime += 86400000;
            this.startDayOfWeek = 1 + (this.startDayOfWeek + 5) % 7;
        }
        while (this.startTime >= 86400000) {
            this.startTime -= 86400000;
            this.startDayOfWeek = 1 + this.startDayOfWeek % 7;
        }
        switch (this.endTimeMode) {
            case 2: {
                this.endTime += this.rawOffset + this.dstSavings;
                break;
            }
            case 1: {
                this.endTime += this.dstSavings;
            }
        }
        while (this.endTime < 0) {
            this.endTime += 86400000;
            this.endDayOfWeek = 1 + (this.endDayOfWeek + 5) % 7;
        }
        while (this.endTime >= 86400000) {
            this.endTime -= 86400000;
            this.endDayOfWeek = 1 + this.endDayOfWeek % 7;
        }
    }

    private byte[] packRules() {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek, (byte)this.startTimeMode, (byte)this.endTimeMode};
        return byArray;
    }

    private void unpackRules(byte[] byArray) {
        this.startDay = byArray[0];
        this.startDayOfWeek = byArray[1];
        this.endDay = byArray[2];
        this.endDayOfWeek = byArray[3];
        if (byArray.length >= 6) {
            this.startTimeMode = byArray[4];
            this.endTimeMode = byArray[5];
        }
    }

    private int[] packTimes() {
        int[] nArray = new int[]{this.startTime, this.endTime};
        return nArray;
    }

    private void unpackTimes(int[] nArray) {
        this.startTime = nArray[0];
        this.endTime = nArray[1];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.packRules();
        int[] nArray = this.packTimes();
        this.makeRulesCompatible();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        objectOutputStream.writeObject(nArray);
        this.unpackRules(byArray);
        this.unpackTimes(nArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int n2 = objectInputStream.readInt();
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray);
            this.unpackRules(byArray);
        }
        if (this.serialVersionOnStream >= 2) {
            int[] nArray = (int[])objectInputStream.readObject();
            this.unpackTimes(nArray);
        }
        this.serialVersionOnStream = 2;
    }
}

