/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(int[].class);
    private static final int scale = unsafe.arrayIndexScale(int[].class);
    private final int[] array;

    private long rawIndex(int n2) {
        if (n2 < 0 || n2 >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n2);
        }
        return base + n2 * scale;
    }

    public AtomicIntegerArray(int n2) {
        this.array = new int[n2];
        if (n2 > 0) {
            unsafe.putIntVolatile(this.array, this.rawIndex(0), 0);
        }
    }

    public AtomicIntegerArray(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        int n2 = nArray.length;
        this.array = new int[n2];
        if (n2 > 0) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.array[i2] = nArray[i2];
            }
            unsafe.putIntVolatile(this.array, this.rawIndex(n3), nArray[n3]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int n2) {
        return unsafe.getIntVolatile(this.array, this.rawIndex(n2));
    }

    public final void set(int n2, int n3) {
        unsafe.putIntVolatile(this.array, this.rawIndex(n2), n3);
    }

    public final int getAndSet(int n2, int n3) {
        int n4;
        while (!this.compareAndSet(n2, n4 = this.get(n2), n3)) {
        }
        return n4;
    }

    public final boolean compareAndSet(int n2, int n3, int n4) {
        return unsafe.compareAndSwapInt(this.array, this.rawIndex(n2), n3, n4);
    }

    public final boolean weakCompareAndSet(int n2, int n3, int n4) {
        return this.compareAndSet(n2, n3, n4);
    }

    public final int getAndIncrement(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n2, n4 = this.get(n2), n3 = n4 + 1)) {
        }
        return n4;
    }

    public final int getAndDecrement(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n2, n4 = this.get(n2), n3 = n4 - 1)) {
        }
        return n4;
    }

    public final int getAndAdd(int n2, int n3) {
        int n4;
        int n5;
        while (!this.compareAndSet(n2, n5 = this.get(n2), n4 = n5 + n3)) {
        }
        return n5;
    }

    public final int incrementAndGet(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n2, n4 = this.get(n2), n3 = n4 + 1)) {
        }
        return n3;
    }

    public final int decrementAndGet(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n2, n4 = this.get(n2), n3 = n4 - 1)) {
        }
        return n3;
    }

    public final int addAndGet(int n2, int n3) {
        int n4;
        int n5;
        while (!this.compareAndSet(n2, n5 = this.get(n2), n4 = n5 + n3)) {
        }
        return n4;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

