/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        return new AtomicIntegerFieldUpdaterImpl<U>(clazz, string);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T t2, int n2) {
        int n3;
        while (!this.compareAndSet(t2, n3 = this.get(t2), n2)) {
        }
        return n3;
    }

    public int getAndIncrement(T t2) {
        int n2;
        int n3;
        while (!this.compareAndSet(t2, n3 = this.get(t2), n2 = n3 + 1)) {
        }
        return n3;
    }

    public int getAndDecrement(T t2) {
        int n2;
        int n3;
        while (!this.compareAndSet(t2, n3 = this.get(t2), n2 = n3 - 1)) {
        }
        return n3;
    }

    public int getAndAdd(T t2, int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(t2, n4 = this.get(t2), n3 = n4 + n2)) {
        }
        return n4;
    }

    public int incrementAndGet(T t2) {
        int n2;
        int n3;
        while (!this.compareAndSet(t2, n3 = this.get(t2), n2 = n3 + 1)) {
        }
        return n2;
    }

    public int decrementAndGet(T t2) {
        int n2;
        int n3;
        while (!this.compareAndSet(t2, n3 = this.get(t2), n2 = n3 - 1)) {
        }
        return n2;
    }

    public int addAndGet(T t2, int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(t2, n4 = this.get(t2), n3 = n4 + n2)) {
        }
        return n3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n2 = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n2 = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n2);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(n2)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n2) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T t2, int n2, int n3) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.compareAndSwapInt(t2, this.offset, n2, n3);
        }

        @Override
        public boolean weakCompareAndSet(T t2, int n2, int n3) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.compareAndSwapInt(t2, this.offset, n2, n3);
        }

        @Override
        public void set(T t2, int n2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            unsafe.putIntVolatile(t2, this.offset, n2);
        }

        @Override
        public final int get(T t2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t2);
            }
            return unsafe.getIntVolatile(t2, this.offset);
        }

        private void ensureProtectedAccess(T t2) {
            if (this.cclass.isInstance(t2)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t2.getClass().getName()));
        }
    }
}

