/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReentrantLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public ReentrantLock() {
        this.sync = new NonfairSync();
    }

    public ReentrantLock(boolean bl2) {
        this.sync = bl2 ? new FairSync() : new NonfairSync();
    }

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.sync.nonfairTryAcquire(1);
    }

    @Override
    public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1, timeUnit.toNanos(l2));
    }

    @Override
    public void unlock() {
        this.sync.release(1);
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        Thread thread = this.sync.getOwner();
        return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
    }

    static final class FairSync
    extends Sync {
        FairSync() {
        }

        final void lock() {
            this.acquire(1);
        }

        protected final boolean tryAcquire(int n2) {
            Thread thread = Thread.currentThread();
            int n3 = this.getState();
            if (n3 == 0) {
                Thread thread2 = this.getFirstQueuedThread();
                if ((thread2 == null || thread2 == thread) && this.compareAndSetState(0, n2)) {
                    this.owner = thread;
                    return true;
                }
            } else if (thread == this.owner) {
                this.setState(n3 + n2);
                return true;
            }
            return false;
        }
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync() {
        }

        final void lock() {
            if (this.compareAndSetState(0, 1)) {
                this.owner = Thread.currentThread();
            } else {
                this.acquire(1);
            }
        }

        protected final boolean tryAcquire(int n2) {
            return this.nonfairTryAcquire(n2);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        transient Thread owner;

        Sync() {
        }

        abstract void lock();

        final boolean nonfairTryAcquire(int n2) {
            Thread thread = Thread.currentThread();
            int n3 = this.getState();
            if (n3 == 0) {
                if (this.compareAndSetState(0, n2)) {
                    this.owner = thread;
                    return true;
                }
            } else if (thread == this.owner) {
                this.setState(n3 + n2);
                return true;
            }
            return false;
        }

        protected final boolean tryRelease(int n2) {
            int n3 = this.getState() - n2;
            if (Thread.currentThread() != this.owner) {
                throw new IllegalMonitorStateException();
            }
            boolean bl2 = false;
            if (n3 == 0) {
                bl2 = true;
                this.owner = null;
            }
            this.setState(n3);
            return bl2;
        }

        protected final boolean isHeldExclusively() {
            return this.getState() != 0 && this.owner == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject();
        }

        final Thread getOwner() {
            int n2 = this.getState();
            Thread thread = this.owner;
            return n2 == 0 ? null : thread;
        }

        final int getHoldCount() {
            int n2 = this.getState();
            Thread thread = this.owner;
            return thread == Thread.currentThread() ? n2 : 0;
        }

        final boolean isLocked() {
            return this.getState() != 0;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.setState(0);
        }
    }
}

