/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.io.Converters;

public class XMLFormatter
extends Formatter {
    private LogManager manager = LogManager.getLogManager();

    private void a2(StringBuffer stringBuffer, int n2) {
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l2) {
        Date date = new Date(l2);
        stringBuffer.append(date.getYear() + 1900);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getMonth() + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getDate());
        stringBuffer.append('T');
        this.a2(stringBuffer, date.getHours());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getMinutes());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getSeconds());
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c2);
        }
    }

    public String format(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<record>\n");
        stringBuffer.append("  <date>");
        this.appendISO8601(stringBuffer, logRecord.getMillis());
        stringBuffer.append("</date>\n");
        stringBuffer.append("  <millis>");
        stringBuffer.append(logRecord.getMillis());
        stringBuffer.append("</millis>\n");
        stringBuffer.append("  <sequence>");
        stringBuffer.append(logRecord.getSequenceNumber());
        stringBuffer.append("</sequence>\n");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuffer.append("  <logger>");
            this.escape(stringBuffer, string);
            stringBuffer.append("</logger>\n");
        }
        stringBuffer.append("  <level>");
        this.escape(stringBuffer, logRecord.getLevel().toString());
        stringBuffer.append("</level>\n");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append("  <class>");
            this.escape(stringBuffer, logRecord.getSourceClassName());
            stringBuffer.append("</class>\n");
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append("  <method>");
            this.escape(stringBuffer, logRecord.getSourceMethodName());
            stringBuffer.append("</method>\n");
        }
        stringBuffer.append("  <thread>");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("</thread>\n");
        if (logRecord.getMessage() != null) {
            object = this.formatMessage(logRecord);
            stringBuffer.append("  <message>");
            this.escape(stringBuffer, (String)object);
            stringBuffer.append("</message>");
            stringBuffer.append("\n");
        }
        object = logRecord.getResourceBundle();
        try {
            if (object != null && ((ResourceBundle)object).getString(logRecord.getMessage()) != null) {
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, logRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length != 0 && logRecord.getMessage().indexOf("{") == -1) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append("  <param>");
                try {
                    this.escape(stringBuffer, objectArray[i2].toString());
                }
                catch (Exception exception) {
                    stringBuffer.append("???");
                }
                stringBuffer.append("</param>\n");
            }
        }
        if (logRecord.getThrown() != null) {
            Throwable throwable = logRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, throwable.toString());
            stringBuffer.append("</message>\n");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i3 = 0; i3 < stackTraceElementArray.length; ++i3) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i3];
                stringBuffer.append("    <frame>\n");
                stringBuffer.append("      <class>");
                this.escape(stringBuffer, stackTraceElement.getClassName());
                stringBuffer.append("</class>\n");
                stringBuffer.append("      <method>");
                this.escape(stringBuffer, stackTraceElement.getMethodName());
                stringBuffer.append("</method>\n");
                if (stackTraceElement.getLineNumber() >= 0) {
                    stringBuffer.append("      <line>");
                    stringBuffer.append(stackTraceElement.getLineNumber());
                    stringBuffer.append("</line>\n");
                }
                stringBuffer.append("    </frame>\n");
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"");
        String string = handler != null ? handler.getEncoding() : null;
        if (string == null) {
            string = Converters.getDefaultEncodingName();
        }
        try {
            Charset charset = Charset.forName(string);
            string = charset.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(" encoding=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        stringBuffer.append(" standalone=\"no\"?>\n");
        stringBuffer.append("<!DOCTYPE log SYSTEM \"logger.dtd\">\n");
        stringBuffer.append("<log>\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>\n";
    }
}

