/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.Rfc2253Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapName
implements Name {
    private transient ArrayList rdns;
    private transient String unparsed;
    private static final long serialVersionUID = -1595520034788997356L;

    public LdapName(String string) throws InvalidNameException {
        this.unparsed = string;
        this.parse();
    }

    public LdapName(List<Rdn> list) {
        this.rdns = new ArrayList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Rdn rdn = list.get(i2);
            if (!(rdn instanceof Rdn)) {
                throw new IllegalArgumentException("Entry:" + rdn + "  not a valid type;list entries must be of type Rdn");
            }
            this.rdns.add(rdn);
        }
    }

    private LdapName(String string, ArrayList arrayList, int n2, int n3) {
        this.unparsed = string;
        List list = arrayList.subList(n2, n3);
        this.rdns = new ArrayList(list);
    }

    @Override
    public int size() {
        return this.rdns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        final Iterator iterator = this.rdns.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return iterator.next().toString();
            }
        };
    }

    @Override
    public String get(int n2) {
        return this.rdns.get(n2).toString();
    }

    public Rdn getRdn(int n2) {
        return (Rdn)this.rdns.get(n2);
    }

    @Override
    public Name getPrefix(int n2) {
        try {
            return new LdapName(null, this.rdns, 0, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Posn: " + n2 + ", Size: " + this.rdns.size());
        }
    }

    @Override
    public Name getSuffix(int n2) {
        try {
            return new LdapName(null, this.rdns, n2, this.rdns.size());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Posn: " + n2 + ", Size: " + this.rdns.size());
        }
    }

    @Override
    public boolean startsWith(Name name) {
        int n2;
        if (name == null) {
            return false;
        }
        int n3 = this.rdns.size();
        return n3 >= (n2 = name.size()) && this.matches(0, n2, name);
    }

    public boolean startsWith(List<Rdn> list) {
        int n2;
        if (list == null) {
            return false;
        }
        int n3 = this.rdns.size();
        return n3 >= (n2 = list.size()) && this.doesListMatch(0, n2, list);
    }

    @Override
    public boolean endsWith(Name name) {
        int n2;
        if (name == null) {
            return false;
        }
        int n3 = this.rdns.size();
        return n3 >= (n2 = name.size()) && this.matches(n3 - n2, n3, name);
    }

    public boolean endsWith(List<Rdn> list) {
        int n2;
        if (list == null) {
            return false;
        }
        int n3 = this.rdns.size();
        return n3 >= (n2 = list.size()) && this.doesListMatch(n3 - n2, n3, list);
    }

    private boolean doesListMatch(int n2, int n3, List list) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (this.rdns.get(i2).equals(list.get(i2 - n2))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(int n2, int n3, Name name) {
        if (name instanceof LdapName) {
            LdapName ldapName = (LdapName)name;
            return this.doesListMatch(n2, n3, ldapName.rdns);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            Rdn rdn;
            String string = name.get(i2 - n2);
            try {
                rdn = new Rfc2253Parser(string).parseRdn();
            }
            catch (InvalidNameException invalidNameException) {
                return false;
            }
            if (rdn.equals(this.rdns.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    public Name addAll(List<Rdn> list) {
        return this.addAll(this.size(), list);
    }

    @Override
    public Name addAll(int n2, Name name) throws InvalidNameException {
        this.unparsed = null;
        if (name instanceof LdapName) {
            LdapName ldapName = (LdapName)name;
            this.rdns.addAll(n2, ldapName.rdns);
        } else {
            Enumeration<String> enumeration = name.getAll();
            while (enumeration.hasMoreElements()) {
                this.rdns.add(n2++, new Rfc2253Parser(enumeration.nextElement()).parseRdn());
            }
        }
        return this;
    }

    public Name addAll(int n2, List<Rdn> list) {
        this.unparsed = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Rdn rdn = list.get(i2);
            if (!(rdn instanceof Rdn)) {
                throw new IllegalArgumentException("Entry:" + rdn + "  not a valid type;suffix list entries must be of type Rdn");
            }
            this.rdns.add(i2 + n2, rdn);
        }
        return this;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    public Name add(Rdn rdn) {
        return this.add(this.size(), rdn);
    }

    @Override
    public Name add(int n2, String string) throws InvalidNameException {
        Rdn rdn = new Rfc2253Parser(string).parseRdn();
        this.rdns.add(n2, rdn);
        this.unparsed = null;
        return this;
    }

    public Name add(int n2, Rdn rdn) {
        if (rdn == null) {
            throw new NullPointerException("Cannot set comp to null");
        }
        this.rdns.add(n2, rdn);
        this.unparsed = null;
        return this;
    }

    @Override
    public Object remove(int n2) throws InvalidNameException {
        this.unparsed = null;
        return this.rdns.remove(n2).toString();
    }

    public List<Rdn> getRdns() {
        return Collections.unmodifiableList(this.rdns);
    }

    @Override
    public Object clone() {
        return new LdapName(this.unparsed, this.rdns, 0, this.rdns.size());
    }

    public String toString() {
        if (this.unparsed != null) {
            return this.unparsed;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.rdns.size();
        if (n2 - 1 >= 0) {
            stringBuilder.append((Rdn)this.rdns.get(n2 - 1));
        }
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            stringBuilder.append(',');
            stringBuilder.append((Rdn)this.rdns.get(i2));
        }
        this.unparsed = stringBuilder.toString();
        return this.unparsed;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LdapName)) {
            return false;
        }
        LdapName ldapName = (LdapName)object;
        if (this.rdns.size() != ldapName.rdns.size()) {
            return false;
        }
        if (this.unparsed != null && this.unparsed.equalsIgnoreCase(ldapName.unparsed)) {
            return true;
        }
        for (int i2 = 0; i2 < this.rdns.size(); ++i2) {
            Rdn rdn;
            Rdn rdn2 = (Rdn)this.rdns.get(i2);
            if (rdn2.equals(rdn = (Rdn)ldapName.rdns.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof LdapName)) {
            throw new ClassCastException("The obj is not a LdapName");
        }
        if (object == this) {
            return 0;
        }
        LdapName ldapName = (LdapName)object;
        if (this.unparsed != null && this.unparsed.equalsIgnoreCase(ldapName.unparsed)) {
            return 0;
        }
        int n2 = Math.min(this.rdns.size(), ldapName.rdns.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            Rdn rdn;
            Rdn rdn2 = (Rdn)this.rdns.get(i2);
            int n3 = rdn2.compareTo(rdn = (Rdn)ldapName.rdns.get(i2));
            if (n3 == 0) continue;
            return n3;
        }
        return this.rdns.size() - ldapName.rdns.size();
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.rdns.size(); ++i2) {
            Rdn rdn = (Rdn)this.rdns.get(i2);
            n2 += rdn.hashCode();
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.unparsed = (String)objectInputStream.readObject();
        try {
            this.parse();
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.unparsed);
        }
    }

    private void parse() throws InvalidNameException {
        this.rdns = (ArrayList)new Rfc2253Parser(this.unparsed).parseDn();
    }
}

