/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JTextArea
extends JTextComponent {
    private static final String uiClassID = "TextAreaUI";
    private int rows;
    private int columns;
    private int columnWidth;
    private int rowHeight;
    private boolean wrap;
    private boolean word;

    public JTextArea() {
        this(null, null, 0, 0);
    }

    public JTextArea(String string) {
        this(null, string, 0, 0);
    }

    public JTextArea(int n2, int n3) {
        this(null, null, n2, n3);
    }

    public JTextArea(String string, int n2, int n3) {
        this(null, string, n2, n3);
    }

    public JTextArea(Document document) {
        this(document, null, 0, 0);
    }

    public JTextArea(Document document, String string, int n2, int n3) {
        this.rows = n2;
        this.columns = n3;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
            this.select(0, 0);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("rows: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("columns: " + n3);
        }
        LookAndFeel.installProperty(this, "focusTraversalKeysForward", JComponent.getManagingFocusForwardTraversalKeys());
        LookAndFeel.installProperty(this, "focusTraversalKeysBackward", JComponent.getManagingFocusBackwardTraversalKeys());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public void setTabSize(int n2) {
        Document document = this.getDocument();
        if (document != null) {
            int n3 = this.getTabSize();
            document.putProperty("tabSize", new Integer(n2));
            this.firePropertyChange("tabSize", n3, n2);
        }
    }

    public int getTabSize() {
        Integer n2;
        int n3 = 8;
        Document document = this.getDocument();
        if (document != null && (n2 = (Integer)document.getProperty("tabSize")) != null) {
            n3 = n2;
        }
        return n3;
    }

    public void setLineWrap(boolean bl2) {
        boolean bl3 = this.wrap;
        this.wrap = bl2;
        this.firePropertyChange("lineWrap", bl3, bl2);
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    public void setWrapStyleWord(boolean bl2) {
        boolean bl3 = this.word;
        this.word = bl2;
        this.firePropertyChange("wrapStyleWord", bl3, bl2);
    }

    public boolean getWrapStyleWord() {
        return this.word;
    }

    public int getLineOfOffset(int n2) throws BadLocationException {
        Document document = this.getDocument();
        if (n2 < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (n2 > document.getLength()) {
            throw new BadLocationException("Can't translate offset to line", document.getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementIndex(n2);
    }

    public int getLineCount() {
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementCount();
    }

    public int getLineStartOffset(int n2) throws BadLocationException {
        int n3 = this.getLineCount();
        if (n2 < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n2 >= n3) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n2);
        return element2.getStartOffset();
    }

    public int getLineEndOffset(int n2) throws BadLocationException {
        int n3 = this.getLineCount();
        if (n2 < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n2 >= n3) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n2);
        int n4 = element2.getEndOffset();
        return n2 == n3 - 1 ? n4 - 1 : n4;
    }

    public void insert(String string, int n2) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    public void append(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void replaceRange(String string, int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException("end before start");
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n2, n3 - n2, string, null);
                } else {
                    document.remove(n2, n3 - n2);
                    document.insertString(n2, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n2) {
        int n3 = this.rows;
        if (n2 < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (n2 != n3) {
            this.rows = n2;
            this.invalidate();
        }
    }

    protected int getRowHeight() {
        if (this.rowHeight == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.rowHeight = fontMetrics.getHeight();
        }
        return this.rowHeight;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n2) {
        int n3 = this.columns;
        if (n2 < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n2 != n3) {
            this.columns = n2;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension = dimension == null ? new Dimension(400, 400) : dimension;
        Insets insets = this.getInsets();
        if (this.columns != 0) {
            dimension.width = Math.max(dimension.width, this.columns * this.getColumnWidth() + insets.left + insets.right);
        }
        if (this.rows != 0) {
            dimension.height = Math.max(dimension.height, this.rows * this.getRowHeight() + insets.top + insets.bottom);
        }
        return dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.rowHeight = 0;
        this.columnWidth = 0;
    }

    protected String paramString() {
        String string = this.wrap ? "true" : "false";
        String string2 = this.word ? "true" : "false";
        return super.paramString() + ",colums=" + this.columns + ",columWidth=" + this.columnWidth + ",rows=" + this.rows + ",rowHeight=" + this.rowHeight + ",word=" + string2 + ",wrap=" + string;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.wrap ? true : super.getScrollableTracksViewportWidth();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension = dimension == null ? new Dimension(400, 400) : dimension;
        dimension.width = this.columns == 0 ? dimension.width : this.columns * this.getColumnWidth();
        dimension.height = this.rows == 0 ? dimension.height : this.rows * this.getRowHeight();
        return dimension;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return this.getRowHeight();
            }
            case 0: {
                return this.getColumnWidth();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTextArea
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextArea() {
            super(JTextArea.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }
}

