/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.ComponentInputMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookAndFeel {
    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(UIManager.getColor(string2));
        }
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string3));
        }
        LookAndFeel.installColors(jComponent, string, string2);
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(UIManager.getBorder(string));
        }
    }

    public static void uninstallBorder(JComponent jComponent) {
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    public static void installProperty(JComponent jComponent, String string, Object object) {
        jComponent.setUIProperty(string, object);
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] objectArray) {
        JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[objectArray.length / 2];
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            KeyStroke keyStroke = objectArray[i2] instanceof KeyStroke ? (KeyStroke)objectArray[i2] : KeyStroke.getKeyStroke((String)objectArray[i2]);
            String string = (String)objectArray[i2 + 1];
            keyBindingArray[i2 / 2] = new JTextComponent.KeyBinding(keyStroke, string);
        }
        return keyBindingArray;
    }

    public static InputMap makeInputMap(Object[] objectArray) {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        LookAndFeel.loadKeyBindings(inputMapUIResource, objectArray);
        return inputMapUIResource;
    }

    public static ComponentInputMap makeComponentInputMap(JComponent jComponent, Object[] objectArray) {
        ComponentInputMapUIResource componentInputMapUIResource = new ComponentInputMapUIResource(jComponent);
        LookAndFeel.loadKeyBindings(componentInputMapUIResource, objectArray);
        return componentInputMapUIResource;
    }

    public static void loadKeyBindings(InputMap inputMap, Object[] objectArray) {
        if (objectArray != null) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                KeyStroke keyStroke = (object = objectArray[i2++]) instanceof KeyStroke ? (KeyStroke)object : KeyStroke.getKeyStroke((String)object);
                inputMap.put(keyStroke, objectArray[i2]);
            }
        }
    }

    public static Object makeIcon(Class<?> clazz, String string) {
        return SwingUtilities2.makeIcon(clazz, clazz, string);
    }

    public void provideErrorFeedback(Component component) {
        Toolkit toolkit = null;
        toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    public static Object getDesktopPropertyValue(String string, Object object) {
        Object object2 = Toolkit.getDefaultToolkit().getDesktopProperty(string);
        if (object2 == null) {
            return object;
        }
        if (object2 instanceof Color) {
            return new ColorUIResource((Color)object2);
        }
        if (object2 instanceof Font) {
            return new FontUIResource((Font)object2);
        }
        return object2;
    }

    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (icon instanceof ImageIcon) {
            return new IconUIResource(new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage())));
        }
        return null;
    }

    public Icon getDisabledSelectedIcon(JComponent jComponent, Icon icon) {
        return this.getDisabledIcon(jComponent, icon);
    }

    public abstract String getName();

    public abstract String getID();

    public abstract String getDescription();

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public void initialize() {
    }

    public void uninitialize() {
    }

    public UIDefaults getDefaults() {
        return null;
    }

    public String toString() {
        return "[" + this.getDescription() + " - " + this.getClass().getName() + "]";
    }
}

