/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private Point textLoc = new Point();
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;

    public TitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public TitledBorder(Border border, String string, int n2, int n3) {
        this(border, string, n2, n3, null, null);
    }

    public TitledBorder(Border border, String string, int n2, int n3, Font font) {
        this(border, string, n2, n3, font, null);
    }

    public TitledBorder(Border border, String string, int n2, int n3, Font font, Color color) {
        this.title = string;
        this.border = border;
        this.titleFont = font;
        this.titleColor = color;
        this.setTitleJustification(n2);
        this.setTitlePosition(n3);
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(component, graphics, n2, n3, n4, n5);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(n2 + 2, n3 + 2, n4 - 4, n5 - 4);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont(component));
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.getDescent();
        int n8 = fontMetrics.getAscent();
        int n9 = SwingUtilities2.stringWidth(jComponent, fontMetrics, this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        int n10 = this.getTitlePosition();
        switch (n10) {
            case 1: {
                int n11 = n8 + n7 + (Math.max(2, 4) - 2);
                rectangle.y += n11;
                rectangle.height -= n11;
                this.textLoc.y = rectangle.y - (n7 + 2);
                break;
            }
            case 0: 
            case 2: {
                int n12 = Math.max(0, n8 / 2 + 2 - 2);
                rectangle.y += n12;
                rectangle.height -= n12;
                this.textLoc.y = rectangle.y - n7 + (insets.top + n8 + n7) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = rectangle.y + insets.top + n8 + 2;
                break;
            }
            case 4: {
                this.textLoc.y = rectangle.y + rectangle.height - (insets.bottom + n7 + 2);
                break;
            }
            case 5: {
                rectangle.height -= n6 / 2;
                this.textLoc.y = rectangle.y + rectangle.height - n7 + (n8 + n7 - insets.bottom) / 2;
                break;
            }
            case 6: {
                rectangle.height -= n6;
                this.textLoc.y = rectangle.y + rectangle.height + n8 + 2;
            }
        }
        int n13 = this.getTitleJustification();
        if (TitledBorder.isLeftToRight(component)) {
            if (n13 == 4 || n13 == 0) {
                n13 = 1;
            } else if (n13 == 5) {
                n13 = 3;
            }
        } else if (n13 == 4 || n13 == 0) {
            n13 = 3;
        } else if (n13 == 5) {
            n13 = 1;
        }
        switch (n13) {
            case 1: {
                this.textLoc.x = rectangle.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = rectangle.x + rectangle.width - (n9 + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = rectangle.x + (rectangle.width - n9) / 2;
            }
        }
        if (border != null) {
            if ((n10 == 2 || n10 == 0) && rectangle.y > this.textLoc.y - n8 || n10 == 5 && rectangle.y + rectangle.height < this.textLoc.y + n7) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, n2, n3, this.textLoc.x - 1 - n2, n5)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x + n9 + 1, n3, n2 + n4 - (this.textLoc.x + n9 + 1), n5)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n10 == 2 || n10 == 0) {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, this.textLoc.y + n7, n9 + 2, n3 + n5 - this.textLoc.y - n7)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, n3, n9 + 2, this.textLoc.y - n8 - n3)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(this.getTitleColor());
        SwingUtilities2.drawString(jComponent, graphics, this.getTitle(), this.textLoc.x, this.textLoc.y);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Serializable serializable;
        int n2 = 0;
        int n3 = 16;
        int n4 = 16;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(component, insets);
            } else {
                serializable = border.getBorderInsets(component);
                insets.top = serializable.top;
                insets.right = serializable.right;
                insets.bottom = serializable.bottom;
                insets.left = serializable.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        insets.left += 4;
        insets.right += 4;
        insets.top += 4;
        insets.bottom += 4;
        if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        serializable = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics((Font)serializable);
        if (fontMetrics != null) {
            n2 = fontMetrics.getDescent();
            n3 = fontMetrics.getAscent();
            n4 = fontMetrics.getHeight();
        }
        switch (this.getTitlePosition()) {
            case 1: {
                insets.top += n3 + n2 + (Math.max(2, 4) - 2);
                break;
            }
            case 0: 
            case 2: {
                insets.top += n3 + n2;
                break;
            }
            case 3: {
                insets.top += n3 + n2 + 2;
                break;
            }
            case 4: {
                insets.bottom += n3 + n2 + 2;
                break;
            }
            case 5: {
                insets.bottom += n3 + n2;
                break;
            }
            case 6: {
                insets.bottom += n4;
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        Border border = this.border;
        if (border == null) {
            border = UIManager.getBorder("TitledBorder.border");
        }
        return border;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        Font font = this.titleFont;
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        return font;
    }

    public Color getTitleColor() {
        Color color = this.titleColor;
        if (color == null) {
            color = UIManager.getColor("TitledBorder.titleColor");
        }
        return color;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n2 + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n2 + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                dimension.width = Math.max(SwingUtilities2.stringWidth(jComponent, fontMetrics, this.getTitle()), dimension.width);
                break;
            }
            default: {
                dimension.width += SwingUtilities2.stringWidth(jComponent, fontMetrics, this.getTitle());
            }
        }
        return dimension;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private static boolean computeIntersection(Rectangle rectangle, int n2, int n3, int n4, int n5) {
        int n6 = Math.max(n2, rectangle.x);
        int n7 = Math.min(n2 + n4, rectangle.x + rectangle.width);
        int n8 = Math.max(n3, rectangle.y);
        int n9 = Math.min(n3 + n5, rectangle.y + rectangle.height);
        rectangle.x = n6;
        rectangle.y = n8;
        rectangle.width = n7 - n6;
        rectangle.height = n9 - n8;
        return rectangle.width > 0 && rectangle.height > 0;
    }
}

