/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthLabelUI
extends BasicLabelUI
implements SynthUI {
    private SynthStyle style;

    SynthLabelUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthLabelUI();
    }

    protected void installDefaults(JLabel jLabel) {
        this.updateStyle(jLabel);
    }

    void updateStyle(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        int n2 = SynthLookAndFeel.getComponentState(jComponent);
        if (SynthLookAndFeel.selectedUI == this && n2 == 1) {
            n2 = SynthLookAndFeel.selectedUIState | 1;
        }
        return n2;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintLabelBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JLabel jLabel = (JLabel)synthContext.getComponent();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
        graphics.setFont(this.style.getFont(synthContext));
        synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex(), 0);
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintLabelBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getPreferredSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMinimumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMaximumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JLabel)propertyChangeEvent.getSource());
        }
    }
}

