/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.PathPlaceHolder;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    protected int selectionMode = 4;
    protected TreePath leadPath;
    protected int leadIndex = -1;
    protected int leadRow = -1;
    private Hashtable uniquePaths = new Hashtable();
    private Hashtable lastPaths = new Hashtable();
    private TreePath[] tempPaths = new TreePath[1];

    @Override
    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
        this.resetRowSelection();
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setSelectionMode(int n2) {
        int n3 = this.selectionMode;
        this.selectionMode = n2;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (n3 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n3), new Integer(this.selectionMode));
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        if (treePath == null) {
            this.setSelectionPaths(null);
        } else {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.setSelectionPaths(treePathArray);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        int n2;
        TreePath[] treePathArray2 = treePathArray;
        int n3 = treePathArray2 == null ? 0 : treePathArray2.length;
        if (n3 + (n2 = this.selection == null ? 0 : this.selection.length) != 0) {
            Object object;
            TreePath[] treePathArray3;
            if (this.selectionMode == 1) {
                if (n3 > 1) {
                    treePathArray2 = new TreePath[]{treePathArray[0]};
                    n3 = 1;
                }
            } else if (this.selectionMode == 2 && n3 > 0 && !this.arePathsContiguous(treePathArray2)) {
                treePathArray2 = new TreePath[]{treePathArray[0]};
                n3 = 1;
            }
            int n4 = 0;
            TreePath treePath = this.leadPath;
            Vector<PathPlaceHolder> vector = new Vector<PathPlaceHolder>(n3 + n2);
            this.lastPaths.clear();
            this.leadPath = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (treePathArray2[i2] == null || this.lastPaths.get(treePathArray2[i2]) != null) continue;
                ++n4;
                this.lastPaths.put(treePathArray2[i2], Boolean.TRUE);
                if (this.uniquePaths.get(treePathArray2[i2]) == null) {
                    vector.addElement(new PathPlaceHolder(treePathArray2[i2], true));
                }
                this.leadPath = treePathArray2[i2];
            }
            if (n4 == 0) {
                treePathArray3 = null;
            } else if (n4 != n3) {
                object = this.lastPaths.keys();
                treePathArray3 = new TreePath[n4];
                n4 = 0;
                while (object.hasMoreElements()) {
                    treePathArray3[n4++] = (TreePath)object.nextElement();
                }
            } else {
                treePathArray3 = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, treePathArray3, 0, treePathArray2.length);
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.selection[i3] == null || this.lastPaths.get(this.selection[i3]) != null) continue;
                vector.addElement(new PathPlaceHolder(this.selection[i3], false));
            }
            this.selection = treePathArray3;
            object = this.uniquePaths;
            this.uniquePaths = this.lastPaths;
            this.lastPaths = object;
            this.lastPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (vector.size() > 0) {
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.addSelectionPaths(treePathArray);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        int n2;
        int n3 = n2 = treePathArray == null ? 0 : treePathArray.length;
        if (n2 > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(treePathArray);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(treePathArray)) {
                if (this.arePathsContiguous(treePathArray)) {
                    this.setSelectionPaths(treePathArray);
                } else {
                    TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
                    this.setSelectionPaths(treePathArray2);
                }
            } else {
                int n4;
                TreePath treePath = this.leadPath;
                Vector<PathPlaceHolder> vector = null;
                int n5 = this.selection == null ? 0 : this.selection.length;
                this.lastPaths.clear();
                int n6 = 0;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (treePathArray[n4] == null) continue;
                    if (this.uniquePaths.get(treePathArray[n4]) == null) {
                        ++n6;
                        if (vector == null) {
                            vector = new Vector<PathPlaceHolder>();
                        }
                        vector.addElement(new PathPlaceHolder(treePathArray[n4], true));
                        this.uniquePaths.put(treePathArray[n4], Boolean.TRUE);
                        this.lastPaths.put(treePathArray[n4], Boolean.TRUE);
                    }
                    this.leadPath = treePathArray[n4];
                }
                if (this.leadPath == null) {
                    this.leadPath = treePath;
                }
                if (n6 > 0) {
                    TreePath[] treePathArray3 = new TreePath[n5 + n6];
                    if (n5 > 0) {
                        System.arraycopy(this.selection, 0, treePathArray3, 0, n5);
                    }
                    if (n6 != treePathArray.length) {
                        Enumeration enumeration = this.lastPaths.keys();
                        n4 = n5;
                        while (enumeration.hasMoreElements()) {
                            treePathArray3[n4++] = (TreePath)enumeration.nextElement();
                        }
                    } else {
                        System.arraycopy(treePathArray, 0, treePathArray3, n5, n6);
                    }
                    this.selection = treePathArray3;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                } else {
                    this.leadPath = treePath;
                }
                this.lastPaths.clear();
            }
        }
    }

    @Override
    public void removeSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.removeSelectionPaths(treePathArray);
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null && this.selection != null && treePathArray.length > 0) {
            if (!this.canPathsBeRemoved(treePathArray)) {
                this.clearSelection();
            } else {
                int n2;
                Vector<PathPlaceHolder> vector = null;
                for (n2 = treePathArray.length - 1; n2 >= 0; --n2) {
                    if (treePathArray[n2] == null || this.uniquePaths.get(treePathArray[n2]) == null) continue;
                    if (vector == null) {
                        vector = new Vector<PathPlaceHolder>(treePathArray.length);
                    }
                    this.uniquePaths.remove(treePathArray[n2]);
                    vector.addElement(new PathPlaceHolder(treePathArray[n2], false));
                }
                if (vector != null) {
                    n2 = vector.size();
                    TreePath treePath = this.leadPath;
                    if (n2 == this.selection.length) {
                        this.selection = null;
                    } else {
                        Enumeration enumeration = this.uniquePaths.keys();
                        int n3 = 0;
                        this.selection = new TreePath[this.selection.length - n2];
                        while (enumeration.hasMoreElements()) {
                            this.selection[n3++] = (TreePath)enumeration.nextElement();
                        }
                    }
                    this.leadPath = this.leadPath != null && this.uniquePaths.get(this.leadPath) == null ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(vector, treePath);
                }
            }
        }
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int n2 = this.selection.length;
            TreePath[] treePathArray = new TreePath[n2];
            System.arraycopy(this.selection, 0, treePathArray, 0, n2);
            return treePathArray;
        }
        return null;
    }

    @Override
    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    @Override
    public boolean isPathSelected(TreePath treePath) {
        return treePath != null ? this.uniquePaths.get(treePath) != null : false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            int n2 = this.selection.length;
            boolean[] blArray = new boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                blArray[i2] = false;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, blArray, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.uniquePaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(TreeSelectionListener.class, treeSelectionListener);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(TreeSelectionListener.class, treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)objectArray[i2 + 1]).valueChanged(treeSelectionEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            if (nArray != null) {
                int n2 = 0;
                for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                    if (nArray[i2] != -1) continue;
                    ++n2;
                }
                if (n2 > 0) {
                    if (n2 == nArray.length) {
                        nArray = null;
                    } else {
                        int[] nArray2 = new int[nArray.length - n2];
                        int n3 = 0;
                        for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
                            if (nArray[i3] == -1) continue;
                            nArray2[n3++] = nArray[i3];
                        }
                        nArray = nArray2;
                    }
                }
            }
            return nArray;
        }
        return null;
    }

    @Override
    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isRowSelected(int n2) {
        return this.listSelectionModel.isSelectedIndex(n2);
    }

    @Override
    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            boolean bl2 = false;
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            int n2 = this.selection.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (n3 == -1) continue;
                this.listSelectionModel.addSelectionInterval(n3, n3);
            }
            if (this.leadIndex != -1 && nArray != null) {
                this.leadRow = nArray[this.leadIndex];
            } else if (this.leadPath != null) {
                this.tempPaths[0] = this.leadPath;
                nArray = this.rowMapper.getRowsForPaths(this.tempPaths);
                this.leadRow = nArray != null ? nArray[0] : -1;
            } else {
                this.leadRow = -1;
            }
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    @Override
    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
            int n2 = defaultListSelectionModel.getMinSelectionIndex();
            if (n2 != -1) {
                int n3 = defaultListSelectionModel.getMaxSelectionIndex();
                for (int i2 = n2; i2 <= n3; ++i2) {
                    if (defaultListSelectionModel.isSelectedIndex(i2)) continue;
                    if (i2 == n2) {
                        this.clearSelection();
                        continue;
                    }
                    TreePath[] treePathArray = new TreePath[i2 - n2];
                    int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        if (nArray[i3] >= i2) continue;
                        treePathArray[nArray[i3] - n2] = this.selection[i3];
                    }
                    this.setSelectionPaths(treePathArray);
                    break;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        int n2;
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int n3 = treePathArray.length;
        int n4 = 0;
        TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
        int n5 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        for (n2 = 0; n2 < n3; ++n2) {
            if (treePathArray[n2] == null) continue;
            treePathArray2[0] = treePathArray[n2];
            int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
            if (nArray == null) {
                return false;
            }
            int n6 = nArray[0];
            if (n6 == -1 || n6 < n5 - n3 || n6 > n5 + n3) {
                return false;
            }
            if (n6 < n5) {
                n5 = n6;
            }
            if (bitSet.get(n6)) continue;
            bitSet.set(n6);
            ++n4;
        }
        int n7 = n4 + n5;
        for (n2 = n5; n2 < n7; ++n2) {
            if (bitSet.get(n2)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        int n2;
        if (treePathArray == null || treePathArray.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
        int n3 = defaultListSelectionModel.getMinSelectionIndex();
        int n4 = defaultListSelectionModel.getMaxSelectionIndex();
        TreePath[] treePathArray2 = new TreePath[1];
        if (n3 != -1) {
            for (n2 = n3; n2 <= n4; ++n2) {
                if (!defaultListSelectionModel.isSelectedIndex(n2)) continue;
                bitSet.set(n2);
            }
        } else {
            treePathArray2[0] = treePathArray[0];
            n3 = n4 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        }
        for (n2 = treePathArray.length - 1; n2 >= 0; --n2) {
            if (treePathArray[n2] == null) continue;
            treePathArray2[0] = treePathArray[n2];
            int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
            if (nArray == null) {
                return false;
            }
            int n5 = nArray[0];
            n3 = Math.min(n5, n3);
            n4 = Math.max(n5, n4);
            if (n5 == -1) {
                return false;
            }
            bitSet.set(n5);
        }
        for (n2 = n3; n2 <= n4; ++n2) {
            if (bitSet.get(n2)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        int n2;
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n3 = treePathArray.length;
        int n4 = -1;
        int n5 = 0;
        TreePath[] treePathArray2 = new TreePath[1];
        this.lastPaths.clear();
        for (n2 = 0; n2 < n3; ++n2) {
            if (treePathArray[n2] == null) continue;
            this.lastPaths.put(treePathArray[n2], Boolean.TRUE);
        }
        for (n2 = this.selection.length - 1; n2 >= 0; --n2) {
            if (this.lastPaths.get(this.selection[n2]) != null) continue;
            treePathArray2[0] = this.selection[n2];
            int[] nArray = this.rowMapper.getRowsForPaths(treePathArray2);
            if (nArray == null || nArray[0] == -1 || bitSet.get(nArray[0])) continue;
            ++n5;
            n4 = n4 == -1 ? nArray[0] : Math.min(n4, nArray[0]);
            bitSet.set(nArray[0]);
        }
        this.lastPaths.clear();
        if (n5 > 1) {
            for (n2 = n4 + n5 - 1; n2 >= n4; --n2) {
                if (bitSet.get(n2)) continue;
                return false;
            }
        }
        return true;
    }

    protected void notifyPathChange(Vector<PathPlaceHolder> vector, TreePath treePath) {
        int n2 = vector.size();
        boolean[] blArray = new boolean[n2];
        TreePath[] treePathArray = new TreePath[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PathPlaceHolder pathPlaceHolder = vector.elementAt(i2);
            blArray[i2] = pathPlaceHolder.isNew;
            treePathArray[i2] = pathPlaceHolder.path;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
            } else {
                this.leadIndex = -1;
                this.leadRow = -1;
                for (int i2 = this.selection.length - 1; i2 >= 0; --i2) {
                    if (this.selection[i2] != this.leadPath) continue;
                    this.leadIndex = i2;
                    break;
                }
            }
        } else {
            this.leadIndex = -1;
        }
    }

    protected void insureUniqueness() {
    }

    public String toString() {
        int n2 = this.getSelectionCount();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        stringBuffer.append(this.getClass().getName() + " " + this.hashCode() + " [ ");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray != null) {
                stringBuffer.append(this.selection[i2].toString() + "@" + Integer.toString(nArray[i2]) + " ");
                continue;
            }
            stringBuffer.append(this.selection[i2].toString() + " ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.changeSupport = null;
        if (this.selection != null) {
            int n2 = this.selection.length;
            defaultTreeSelectionModel.selection = new TreePath[n2];
            System.arraycopy(this.selection, 0, defaultTreeSelectionModel.selection, 0, n2);
        }
        defaultTreeSelectionModel.listenerList = new EventListenerList();
        defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        defaultTreeSelectionModel.uniquePaths = new Hashtable();
        defaultTreeSelectionModel.lastPaths = new Hashtable();
        defaultTreeSelectionModel.tempPaths = new TreePath[1];
        return defaultTreeSelectionModel;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.rowMapper != null && this.rowMapper instanceof Serializable ? new Object[]{"rowMapper", this.rowMapper} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("rowMapper")) {
            this.rowMapper = (RowMapper)objectArray[1];
        }
    }
}

