/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.MouseEvent;
import java.awt.peer.ScrollPanePeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;

class XScrollPanePeer
extends XComponentPeer
implements ScrollPanePeer,
XScrollbarClient {
    public static final int MARGIN = 1;
    public static final int SCROLLBAR = 17;
    public static final int SPACE = 2;
    public static final int SCROLLBAR_INSET = 2;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private static Method m_setValue = XToolkit.getMethod(ScrollPaneAdjustable.class, "setTypedValue", new Class[]{Integer.TYPE, Integer.TYPE});
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    XWindow clip = null;
    int active = 1;
    int hsbSpace;
    int vsbSpace;
    int vval;
    int hval;
    int vmax;
    int hmax;

    XScrollPanePeer(ScrollPane scrollPane) {
        super(scrollPane);
        XScrollPaneContentWindow xScrollPaneContentWindow = new XScrollPaneContentWindow(scrollPane, this.window);
        this.clip = xScrollPaneContentWindow;
        this.vsb = new XVerticalScrollbar(this);
        this.hsb = new XHorizontalScrollbar(this);
        if (scrollPane.getScrollbarDisplayPolicy() == 1) {
            this.hsbSpace = 17;
            this.vsbSpace = 17;
        } else {
            this.hsbSpace = 0;
            this.vsbSpace = 0;
        }
        int n2 = 1;
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable != null) {
            n2 = adjustable.getUnitIncrement();
        }
        int n3 = this.height - this.hsbSpace;
        this.vsb.setValues(0, n3, 0, n3, n2, Math.max(1, (int)((double)n3 * 0.9)));
        this.vsb.setSize(this.vsbSpace - 2, n3);
        n2 = 1;
        Adjustable adjustable2 = scrollPane.getHAdjustable();
        if (adjustable2 != null) {
            n2 = adjustable2.getUnitIncrement();
        }
        int n4 = this.width - this.vsbSpace;
        this.hsb.setValues(0, n4, 0, n4, n2, Math.max(1, (int)((double)n4 * 0.9)));
        this.hsb.setSize(n4, this.hsbSpace - 2);
        this.setViewportSize();
        this.clip.xSetVisible(true);
    }

    public long getContentWindow() {
        return this.clip == null ? this.window : this.clip.getWindow();
    }

    public void setBounds(int n2, int n3, int n4, int n5, int n6) {
        super.setBounds(n2, n3, n4, n5, n6);
        if (this.clip == null) {
            return;
        }
        this.setScrollbarSpace();
        this.setViewportSize();
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1 + this.hsbSpace, 1 + this.vsbSpace);
    }

    public int getHScrollbarHeight() {
        return 17;
    }

    public int getVScrollbarWidth() {
        return 17;
    }

    public void childResized(int n2, int n3) {
        if (this.setScrollbarSpace()) {
            this.setViewportSize();
        }
        this.repaint();
    }

    Dimension getChildSize() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.countComponents() > 0) {
            Component component = scrollPane.getComponent(0);
            return component.size();
        }
        return new Dimension(0, 0);
    }

    boolean setScrollbarSpace() {
        int n2;
        int n3;
        ScrollPane scrollPane = (ScrollPane)this.target;
        boolean bl2 = false;
        int n4 = scrollPane.getScrollbarDisplayPolicy();
        if (n4 == 2) {
            return bl2;
        }
        Dimension dimension = this.getChildSize();
        if (n4 == 0) {
            n3 = this.hsbSpace;
            n2 = this.vsbSpace;
            this.hsbSpace = dimension.width <= this.width - 2 ? 0 : 17;
            int n5 = this.vsbSpace = dimension.height <= this.height - 2 ? 0 : 17;
            if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                int n6 = this.hsbSpace = dimension.width <= this.width - 17 - 2 ? 0 : 17;
            }
            if (this.vsbSpace == 0 && this.hsbSpace != 0) {
                int n7 = this.vsbSpace = dimension.height <= this.height - 17 - 2 ? 0 : 17;
            }
            if (n3 != this.hsbSpace || n2 != this.vsbSpace) {
                bl2 = true;
            }
        }
        if (this.vsbSpace > 0) {
            n3 = this.height - 2 - this.hsbSpace;
            n2 = Math.max(dimension.height, n3);
            this.vsb.setValues(this.vsb.getValue(), n3, 0, n2);
            this.vsb.setBlockIncrement((int)((double)this.vsb.getVisibleAmount() * 0.9));
            this.vsb.setSize(this.vsbSpace - 2, this.height - this.hsbSpace);
        }
        if (this.hsbSpace > 0) {
            n3 = this.width - 2 - this.vsbSpace;
            n2 = Math.max(dimension.width, n3);
            this.hsb.setValues(this.hsb.getValue(), n3, 0, n2);
            this.hsb.setBlockIncrement((int)((double)this.hsb.getVisibleAmount() * 0.9));
            this.hsb.setSize(this.width - this.vsbSpace, this.hsbSpace - 2);
        }
        n3 = 0;
        Point point = new Point(0, 0);
        if (((ScrollPane)this.target).getComponentCount() > 0) {
            point = ((ScrollPane)this.target).getComponent(0).location();
            if (this.vsbSpace == 0 && point.y < 0) {
                point.y = 0;
                n3 = 1;
            }
            if (this.hsbSpace == 0 && point.x < 0) {
                point.x = 0;
                n3 = 1;
            }
        }
        if (n3 != 0) {
            this.scroll(this.x, this.y, 3);
        }
        return bl2;
    }

    void setViewportSize() {
        this.clip.xSetBounds(1, 1, this.width - 2 - this.vsbSpace, this.height - 2 - this.hsbSpace);
    }

    public void setUnitIncrement(Adjustable adjustable, int n2) {
        if (adjustable.getOrientation() == 1) {
            this.vsb.setUnitIncrement(n2);
        } else {
            this.hsb.setUnitIncrement(n2);
        }
    }

    public void setValue(Adjustable adjustable, int n2) {
        if (adjustable.getOrientation() == 1) {
            this.scroll(-1, n2, 1);
        } else {
            this.scroll(n2, -1, 2);
        }
    }

    public void setScrollPosition(int n2, int n3) {
        this.scroll(n2, n3, 3);
    }

    void scroll(int n2, int n3, int n4) {
        this.scroll(n2, n3, n4, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scroll(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        Component component;
        XScrollPanePeer.checkSecurity();
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.countComponents() > 0) {
            component = scrollPane.getComponent(0);
            Color[] colorArray = this.getGUIcolors();
            if (scrollPane.getScrollbarDisplayPolicy() == 2) {
                n7 = -n2;
                n6 = -n3;
            } else {
                Graphics graphics;
                ScrollPaneAdjustable scrollPaneAdjustable;
                Point point = component.location();
                n7 = point.x;
                n6 = point.y;
                if ((n4 & 2) != 0) {
                    this.hsb.setValue(Math.min(n2, this.hsb.getMaximum() - this.hsb.getVisibleAmount()));
                    scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
                    this.setAdjustableValue(scrollPaneAdjustable, this.hsb.getValue(), n5);
                    n7 = -this.hsb.getValue();
                    graphics = this.getGraphics();
                    try {
                        this.paintHorScrollbar(graphics, colorArray, true);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
                if ((n4 & 1) != 0) {
                    this.vsb.setValue(Math.min(n3, this.vsb.getMaximum() - this.vsb.getVisibleAmount()));
                    scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
                    this.setAdjustableValue(scrollPaneAdjustable, this.vsb.getValue(), n5);
                    n6 = -this.vsb.getValue();
                    graphics = this.getGraphics();
                    try {
                        this.paintVerScrollbar(graphics, colorArray, true);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
        } else {
            throw new NullPointerException("scrollpane child is null");
        }
        component.move(n7, n6);
    }

    void setAdjustableValue(ScrollPaneAdjustable scrollPaneAdjustable, int n2, int n3) {
        try {
            m_setValue.invoke(scrollPaneAdjustable, new Integer(n2), new Integer(n3));
        }
        catch (IllegalAccessException illegalAccessException) {
            scrollPaneAdjustable.setValue(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scrollPaneAdjustable.setValue(n2);
        }
        catch (InvocationTargetException invocationTargetException) {
            scrollPaneAdjustable.setValue(n2);
            invocationTargetException.getCause().printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    void paintScrollBars(Graphics graphics, Color[] colorArray) {
        if (this.vsbSpace > 0) {
            this.paintVerScrollbar(graphics, colorArray, true);
        }
        if (this.hsbSpace > 0) {
            this.paintHorScrollbar(graphics, colorArray, true);
        }
    }

    void repaintScrollBars() {
        Graphics graphics = this.getGraphics();
        Color[] colorArray = this.getGUIcolors();
        if (graphics != null) {
            this.paintScrollBars(graphics, colorArray);
        }
        graphics.dispose();
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.getGraphics();
        Color[] colorArray = this.getGUIcolors();
        if (graphics != null) {
            if (xScrollbar == this.vsb) {
                this.paintVerScrollbar(graphics, colorArray, true);
            } else if (xScrollbar == this.hsb) {
                this.paintHorScrollbar(graphics, colorArray, true);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Color[] colorArray = this.getGUIcolors();
        graphics.setColor(colorArray[0]);
        int n2 = this.height - this.hsbSpace;
        int n3 = this.width - this.vsbSpace;
        graphics.fillRect(0, 0, n3, n2);
        graphics.fillRect(n3, n2, this.vsbSpace, this.hsbSpace);
        this.draw3DRect(graphics, colorArray, 0, 0, n3 - 1, n2 - 1, false);
        this.paintScrollBars(graphics, colorArray);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: 
            case 801: {
                this.repaintScrollBars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintHorScrollbar(Graphics graphics, Color[] colorArray, boolean bl2) {
        if (this.hsbSpace <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        int n2 = this.width - this.vsbSpace - 2;
        graphics.fillRect(1, this.height - 17, n2, 2);
        graphics.fillRect(0, this.height - 17, 1, 17);
        graphics.fillRect(1 + n2, this.height - 17, 1, 17);
        try {
            graphics2.translate(1, this.height - 15);
            this.hsb.paint(graphics2, colorArray, bl2);
        }
        finally {
            graphics2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintVerScrollbar(Graphics graphics, Color[] colorArray, boolean bl2) {
        if (this.vsbSpace <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        int n2 = this.height - this.hsbSpace - 2;
        graphics.fillRect(this.width - 17, 1, 2, n2);
        graphics.fillRect(this.width - 17, 0, 17, 1);
        graphics.fillRect(this.width - 17, 1 + n2, 17, 1);
        try {
            graphics2.translate(this.width - 15, 1);
            this.vsb.paint(graphics2, colorArray, bl2);
        }
        finally {
            graphics2.dispose();
        }
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n2 = mouseEvent.getModifiers();
        int n3 = mouseEvent.getID();
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        if ((n2 & 0x10) == 0) {
            return;
        }
        switch (n3) {
            case 501: {
                if (this.inVerticalScrollbar(n4, n5)) {
                    this.active = 1;
                    int n6 = this.height - this.hsbSpace - 2;
                    this.vsb.handleMouseEvent(n3, n2, n4 - (this.width - 17 + 2), n5 - 1);
                    break;
                }
                if (!this.inHorizontalScrollbar(n4, n5)) break;
                this.active = 2;
                int n7 = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(n3, n2, n4 - 1, n5 - (this.height - 17 + 2));
                break;
            }
            case 502: {
                if (this.active == 1) {
                    this.vsb.handleMouseEvent(n3, n2, n4, n5);
                    break;
                }
                if (this.active != 2) break;
                this.hsb.handleMouseEvent(n3, n2, n4, n5);
                break;
            }
            case 506: {
                if (this.active == 1) {
                    int n8 = this.height - 2 - this.hsbSpace;
                    this.vsb.handleMouseEvent(n3, n2, n4 - (this.width - 17 + 2), n5 - 1);
                    break;
                }
                if (this.active != 2) break;
                int n9 = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(n3, n2, n4 - 1, n5 - (this.height - 17 + 2));
            }
        }
    }

    public void notifyValue(XScrollbar xScrollbar, int n2, int n3, boolean bl2) {
        if (xScrollbar == this.vsb) {
            this.scroll(-1, n3, 1, n2);
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.scroll(n3, -1, 2, n2);
        }
    }

    boolean inVerticalScrollbar(int n2, int n3) {
        if (this.vsbSpace <= 0) {
            return false;
        }
        int n4 = this.height - 1 - this.hsbSpace;
        return n2 >= this.width - 15 && n2 < this.width && n3 >= 1 && n3 < n4;
    }

    boolean inHorizontalScrollbar(int n2, int n3) {
        if (this.hsbSpace <= 0) {
            return false;
        }
        int n4 = this.width - 1 - this.vsbSpace;
        return n2 >= 1 && n2 < n4 && n3 >= this.height - 15 && n3 < this.height;
    }

    private Component getScrollChild() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Component component = null;
        try {
            component = scrollPane.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Graphics graphics2;
        int n2;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.size();
        Color color = scrollPane.getBackground();
        Color color2 = scrollPane.getForeground();
        Point point = scrollPane.getScrollPosition();
        Component component = this.getScrollChild();
        Dimension dimension2 = component != null ? component.size() : new Dimension(0, 0);
        int n3 = scrollPane.getScrollbarDisplayPolicy();
        switch (n3) {
            case 2: {
                this.vsbSpace = 0;
                this.hsbSpace = 0;
                break;
            }
            case 1: {
                this.vsbSpace = 17;
                this.hsbSpace = 17;
                break;
            }
            case 0: {
                this.hsbSpace = dimension2.width <= dimension.width - 2 ? 0 : 17;
                int n4 = this.vsbSpace = dimension2.height <= dimension.height - 2 ? 0 : 17;
                if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                    int n5 = this.hsbSpace = dimension2.width <= dimension.width - 17 - 2 ? 0 : 17;
                }
                if (this.vsbSpace != 0 || this.hsbSpace == 0) break;
                this.vsbSpace = dimension2.height <= dimension.height - 17 - 2 ? 0 : 17;
            }
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (this.vsbSpace > 0) {
            n11 = 0;
            n13 = dimension.height - 2 - this.hsbSpace;
            n9 = Math.max(dimension2.height - n13, 0);
            n7 = point.y;
        }
        if (this.hsbSpace > 0) {
            n10 = 0;
            n12 = dimension.width - 2 - this.vsbSpace;
            n8 = Math.max(dimension2.width - n12, 0);
            n6 = point.x;
        }
        int n14 = dimension.width - this.vsbSpace;
        int n15 = dimension.height - this.hsbSpace;
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.hsbSpace > 0) {
            n2 = dimension.width - this.vsbSpace;
            graphics.fillRect(1, dimension.height - 17 - 3, n2 - 1, 14);
            graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 15);
                this.drawScrollbar(graphics2, color, 15, n2, n10, n8, n6, n12, true);
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.vsbSpace > 0) {
            n2 = dimension.height - this.hsbSpace;
            graphics.fillRect(dimension.width - 17 - 3, 1, 14, n2 - 1);
            graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 15, 0);
                this.drawScrollbar(graphics2, color, 15, n2, n11, n9, n7, n13, false);
            }
            finally {
                graphics2.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n14 - 1, n15 - 1, false);
        this.target.print(graphics);
        scrollPane.printComponents(graphics);
    }

    static class XScrollPaneContentWindow
    extends XWindow {
        XScrollPaneContentWindow(ScrollPane scrollPane, long l2) {
            super(scrollPane, l2);
        }

        public String getWMName() {
            return "ScrollPane content";
        }
    }
}

