/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XWINProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol {
    static final Logger log = Logger.getLogger("sun.awt.X11.XWINProtocol");
    XAtom XA_WIN_SUPPORTING_WM_CHECK = XAtom.get("_WIN_SUPPORTING_WM_CHECK");
    XAtom XA_WIN_PROTOCOLS = XAtom.get("_WIN_PROTOCOLS");
    XAtom XA_WIN_STATE = XAtom.get("_WIN_STATE");
    XAtom XA_WIN_LAYER = XAtom.get("_WIN_LAYER");
    static final int WIN_STATE_STICKY = 1;
    static final int WIN_STATE_MINIMIZED = 2;
    static final int WIN_STATE_MAXIMIZED_VERT = 4;
    static final int WIN_STATE_MAXIMIZED_HORIZ = 8;
    static final int WIN_STATE_HIDDEN = 16;
    static final int WIN_STATE_SHADED = 32;
    static final int WIN_LAYER_ONTOP = 6;
    static final int WIN_LAYER_NORMAL = 4;
    long WinWindow = 0L;
    boolean supportChecked = false;

    XWINProtocol() {
    }

    public boolean supportsState(int n2) {
        return this.doStateProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(XWindowPeer xWindowPeer, int n2) {
        if (xWindowPeer.isShowing()) {
            long l2 = 0L;
            if ((n2 & 4) != 0) {
                l2 |= 4L;
            }
            if ((n2 & 2) != 0) {
                l2 |= 8L;
            }
            XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindowPeer.getWindow());
            xClientMessageEvent.set_message_type(this.XA_WIN_STATE.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, 12L);
            xClientMessageEvent.set_data(1, l2);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Sending WIN_STATE to root to change the state to " + l2);
            }
            try {
                XToolkit.awtLock();
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 0x180000L, xClientMessageEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            xClientMessageEvent.dispose();
        } else {
            long l3;
            long l4 = l3 = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
            l3 = (n2 & 1) != 0 ? (l3 |= 2L) : (l3 &= 0xFFFFFFFFFFFFFFFDL);
            l3 = (n2 & 4) != 0 ? (l3 |= 4L) : (l3 &= 0xFFFFFFFFFFFFFFFBL);
            l3 = (n2 & 2) != 0 ? (l3 |= 8L) : (l3 &= 0xFFFFFFFFFFFFFFF7L);
            if ((l4 ^ l3) != 0L) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Setting WIN_STATE on " + xWindowPeer + " to change the state to " + l3);
                }
                this.XA_WIN_STATE.setCard32Property(xWindowPeer, l3);
            }
        }
    }

    public int getState(XWindowPeer xWindowPeer) {
        long l2 = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
        int n2 = 0;
        if ((l2 & 4L) != 0L) {
            n2 |= 4;
        }
        if ((l2 & 8L) != 0L) {
            n2 |= 2;
        }
        return n2;
    }

    public boolean isStateChange(XPropertyEvent xPropertyEvent) {
        return this.doStateProtocol() && xPropertyEvent.get_atom() == this.XA_WIN_STATE.getAtom();
    }

    public void unshadeKludge(XWindowPeer xWindowPeer) {
        long l2 = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
        if ((l2 & 0x20L) == 0L) {
            return;
        }
        this.XA_WIN_STATE.setCard32Property(xWindowPeer, l2 &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean supportsLayer(int n2) {
        return (n2 == 1 || n2 == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayer(XWindowPeer xWindowPeer, int n2) {
        if (xWindowPeer.isShowing()) {
            XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindowPeer.getWindow());
            xClientMessageEvent.set_message_type(this.XA_WIN_LAYER.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, n2 == 0 ? 4L : 6L);
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, 0L);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting layer " + n2 + " by root message : " + xClientMessageEvent);
            }
            try {
                XToolkit.awtLock();
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 524288L, xClientMessageEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            xClientMessageEvent.dispose();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting layer property to " + n2);
            }
            this.XA_WIN_LAYER.setCard32Property(xWindowPeer, n2 == 0 ? 4L : 6L);
        }
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.WinWindow = this.checkAnchor(this.XA_WIN_SUPPORTING_WM_CHECK, 6L);
        this.supportChecked = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " is active: " + (this.WinWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.WinWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean bl2;
        boolean bl3 = bl2 = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_STATE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " supports state: " + bl2);
        }
        return bl2;
    }

    boolean doLayerProtocol() {
        boolean bl2;
        boolean bl3 = bl2 = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_LAYER);
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " supports layer: " + bl2);
        }
        return bl2;
    }
}

