/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.Rectangle2D;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

final class Order1
extends Curve {
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;

    public Order1(double d2, double d3, double d4, double d5, int n2) {
        super(n2);
        this.x0 = d2;
        this.y0 = d3;
        this.x1 = d4;
        this.y1 = d5;
        if (d2 < d4) {
            this.xmin = d2;
            this.xmax = d4;
        } else {
            this.xmin = d4;
            this.xmax = d2;
        }
    }

    public int getOrder() {
        return 1;
    }

    public double getXTop() {
        return this.x0;
    }

    public double getYTop() {
        return this.y0;
    }

    public double getXBot() {
        return this.x1;
    }

    public double getYBot() {
        return this.y1;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public double XforY(double d2) {
        if (this.x0 == this.x1 || d2 == this.y0) {
            return this.x0;
        }
        if (d2 == this.y1) {
            return this.x1;
        }
        return this.x0 + (d2 - this.y0) * (this.x1 - this.x0) / (this.y1 - this.y0);
    }

    public double TforY(double d2) {
        return (d2 - this.y0) / (this.y1 - this.y0);
    }

    public double XforT(double d2) {
        return this.x0 + d2 * (this.x1 - this.x0);
    }

    public double YforT(double d2) {
        return this.y0 + d2 * (this.y1 - this.y0);
    }

    public double dXforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return this.x0 + d2 * (this.x1 - this.x0);
            }
            case 1: {
                return this.x1 - this.x0;
            }
        }
        return 0.0;
    }

    public double dYforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return this.y0 + d2 * (this.y1 - this.y0);
            }
            case 1: {
                return this.y1 - this.y0;
            }
        }
        return 0.0;
    }

    public double nextVertical(double d2, double d3) {
        return d3;
    }

    public boolean accumulateCrossings(Crossings crossings) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = crossings.getXLo();
        double d7 = crossings.getYLo();
        double d8 = crossings.getXHi();
        double d9 = crossings.getYHi();
        if (this.xmin >= d8) {
            return false;
        }
        if (this.y0 < d7) {
            if (this.y1 <= d7) {
                return false;
            }
            d5 = d7;
            d4 = this.XforY(d7);
        } else {
            if (this.y0 >= d9) {
                return false;
            }
            d5 = this.y0;
            d4 = this.x0;
        }
        if (this.y1 > d9) {
            d3 = d9;
            d2 = this.XforY(d9);
        } else {
            d3 = this.y1;
            d2 = this.x1;
        }
        if (d4 >= d8 && d2 >= d8) {
            return false;
        }
        if (d4 > d6 || d2 > d6) {
            return true;
        }
        crossings.record(d5, d3, this.direction);
        return false;
    }

    public void enlarge(Rectangle2D rectangle2D) {
        rectangle2D.add(this.x0, this.y0);
        rectangle2D.add(this.x1, this.y1);
    }

    public Curve getSubCurve(double d2, double d3, int n2) {
        if (d2 == this.y0 && d3 == this.y1) {
            return this.getWithDirection(n2);
        }
        if (this.x0 == this.x1) {
            return new Order1(this.x0, d2, this.x1, d3, n2);
        }
        double d4 = this.x0 - this.x1;
        double d5 = this.y0 - this.y1;
        double d6 = this.x0 + (d2 - this.y0) * d4 / d5;
        double d7 = this.x0 + (d3 - this.y0) * d4 / d5;
        return new Order1(d6, d2, d7, d3, n2);
    }

    public Curve getReversedCurve() {
        return new Order1(this.x0, this.y0, this.x1, this.y1, -this.direction);
    }

    public int compareTo(Curve curve, double[] dArray) {
        double d2;
        if (!(curve instanceof Order1)) {
            return super.compareTo(curve, dArray);
        }
        Order1 order1 = (Order1)curve;
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("yrange already screwed up...");
        }
        dArray[1] = Math.min(Math.min(dArray[1], this.y1), order1.y1);
        if (dArray[1] <= dArray[0]) {
            throw new InternalError("backstepping from " + dArray[0] + " to " + dArray[1]);
        }
        if (this.xmax <= order1.xmin) {
            return this.xmin == order1.xmax ? 0 : -1;
        }
        if (this.xmin >= order1.xmax) {
            return 1;
        }
        double d3 = order1.x1 - order1.x0;
        double d4 = this.y1 - this.y0;
        double d5 = this.x1 - this.x0;
        double d6 = order1.y1 - order1.y0;
        double d7 = d3 * d4 - d5 * d6;
        if (d7 != 0.0) {
            double d8 = (this.x0 - order1.x0) * d4 * d6 - this.y0 * d5 * d6 + order1.y0 * d3 * d4;
            d2 = d8 / d7;
            if (d2 <= dArray[0]) {
                d2 = Math.min(this.y1, order1.y1);
            } else {
                if (d2 < dArray[1]) {
                    dArray[1] = d2;
                }
                d2 = Math.max(this.y0, order1.y0);
            }
        } else {
            d2 = Math.max(this.y0, order1.y0);
        }
        return Order1.orderof(this.XforY(d2), order1.XforY(d2));
    }

    public int getSegment(double[] dArray) {
        if (this.direction == 1) {
            dArray[0] = this.x1;
            dArray[1] = this.y1;
        } else {
            dArray[0] = this.x0;
            dArray[1] = this.y0;
        }
        return 1;
    }
}

