/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.DisposerTarget;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.GLXSurfaceData;

public class X11CachingSurfaceManager
extends CachingSurfaceManager
implements DisposerTarget {
    private Hashtable bitmasks;
    private boolean isBitmask;
    private int transparency;
    private Object disposerReferent = new Object();

    public X11CachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        ColorModel colorModel = bufferedImage.getColorModel();
        this.transparency = colorModel.getTransparency();
        boolean bl2 = this.isBitmask = this.transparency == 2;
        if (this.isBitmask && colorModel instanceof IndexColorModel && colorModel.getPixelSize() < 8) {
            this.localAccelerationEnabled = false;
        }
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof GLXSurfaceData || surfaceData instanceof X11SurfaceData && X11SurfaceData.isAccelerationEnabled();
    }

    protected SurfaceData getAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.accelSurfaces != null ? (SurfaceData)this.accelSurfaces.get(graphicsConfiguration) : null;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl2) {
        if (surfaceData instanceof GLXSurfaceData) {
            return color == null || this.transparency == 1;
        }
        if (this.transparency == 3) {
            return false;
        }
        if (color != null && color.getTransparency() != 1) {
            return false;
        }
        return !bl2 && (!this.isBitmask ? CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) : CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType) && color != null);
    }

    protected void initAcceleratedSurface(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        try {
            this.sdAccel = (SurfaceData)this.accelSurfaces.get(graphicsConfiguration);
            if (this.sdAccel == null) {
                this.sdAccel = graphicsConfiguration instanceof GLXGraphicsConfig ? this.createGLXSurface(graphicsConfiguration, n2, n3) : this.createX11Surface(graphicsConfiguration, n2, n3);
                if (this.sdAccel != null) {
                    this.accelSurfaces.put(graphicsConfiguration, this.sdAccel);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.sdAccel = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.sdAccel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SurfaceData createX11Surface(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        int n4 = 0;
        if (this.isBitmask) {
            Integer n5;
            if (this.bitmasks == null) {
                this.bitmasks = new Hashtable();
            }
            if ((n5 = (Integer)this.bitmasks.get(graphicsConfiguration.getDevice())) == null) {
                int n6 = ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen();
                n4 = this.updateBitmask(this.sdDefault, 0, n6, n2, n3);
                if (n4 != 0) {
                    Hashtable hashtable = this.bitmasks;
                    synchronized (hashtable) {
                        this.bitmasks.put(graphicsConfiguration.getDevice(), new Integer(n4));
                    }
                }
            } else {
                n4 = n5;
            }
        }
        return X11SurfaceData.createData((X11GraphicsConfig)graphicsConfiguration, n2, n3, graphicsConfiguration.getColorModel(), this.bImg, 0L, n4);
    }

    protected SurfaceData createGLXSurface(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        return GLXSurfaceData.createData((GLXGraphicsConfig)graphicsConfiguration, n2, n3, graphicsConfiguration.getColorModel(), this.bImg, 4);
    }

    protected void copyDefaultToAccelerated() {
        boolean bl2 = this.sdDefault.needsBackup();
        super.copyDefaultToAccelerated();
        if (this.isBitmask && bl2 && this.sdAccel != null && this.bitmasks != null) {
            this.updateBitmasks();
        }
    }

    private native int updateBitmask(SurfaceData var1, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBitmasks() {
        int n2 = this.bImg.getWidth();
        int n3 = this.bImg.getHeight();
        Hashtable hashtable = this.bitmasks;
        synchronized (hashtable) {
            Enumeration enumeration = this.bitmasks.keys();
            while (enumeration.hasMoreElements()) {
                X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)enumeration.nextElement();
                int n4 = (Integer)this.bitmasks.get(x11GraphicsDevice);
                this.updateBitmask(this.sdDefault, n4, x11GraphicsDevice.getScreen(), n2, n3);
            }
        }
    }

    public Object getDisposerReferent() {
        return this.disposerReferent;
    }
}

