/*
 * Decompiled with CFR 0.152.
 */
package sun.corba;

import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import sun.corba.BridgePermission;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public final class Bridge {
    private static final Class[] NO_ARGS = new Class[0];
    private static final Permission getBridgePermission = new BridgePermission("getBridge");
    private static Bridge bridge = null;
    private final Method latestUserDefinedLoaderMethod = this.getLatestUserDefinedLoaderMethod();
    private final Unsafe unsafe = this.getUnsafe();
    private final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    public static final long INVALID_FIELD_OFFSET = -1L;

    private Method getLatestUserDefinedLoaderMethod() {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    Class<ObjectInputStream> clazz = ObjectInputStream.class;
                    method = clazz.getDeclaredMethod("latestUserDefinedLoader", NO_ARGS);
                    method.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Error error = new Error("java.io.ObjectInputStream latestUserDefinedLoader " + noSuchMethodException);
                    error.initCause(noSuchMethodException);
                    throw error;
                }
                return method;
            }
        });
    }

    private Unsafe getUnsafe() {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field field = null;
                try {
                    Class<Unsafe> clazz = Unsafe.class;
                    field = clazz.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Error error = new Error("Could not access Unsafe");
                    error.initCause(noSuchFieldException);
                    throw error;
                }
            }
        });
        Unsafe unsafe = null;
        try {
            unsafe = (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {
            Error error = new Error("Could not access Unsafe");
            error.initCause(throwable);
            throw error;
        }
        return unsafe;
    }

    private Bridge() {
    }

    public static final synchronized Bridge get() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(getBridgePermission);
        }
        if (bridge == null) {
            bridge = new Bridge();
        }
        return bridge;
    }

    public final ClassLoader getLatestUserDefinedLoader() {
        try {
            return (ClassLoader)this.latestUserDefinedLoaderMethod.invoke(null, NO_ARGS);
        }
        catch (InvocationTargetException invocationTargetException) {
            Error error = new Error("sun.corba.Bridge.latestUserDefinedLoader: " + invocationTargetException);
            error.initCause(invocationTargetException);
            throw error;
        }
        catch (IllegalAccessException illegalAccessException) {
            Error error = new Error("sun.corba.Bridge.latestUserDefinedLoader: " + illegalAccessException);
            error.initCause(illegalAccessException);
            throw error;
        }
    }

    public final int getInt(Object object, long l2) {
        return this.unsafe.getInt(object, l2);
    }

    public final void putInt(Object object, long l2, int n2) {
        this.unsafe.putInt(object, l2, n2);
    }

    public final Object getObject(Object object, long l2) {
        return this.unsafe.getObject(object, l2);
    }

    public final void putObject(Object object, long l2, Object object2) {
        this.unsafe.putObject(object, l2, object2);
    }

    public final boolean getBoolean(Object object, long l2) {
        return this.unsafe.getBoolean(object, l2);
    }

    public final void putBoolean(Object object, long l2, boolean bl2) {
        this.unsafe.putBoolean(object, l2, bl2);
    }

    public final byte getByte(Object object, long l2) {
        return this.unsafe.getByte(object, l2);
    }

    public final void putByte(Object object, long l2, byte by) {
        this.unsafe.putByte(object, l2, by);
    }

    public final short getShort(Object object, long l2) {
        return this.unsafe.getShort(object, l2);
    }

    public final void putShort(Object object, long l2, short s2) {
        this.unsafe.putShort(object, l2, s2);
    }

    public final char getChar(Object object, long l2) {
        return this.unsafe.getChar(object, l2);
    }

    public final void putChar(Object object, long l2, char c2) {
        this.unsafe.putChar(object, l2, c2);
    }

    public final long getLong(Object object, long l2) {
        return this.unsafe.getLong(object, l2);
    }

    public final void putLong(Object object, long l2, long l3) {
        this.unsafe.putLong(object, l2, l3);
    }

    public final float getFloat(Object object, long l2) {
        return this.unsafe.getFloat(object, l2);
    }

    public final void putFloat(Object object, long l2, float f2) {
        this.unsafe.putFloat(object, l2, f2);
    }

    public final double getDouble(Object object, long l2) {
        return this.unsafe.getDouble(object, l2);
    }

    public final void putDouble(Object object, long l2, double d2) {
        this.unsafe.putDouble(object, l2, d2);
    }

    public final long objectFieldOffset(Field field) {
        return this.unsafe.objectFieldOffset(field);
    }

    public final void throwException(Throwable throwable) {
        this.unsafe.throwException(throwable);
    }

    public final Constructor newConstructorForSerialization(Class clazz, Constructor constructor) {
        return this.reflectionFactory.newConstructorForSerialization(clazz, constructor);
    }
}

