/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.GradientPaint;
import java.awt.GraphicsEnvironment;
import java.awt.TexturePaint;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLBlitLoops;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLDrawImage;
import sun.java2d.opengl.OGLMaskBlit;
import sun.java2d.opengl.OGLMaskFill;
import sun.java2d.opengl.OGLRenderer;
import sun.java2d.opengl.OGLTextRenderer;
import sun.java2d.pipe.PixelToShapeConverter;

public abstract class OGLSurfaceData
extends SurfaceData {
    public static final int UNDEFINED = 0;
    public static final int WINDOW = 1;
    public static final int PIXMAP = 2;
    public static final int PBUFFER = 3;
    public static final int TEXTURE = 4;
    public static final int VOL_BACKBUFFER = 5;
    public static final int FLIP_BACKBUFFER = 6;
    public static final int PF_INT_ARGB = 0;
    public static final int PF_INT_RGB = 1;
    public static final int PF_INT_RGBX = 2;
    public static final int PF_INT_BGR = 3;
    public static final int PF_INT_BGRX = 4;
    public static final int PF_3BYTE_BGR = 5;
    public static final int PF_4BYTE_ABGR = 6;
    public static final int PF_USHORT_565_RGB = 7;
    public static final int PF_USHORT_555_RGB = 8;
    public static final int PF_USHORT_555_RGBX = 9;
    public static final int PF_BYTE_GRAY = 10;
    public static final int PF_USHORT_GRAY = 11;
    public static final int PF_BYTE_INDEXED = 12;
    public static final int PF_INDEX_8_GRAY = 13;
    public static final int PF_INDEX_12_GRAY = 14;
    public static final int PF_INT_ARGB_PRE = 15;
    public static final int PF_4BYTE_ABGR_PRE = 16;
    private static final String DESC_OPENGL_SURFACE = "OpenGL Surface";
    private static final String DESC_OPENGL_SURFACE_RTT = "OpenGL Surface (render-to-texture)";
    private static final String DESC_OPENGL_TEXTURE = "OpenGL Texture";
    public static final SurfaceType OpenGLSurface = SurfaceType.Any.deriveSubType("OpenGL Surface", PixelConverter.ArgbPre.instance);
    public static final SurfaceType OpenGLSurfaceRTT = OpenGLSurface.deriveSubType("OpenGL Surface (render-to-texture)");
    public static final SurfaceType OpenGLTexture = SurfaceType.Any.deriveSubType("OpenGL Texture");
    protected RenderLoops solidloops;
    protected int type;
    protected int depth;
    protected static OGLRenderer oglSolidPipe;
    protected static OGLRenderer oglGradientPipe;
    protected static OGLRenderer oglTexturePipe;
    protected static PixelToShapeConverter oglTxSolidPipe;
    protected static PixelToShapeConverter oglTxGradientPipe;
    protected static PixelToShapeConverter oglTxTexturePipe;
    protected static OGLTextRenderer oglTextPipe;
    protected static OGLDrawImage oglImagePipe;

    private native void flush(long var1);

    protected native boolean initTexture(long var1, long var3, int var5, int var6);

    protected native boolean initFlipBackbuffer(long var1);

    protected native boolean initVolatileBackbuffer(long var1, int var3, int var4);

    public abstract boolean initWindow();

    protected abstract boolean initPbuffer(long var1, long var3, int var5, int var6);

    protected abstract boolean initPixmap(long var1, long var3, int var5, int var6, int var7);

    protected OGLSurfaceData(SurfaceType surfaceType, ColorModel colorModel, int n2) {
        super(surfaceType, colorModel);
        this.depth = colorModel.getPixelSize();
        this.type = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSurface(int n2, int n3, int n4) {
        boolean bl2 = false;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            long l2 = this.getNativeOps();
            switch (this.type) {
                case 2: {
                    long l3 = this.getContext().getNativeContext();
                    bl2 = this.initPixmap(l3, l2, n2, n3, n4);
                    break;
                }
                case 3: {
                    long l4 = this.getContext().getNativeContext();
                    bl2 = this.initPbuffer(l4, l2, n2, n3);
                    break;
                }
                case 4: {
                    long l5 = OGLContext.getSharedContext(this);
                    bl2 = this.initTexture(l5, l2, n2, n3);
                    break;
                }
                case 5: {
                    if (!this.initWindow()) break;
                    bl2 = this.initVolatileBackbuffer(l2, n2, n3);
                    break;
                }
                case 6: {
                    if (!this.initWindow()) break;
                    bl2 = this.initFlipBackbuffer(l2);
                    break;
                }
            }
        }
        if (!bl2) {
            throw new OutOfMemoryError("can't create offscreen surface");
        }
    }

    public abstract OGLContext getContext();

    public abstract long getSharedContext();

    public int getType() {
        return this.type;
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        throw new InternalError("not implemented yet");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void validatePipe(SunGraphics2D var1_1) {
        block18: {
            block16: {
                block17: {
                    if (var1_1.compositeState > 2) break block16;
                    var3_2 = false;
                    if (var1_1.compositeState != 0) break block17;
                    if (var1_1.paintState == 0) ** GOTO lbl-1000
                }
                if (var1_1.compositeState == 1) {
                    ** if (var1_1.paintState > 1 || ((AlphaComposite)var1_1.composite).getRule() != 3) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    var2_3 /* !! */  = OGLSurfaceData.oglTextPipe;
                    ** GOTO lbl19
                }
lbl-1000:
                // 2 sources

                {
                    super.validatePipe(var1_1);
                    var2_3 /* !! */  = var1_1.textpipe;
                    var3_2 = true;
                }
lbl19:
                // 2 sources

                var4_4 = null;
                var5_5 = null;
                if (var1_1.antialiasHint != 2) {
                    if (var1_1.paintState <= 1) {
                        var4_4 = OGLSurfaceData.oglTxSolidPipe;
                        var5_5 = OGLSurfaceData.oglSolidPipe;
                    } else {
                        var6_6 = var1_1.paint.getClass();
                        if (var6_6 == GradientPaint.class) {
                            var4_4 = OGLSurfaceData.oglTxGradientPipe;
                            var5_5 = OGLSurfaceData.oglGradientPipe;
                        } else if (var6_6 == TexturePaint.class && OGLRenderer.Texture.isPaintValid(var1_1, var7_7 = (TexturePaint)var1_1.paint)) {
                            var4_4 = OGLSurfaceData.oglTxTexturePipe;
                            var5_5 = OGLSurfaceData.oglTexturePipe;
                        }
                    }
                }
                if (var4_4 != null) {
                    if (var1_1.transformState >= 3) {
                        var1_1.drawpipe = var4_4;
                        var1_1.fillpipe = var4_4;
                    } else if (var1_1.strokeState != 0) {
                        var1_1.drawpipe = var4_4;
                        var1_1.fillpipe = var5_5;
                    } else {
                        var1_1.drawpipe = var5_5;
                        var1_1.fillpipe = var5_5;
                    }
                    var1_1.shapepipe = var5_5;
                } else if (!var3_2) {
                    super.validatePipe(var1_1);
                }
                var1_1.textpipe = var2_3 /* !! */ ;
                break block18;
            }
            super.validatePipe(var1_1);
        }
        var1_1.imagepipe = OGLSurfaceData.oglImagePipe;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 3) {
            if (sunGraphics2D.compositeState < 2) {
                int n8 = (n2 += sunGraphics2D.transX) + n6;
                int n9 = (n3 += sunGraphics2D.transY) + n7;
                int n10 = n8 + n4;
                int n11 = n9 + n5;
                if (n8 < n10 && n9 < n11) {
                    Object object = OGLContext.LOCK;
                    synchronized (object) {
                        int n12 = 6;
                        long l2 = OGLContext.getContext(this, this, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, sunGraphics2D.pixel, n12);
                        oglSolidPipe.devCopyArea(l2, this.getNativeOps(), n8 - n6, n9 - n7, n8, n9, n10 - n8, n11 - n9);
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = OGLContext.LOCK;
        synchronized (object) {
            OGLContext.getSharedContext(this);
            this.flush(this.getNativeOps());
        }
    }

    public abstract boolean isBlendPremultAvailable();

    public abstract boolean isTexNonPow2Available();

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            oglSolidPipe = new OGLRenderer.Solid();
            oglGradientPipe = new OGLRenderer.Gradient();
            oglTexturePipe = new OGLRenderer.Texture();
            oglTextPipe = new OGLTextRenderer();
            if (GraphicsPrimitive.tracingEnabled()) {
                oglSolidPipe = oglSolidPipe.traceWrap();
                oglGradientPipe = oglGradientPipe.traceWrap();
                oglTexturePipe = oglTexturePipe.traceWrap();
                oglTextPipe = oglTextPipe.traceWrap();
            }
            oglTxSolidPipe = new PixelToShapeConverter(oglSolidPipe);
            oglTxGradientPipe = new PixelToShapeConverter(oglGradientPipe);
            oglTxTexturePipe = new PixelToShapeConverter(oglTexturePipe);
            oglImagePipe = new OGLDrawImage();
            OGLBlitLoops.register();
            OGLMaskFill.register();
            OGLMaskBlit.register();
        }
    }
}

