/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;

public class ChannelInputStream
extends InputStream {
    protected final ReadableByteChannel ch;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (readableByteChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)readableByteChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                boolean bl3 = selectableChannel.isBlocking();
                if (!bl3) {
                    throw new IllegalBlockingModeException();
                }
                if (bl3 != bl2) {
                    selectableChannel.configureBlocking(bl2);
                }
                int n2 = readableByteChannel.read(byteBuffer);
                if (bl3 != bl2) {
                    selectableChannel.configureBlocking(bl3);
                }
                return n2;
            }
        }
        return readableByteChannel.read(byteBuffer);
    }

    public ChannelInputStream(ReadableByteChannel readableByteChannel) {
        this.ch = readableByteChannel;
    }

    public synchronized int read() throws IOException {
        int n2;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n2 = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
        byteBuffer.position(n2);
        byteBuffer.limit(Math.min(n2 + n3, byteBuffer.capacity()));
        this.bb = byteBuffer;
        this.bs = byArray;
        return this.read(byteBuffer);
    }

    protected int read(ByteBuffer byteBuffer) throws IOException {
        return ChannelInputStream.read(this.ch, byteBuffer, true);
    }

    public void close() throws IOException {
        this.ch.close();
    }
}

