/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class SingleByteDecoder
extends CharsetDecoder {
    private final String byteToCharTable;

    protected SingleByteDecoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        this.byteToCharTable = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n2 <= n3);
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.arrayOffset() + charBuffer.position();
        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n4 <= n5);
        n4 = n4 <= n5 ? n4 : n5;
        try {
            for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                byte by = byArray[n2];
                char c2 = this.decode(by);
                if (c2 == '\ufffd') {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                if (n5 - n4 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n4++] = c2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n4 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n2 = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                char c2 = this.decode(by);
                if (c2 == '\ufffd') {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n2;
                charBuffer.put(c2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n2);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }

    public char decode(int n2) {
        int n3 = n2 + 128;
        if (n3 >= this.byteToCharTable.length() || n3 < 0) {
            return '\ufffd';
        }
        return this.byteToCharTable.charAt(n3);
    }
}

