/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.IOException;
import java.io.InputStream;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream inputStream, int n2) throws IOException {
        this.in = inputStream;
        this.length = n2;
    }

    public int read() throws IOException {
        if (this.length == 0) {
            return -1;
        }
        int n2 = this.in.read();
        this.length = n2 != -1 ? this.length - 1 : 0;
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.length == 0) {
            return -1;
        }
        n3 = this.length < n3 ? this.length : n3;
        int n4 = this.in.read(byArray, n2, n3);
        this.length = n4 != -1 ? this.length - n4 : 0;
        return n4;
    }

    public long skip(long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes to skip - " + l2);
        }
        if (this.length == 0) {
            return 0L;
        }
        l2 = (long)this.length < l2 ? (long)this.length : l2;
        l2 = this.in.skip(l2);
        this.length = (int)((long)this.length - l2);
        return l2;
    }

    public int available() throws IOException {
        int n2 = this.in.available();
        return this.length < n2 ? this.length : n2;
    }

    public void close() {
        this.length = 0;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

