/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.Operation;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.server.Util;

public class ActivatableRef
implements RemoteRef {
    private static final long serialVersionUID = 7579060052569229166L;
    protected ActivationID id;
    protected RemoteRef ref;
    transient boolean force = false;
    private static final int MAX_RETRIES = 3;
    private static final String versionComplaint = "activation requires 1.2 stubs";

    public ActivatableRef() {
    }

    public ActivatableRef(ActivationID activationID, RemoteRef remoteRef) {
        this.id = activationID;
        this.ref = remoteRef;
    }

    public static Remote getStub(ActivationDesc activationDesc, ActivationID activationID) throws StubNotFoundException {
        String string = activationDesc.getClassName();
        try {
            Class<?> clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
            ActivatableRef activatableRef = new ActivatableRef(activationID, null);
            return Util.createProxy(clazz, activatableRef, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StubNotFoundException("class implements an illegal remote interface", illegalArgumentException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("unable to load class: " + string, classNotFoundException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new StubNotFoundException("malformed URL", malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Remote remote, Method method, Object[] objectArray, long l2) throws Exception {
        RemoteRef remoteRef;
        boolean bl2 = false;
        RemoteException remoteException = null;
        ActivatableRef activatableRef = this;
        synchronized (activatableRef) {
            if (this.ref == null) {
                remoteRef = this.activate(bl2);
                bl2 = true;
            } else {
                remoteRef = this.ref;
            }
        }
        for (int i2 = 3; i2 > 0; --i2) {
            RemoteRef remoteRef2;
            try {
                return remoteRef.invoke(remote, method, objectArray, l2);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                remoteException = noSuchObjectException;
            }
            catch (ConnectException connectException) {
                remoteException = connectException;
            }
            catch (UnknownHostException unknownHostException) {
                remoteException = unknownHostException;
            }
            catch (ConnectIOException connectIOException) {
                remoteException = connectIOException;
            }
            catch (MarshalException marshalException) {
                throw marshalException;
            }
            catch (ServerError serverError) {
                throw serverError;
            }
            catch (ServerException serverException) {
                throw serverException;
            }
            catch (RemoteException remoteException2) {
                remoteRef2 = this;
                synchronized (remoteRef2) {
                    if (remoteRef == this.ref) {
                        this.ref = null;
                    }
                }
                throw remoteException2;
            }
            if (i2 <= 1) continue;
            ActivatableRef activatableRef2 = this;
            synchronized (activatableRef2) {
                if (remoteRef.remoteEquals(this.ref) || this.ref == null) {
                    remoteRef2 = this.activate(bl2);
                    if (remoteRef2.remoteEquals(remoteRef) && remoteException instanceof NoSuchObjectException && !bl2) {
                        remoteRef2 = this.activate(true);
                    }
                    remoteRef = remoteRef2;
                    bl2 = true;
                } else {
                    remoteRef = this.ref;
                    bl2 = false;
                }
                continue;
            }
        }
        throw remoteException;
    }

    private synchronized RemoteRef getRef() throws RemoteException {
        if (this.ref == null) {
            this.ref = this.activate(false);
        }
        return this.ref;
    }

    private RemoteRef activate(boolean bl2) throws RemoteException {
        assert (Thread.holdsLock(this));
        this.ref = null;
        try {
            Remote remote = this.id.activate(bl2);
            ActivatableRef activatableRef = null;
            if (remote instanceof RemoteStub) {
                activatableRef = (ActivatableRef)((RemoteStub)remote).getRef();
            } else {
                RemoteObjectInvocationHandler remoteObjectInvocationHandler = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(remote);
                activatableRef = (ActivatableRef)remoteObjectInvocationHandler.getRef();
            }
            this.ref = activatableRef.ref;
            return this.ref;
        }
        catch (ConnectException connectException) {
            throw new ConnectException("activation failed", connectException);
        }
        catch (RemoteException remoteException) {
            throw new ConnectIOException("activation failed", remoteException);
        }
        catch (UnknownObjectException unknownObjectException) {
            throw new NoSuchObjectException("object not registered");
        }
        catch (ActivationException activationException) {
            throw new ActivateFailedException("activation failed", activationException);
        }
    }

    public synchronized RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n2, long l2) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "ActivatableRef";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        RemoteRef remoteRef = this.ref;
        objectOutput.writeObject(this.id);
        if (remoteRef == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(remoteRef.getRefClass(objectOutput));
            remoteRef.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ActivationID)objectInput.readObject();
        this.ref = null;
        String string = objectInput.readUTF();
        if (string.equals("")) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("sun.rmi.server." + string);
            this.ref = (RemoteRef)clazz.newInstance();
            this.ref.readExternal(objectInput);
        }
        catch (InstantiationException instantiationException) {
            throw new UnmarshalException("Unable to create remote reference", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnmarshalException("Illegal access creating remote reference");
        }
    }

    public String remoteToString() {
        return Util.getUnqualifiedName(this.getClass()) + " [remoteRef: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.id.hashCode();
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof ActivatableRef) {
            return this.id.equals(((ActivatableRef)remoteRef).id);
        }
        return false;
    }
}

