/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.bs;
import sun.security.krb5.internal.ccache.a4;
import sun.security.krb5.internal.crypto.Des3;
import sun.security.krb5.internal.crypto.a2;
import sun.security.krb5.internal.crypto.m;
import sun.security.krb5.internal.ktab.k;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncryptionKey
implements Cloneable {
    public static final EncryptionKey NULL_KEY = new EncryptionKey(new byte[0], 0, null);
    private int a;
    private byte[] b;
    private Integer c;
    private static final boolean d = bs.ed;

    public synchronized int getEType() {
        return this.a;
    }

    public final Integer getKeyVersionNumber() {
        return this.c;
    }

    public final byte[] getBytes() {
        return this.b;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.b, this.a, this.c);
    }

    public static EncryptionKey[] acquireSecretKeys(PrincipalName principalName, String string) throws KrbException, IOException {
        if (principalName == null) {
            throw new IllegalArgumentException("Cannot have null pricipal name to look in keytab.");
        }
        k k2 = k.a(string);
        if (k2 == null) {
            return null;
        }
        return k2.b(principalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncryptionKey[] acquireSecretKeys(char[] cArray, String string) throws KrbException {
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        Arrays.fill(cArray2, '0');
        try {
            int[] nArray = m.a("default_tkt_enctypes");
            if (nArray == null) {
                nArray = m.k();
            }
            EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                encryptionKeyArray[i2] = new EncryptionKey(EncryptionKey.a(cArray3, nArray[i2]), nArray[i2], null);
            }
            EncryptionKey[] encryptionKeyArray2 = encryptionKeyArray;
            return encryptionKeyArray2;
        }
        finally {
            Arrays.fill(cArray3, '0');
        }
    }

    public EncryptionKey(byte[] byArray, int n2, Integer n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("EncryptionKey: Key bytes cannot be null!");
        }
        this.b = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.b, 0, byArray.length);
        this.a = n2;
        this.c = n3;
    }

    public EncryptionKey(int n2, byte[] byArray) {
        this(byArray, n2, null);
    }

    private static byte[] a(char[] cArray, int n2) throws KrbCryptoException {
        switch (n2) {
            case 1: 
            case 3: {
                return a2.b(cArray);
            }
            case 16: {
                try {
                    return Des3.stringToKey(cArray);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
                    krbCryptoException.initCause(generalSecurityException);
                    throw krbCryptoException;
                }
            }
        }
        throw new IllegalArgumentException("encryption type " + m.c(n2) + " not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptionKey(char[] cArray, String string, String string2) throws KrbCryptoException {
        if (string2 == null || string2.equalsIgnoreCase("DES")) {
            this.a = 3;
        } else if (string2.equalsIgnoreCase("DESede")) {
            this.a = 16;
        } else {
            throw new IllegalArgumentException("Algorithm " + string2 + " not supported");
        }
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        Arrays.fill(cArray2, '0');
        try {
            this.b = EncryptionKey.a(cArray3, this.a);
            this.c = null;
        }
        finally {
            Arrays.fill(cArray3, '0');
        }
    }

    EncryptionKey(EncryptionKey encryptionKey) throws KrbCryptoException {
        this.b = (byte[])encryptionKey.b.clone();
        this.a = encryptionKey.a;
    }

    public EncryptionKey(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.b = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.a);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public synchronized void destroy() {
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                this.b[i2] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptionKey(derValue2);
    }

    public synchronized void writeKey(a4 a42) throws IOException {
        a42.b(this.a);
        a42.b(this.a);
        a42.a(this.b.length);
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            a42.c(this.b[i2]);
        }
    }

    public String toString() {
        return new String("EncryptionKey: keyType=" + this.a + " kvno=" + this.c + " keyValue (hex dump)=" + (this.b == null || this.b.length == 0 ? " Empty Key" : '\n' + bs.ee.encode(this.b) + '\n'));
    }

    public static EncryptionKey findKey(int n2, EncryptionKey[] encryptionKeyArray) {
        int n3;
        int n4;
        for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
            n3 = encryptionKeyArray[n4].getEType();
            if (n2 != n3) continue;
            return encryptionKeyArray[n4];
        }
        if (n2 == 1 || n2 == 3) {
            for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
                n3 = encryptionKeyArray[n4].getEType();
                if (n3 != 1 && n3 != 3) continue;
                return new EncryptionKey(n2, encryptionKeyArray[n4].getBytes());
            }
        }
        return null;
    }
}

