/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sun.security.action.GetPropertyAction;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean USE_CRLDP = DistributionPointFetcher.getBooleanProperty("com.sun.security.enableCRLDP", false);
    private static final DistributionPointFetcher INSTANCE = new DistributionPointFetcher();
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private final Cache cache;

    public static boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl2;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    private DistributionPointFetcher() {
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
        this.cache = Cache.newSoftMemoryCache(185);
    }

    static DistributionPointFetcher getInstance() {
        return INSTANCE;
    }

    Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (!USE_CRLDP) {
            return Collections.EMPTY_SET;
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate == null) {
            return Collections.EMPTY_SET;
        }
        try {
            CRLDistributionPointsExtension cRLDistributionPointsExtension;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            if ((cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension()) == null) {
                return Collections.EMPTY_SET;
            }
            X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
            List list = (List)cRLDistributionPointsExtension.get("points");
            HashSet hashSet = new HashSet();
            for (DistributionPoint distributionPoint : list) {
                Collection collection = this.getCRLs(x509CRLSelector, x500Name, distributionPoint);
                hashSet.addAll(collection);
            }
            if (debug != null) {
                debug.println("Returning " + hashSet.size() + " CRLs");
            }
            return hashSet;
        }
        catch (CertificateException certificateException) {
            return Collections.EMPTY_SET;
        }
        catch (IOException iOException) {
            return Collections.EMPTY_SET;
        }
    }

    private Collection getCRLs(X509CRLSelector x509CRLSelector, X500Name x500Name, DistributionPoint distributionPoint) {
        Object object;
        Object object2;
        if (distributionPoint.getReasonFlags() != null) {
            return Collections.EMPTY_LIST;
        }
        GeneralNames generalNames = distributionPoint.getCRLIssuer();
        if (generalNames != null) {
            object2 = generalNames.iterator();
            while (object2.hasNext()) {
                object = ((GeneralName)object2.next()).getName();
                if (x500Name.equals(object)) continue;
                return Collections.EMPTY_LIST;
            }
        }
        if ((object2 = distributionPoint.getFullName()) == null) {
            return Collections.EMPTY_LIST;
        }
        object = new ArrayList(2);
        Iterator<GeneralName> iterator = ((GeneralNames)object2).iterator();
        while (iterator.hasNext()) {
            GeneralName generalName = iterator.next();
            if (generalName.getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            String string = uRIName.getName();
            if (debug != null) {
                debug.println("Trying to fetch CRL from DP " + string);
            }
            try {
                X509CRL x509CRL;
                URI uRI = new URI(string);
                if (uRI.getScheme().toLowerCase().equals("ldap")) continue;
                CacheEntry cacheEntry = (CacheEntry)this.cache.get(uRI);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry();
                    this.cache.put(uRI, cacheEntry);
                }
                if ((x509CRL = cacheEntry.getCRL(this.factory, uRI)) == null || !x509CRLSelector.match(x509CRL)) continue;
                object.add(x509CRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                if (debug == null) continue;
                debug.println("Exception parsing URI:");
                uRISyntaxException.printStackTrace();
            }
        }
        return object;
    }

    private static class CacheEntry {
        private X509CRL crl;
        private long lastChecked;
        private long lastModified;

        CacheEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized X509CRL getCRL(CertificateFactory certificateFactory, URI uRI) {
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastChecked < 30000L) {
                if (debug == null) return this.crl;
                debug.println("Returning CRL from cache");
                return this.crl;
            }
            this.lastChecked = l2;
            InputStream inputStream = null;
            try {
                Object object;
                URL uRL = uRI.toURL();
                URLConnection uRLConnection = uRL.openConnection();
                if (this.lastModified != 0L) {
                    uRLConnection.setIfModifiedSince(this.lastModified);
                }
                inputStream = uRLConnection.getInputStream();
                long l3 = this.lastModified;
                this.lastModified = uRLConnection.getLastModified();
                if (l3 != 0L) {
                    if (l3 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        X509CRL x509CRL = this.crl;
                        return x509CRL;
                    }
                    if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        X509CRL x509CRL = this.crl;
                        return x509CRL;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new CRL...");
                }
                this.crl = (X509CRL)certificateFactory.generateCRL(inputStream);
                object = this.crl;
                return object;
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("Exception fetching CRLDP:");
                    iOException.printStackTrace();
                }
            }
            catch (CRLException cRLException) {
                if (debug != null) {
                    debug.println("Exception fetching CRLDP:");
                    cRLException.printStackTrace();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.lastModified = 0L;
            this.crl = null;
            return null;
        }
    }
}

