/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.ZoneInfo;

public abstract class AbstractCalendar
extends CalendarSystem {
    static final int SECOND_IN_MILLIS = 1000;
    static final int MINUTE_IN_MILLIS = 60000;
    static final int HOUR_IN_MILLIS = 3600000;
    static final int DAY_IN_MILLIS = 86400000;
    static final int EPOCH_OFFSET = 719163;
    private Era[] eras;

    protected AbstractCalendar() {
    }

    public Era getEra(String string) {
        if (this.eras != null) {
            for (int i2 = 0; i2 < this.eras.length; ++i2) {
                if (!this.eras[i2].equals(string)) continue;
                return this.eras[i2];
            }
        }
        return null;
    }

    public Era[] getEras() {
        Era[] eraArray = null;
        if (this.eras != null) {
            eraArray = new Era[this.eras.length];
            System.arraycopy(this.eras, 0, eraArray, 0, this.eras.length);
        }
        return eraArray;
    }

    public void setEra(CalendarDate calendarDate, String string) {
        if (this.eras == null) {
            return;
        }
        for (int i2 = 0; i2 < this.eras.length; ++i2) {
            Era era = this.eras[i2];
            if (era == null || !era.getName().equals(string)) continue;
            calendarDate.setEra(era);
            return;
        }
        throw new IllegalArgumentException("unknown era name: " + string);
    }

    protected void setEras(Era[] eraArray) {
        this.eras = eraArray;
    }

    public CalendarDate getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    public CalendarDate getCalendarDate(long l2) {
        return this.getCalendarDate(l2, this.newCalendarDate());
    }

    public CalendarDate getCalendarDate(long l2, TimeZone timeZone) {
        CalendarDate calendarDate = this.newCalendarDate(timeZone);
        return this.getCalendarDate(l2, calendarDate);
    }

    public CalendarDate getCalendarDate(long l2, CalendarDate calendarDate) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l3 = 0L;
        TimeZone timeZone = calendarDate.getZone();
        if (timeZone != null) {
            int[] nArray = new int[2];
            if (timeZone instanceof ZoneInfo) {
                n3 = ((ZoneInfo)timeZone).getOffsets(l2, nArray);
            } else {
                n3 = timeZone.getOffset(l2);
                nArray[0] = timeZone.getRawOffset();
                nArray[1] = n3 - nArray[0];
            }
            l3 = n3 / 86400000;
            n2 = n3 % 86400000;
            n4 = nArray[1];
        }
        calendarDate.setZoneOffset(n3);
        calendarDate.setDaylightSaving(n4);
        l3 += l2 / 86400000L;
        if ((n2 += (int)(l2 % 86400000L)) >= 86400000) {
            n2 -= 86400000;
            ++l3;
        } else {
            while (n2 < 0) {
                n2 += 86400000;
                --l3;
            }
        }
        this.getCalendarDateFromFixedDate(calendarDate, l3 += 719163L);
        this.setTimeOfDay(calendarDate, n2);
        calendarDate.setLeapYear(this.isLeapYear(calendarDate));
        calendarDate.setNormalized(true);
        return calendarDate;
    }

    public long getTime(CalendarDate calendarDate) {
        long l2 = this.getFixedDate(calendarDate);
        long l3 = (l2 - 719163L) * 86400000L + this.getTimeOfDay(calendarDate);
        int n2 = 0;
        TimeZone timeZone = calendarDate.getZone();
        if (timeZone != null) {
            if (calendarDate.isNormalized()) {
                return l3 - (long)calendarDate.getZoneOffset();
            }
            int[] nArray = new int[2];
            if (calendarDate.isStandardTime()) {
                if (timeZone instanceof ZoneInfo) {
                    ((ZoneInfo)timeZone).getOffsetsByStandard(l3, nArray);
                    n2 = nArray[0];
                } else {
                    n2 = timeZone.getOffset(l3 - (long)timeZone.getRawOffset());
                }
            } else {
                n2 = timeZone instanceof ZoneInfo ? ((ZoneInfo)timeZone).getOffsetsByWall(l3, nArray) : timeZone.getOffset(l3 - (long)timeZone.getRawOffset());
            }
        }
        this.getCalendarDate(l3 -= (long)n2, calendarDate);
        return l3;
    }

    protected long getTimeOfDay(CalendarDate calendarDate) {
        long l2 = calendarDate.getTimeOfDay();
        if (l2 != Long.MIN_VALUE) {
            return l2;
        }
        l2 = this.getTimeOfDayValue(calendarDate);
        calendarDate.setTimeOfDay(l2);
        return l2;
    }

    public long getTimeOfDayValue(CalendarDate calendarDate) {
        long l2 = calendarDate.getHours();
        l2 *= 60L;
        l2 += (long)calendarDate.getMinutes();
        l2 *= 60L;
        l2 += (long)calendarDate.getSeconds();
        l2 *= 1000L;
        return l2 += (long)calendarDate.getMillis();
    }

    public CalendarDate setTimeOfDay(CalendarDate calendarDate, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        boolean bl2 = calendarDate.isNormalized();
        int n3 = n2;
        int n4 = n3 / 3600000;
        int n5 = (n3 %= 3600000) / 60000;
        int n6 = (n3 %= 60000) / 1000;
        n3 %= 1000;
        calendarDate.setHours(n4);
        calendarDate.setMinutes(n5);
        calendarDate.setSeconds(n6);
        calendarDate.setMillis(n3);
        calendarDate.setTimeOfDay(n2);
        if (n4 < 24 && bl2) {
            calendarDate.setNormalized(bl2);
        }
        return calendarDate;
    }

    public int getWeekLength() {
        return 7;
    }

    protected abstract boolean isLeapYear(CalendarDate var1);

    public CalendarDate getNthDayOfWeek(int n2, int n3, CalendarDate calendarDate) {
        CalendarDate calendarDate2 = (CalendarDate)calendarDate.clone();
        this.normalize(calendarDate2);
        long l2 = this.getFixedDate(calendarDate2);
        long l3 = n2 > 0 ? (long)(7 * n2) + AbstractCalendar.getDayOfWeekDateBefore(l2, n3) : (long)(7 * n2) + AbstractCalendar.getDayOfWeekDateAfter(l2, n3);
        this.getCalendarDateFromFixedDate(calendarDate2, l3);
        return calendarDate2;
    }

    static long getDayOfWeekDateBefore(long l2, int n2) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(l2 - 1L, n2);
    }

    static long getDayOfWeekDateAfter(long l2, int n2) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(l2 + 7L, n2);
    }

    public static long getDayOfWeekDateOnOrBefore(long l2, int n2) {
        long l3 = l2 - (long)(n2 - 1);
        if (l3 >= 0L) {
            return l2 - l3 % 7L;
        }
        return l2 - CalendarUtils.mod(l3, 7L);
    }

    protected abstract long getFixedDate(CalendarDate var1);

    protected abstract void getCalendarDateFromFixedDate(CalendarDate var1, long var2);

    public boolean validateTime(CalendarDate calendarDate) {
        int n2 = calendarDate.getHours();
        if (n2 < 0 || n2 >= 24) {
            return false;
        }
        n2 = calendarDate.getMinutes();
        if (n2 < 0 || n2 >= 60) {
            return false;
        }
        n2 = calendarDate.getSeconds();
        if (n2 < 0 || n2 >= 60) {
            return false;
        }
        n2 = calendarDate.getMillis();
        return n2 >= 0 && n2 < 1000;
    }

    int normalizeTime(CalendarDate calendarDate) {
        long l2 = this.getTimeOfDay(calendarDate);
        long l3 = 0L;
        if (l2 >= 86400000L) {
            l3 = l2 / 86400000L;
            l2 %= 86400000L;
        } else if (l2 < 0L && (l3 = CalendarUtils.floorDivide(l2, 86400000L)) != 0L) {
            l2 -= 86400000L * l3;
        }
        if (l3 != 0L) {
            calendarDate.setTimeOfDay(l2);
        }
        calendarDate.setMillis((int)(l2 % 1000L));
        calendarDate.setSeconds((int)((l2 /= 1000L) % 60L));
        calendarDate.setMinutes((int)((l2 /= 60L) % 60L));
        calendarDate.setHours((int)(l2 / 60L));
        return (int)l3;
    }
}

