/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;
import sun.security.util.DerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class P11KeyStore
extends KeyStoreSpi {
    private static final CK_ATTRIBUTE ATTR_CLASS_CERT = new CK_ATTRIBUTE(0L, 1L);
    private static final CK_ATTRIBUTE ATTR_CLASS_PKEY = new CK_ATTRIBUTE(0L, 3L);
    private static final CK_ATTRIBUTE ATTR_CLASS_SKEY = new CK_ATTRIBUTE(0L, 4L);
    private static final CK_ATTRIBUTE ATTR_X509_CERT_TYPE = new CK_ATTRIBUTE(128L, 0L);
    private static final CK_ATTRIBUTE ATTR_TOKEN_TRUE;
    private static CK_ATTRIBUTE ATTR_SKEY_TOKEN_TRUE;
    private static final CK_ATTRIBUTE ATTR_TRUSTED_TRUE;
    private static final CK_ATTRIBUTE ATTR_PRIVATE_TRUE;
    private static final long NO_HANDLE = -1L;
    private static final long MAX_NUM = 100L;
    private static final String ALIAS_SEP = "/";
    private static final boolean NSS_TEST = false;
    private static final Debug debug;
    private static boolean CKA_TRUSTED_SUPPORTED;
    private final Token token;
    private boolean writeDisabled = false;
    private HashMap<String, AliasInfo> aliasMap;

    P11KeyStore(Token token) {
        this.token = token;
    }

    @Override
    public synchronized Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        this.token.ensureValid();
        if (cArray != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new NoSuchAlgorithmException("password must be null");
        }
        AliasInfo aliasInfo = this.aliasMap.get(string);
        if (aliasInfo == null || aliasInfo.type == ATTR_CLASS_CERT) {
            return null;
        }
        Session session = null;
        try {
            THandle tHandle;
            session = this.token.getOpSession();
            if (aliasInfo.type == ATTR_CLASS_PKEY) {
                tHandle = this.getTokenObject(session, aliasInfo.type, aliasInfo.id, null);
                if (tHandle.type == ATTR_CLASS_PKEY) {
                    PrivateKey privateKey = this.loadPkey(session, tHandle.handle);
                    return privateKey;
                }
            } else {
                tHandle = this.getTokenObject(session, ATTR_CLASS_SKEY, null, string);
                if (tHandle.type == ATTR_CLASS_SKEY) {
                    SecretKey secretKey = this.loadSkey(session, tHandle.handle);
                    return secretKey;
                }
            }
            tHandle = null;
            return tHandle;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ProviderException(keyStoreException);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    public synchronized Certificate[] engineGetCertificateChain(String string) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(string);
        if (aliasInfo == null || aliasInfo.type != ATTR_CLASS_PKEY) {
            return null;
        }
        return aliasInfo.chain;
    }

    @Override
    public synchronized Certificate engineGetCertificate(String string) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(string);
        if (aliasInfo == null) {
            return null;
        }
        return aliasInfo.cert;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        this.token.ensureValid();
        throw new ProviderException(new UnsupportedOperationException());
    }

    @Override
    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
            throw new KeyStoreException("key must be PrivateKey or SecretKey");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("PrivateKey must be accompanied by non-null chain");
        }
        if (key instanceof SecretKey && certificateArray != null) {
            throw new KeyStoreException("SecretKey must be accompanied by null chain");
        }
        if (cArray != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException("Password must be null");
        }
        KeyStore.Entry entry = null;
        try {
            if (key instanceof PrivateKey) {
                entry = new KeyStore.PrivateKeyEntry((PrivateKey)key, certificateArray);
            } else if (key instanceof SecretKey) {
                entry = new KeyStore.SecretKeyEntry((SecretKey)key);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyStoreException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KeyStoreException(illegalArgumentException);
        }
        this.engineSetEntry(string, entry, new KeyStore.PasswordProtection(cArray));
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.token.ensureValid();
        throw new ProviderException(new UnsupportedOperationException());
    }

    @Override
    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (certificate == null) {
            throw new KeyStoreException("invalid null certificate");
        }
        KeyStore.TrustedCertificateEntry trustedCertificateEntry = null;
        trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(certificate);
        this.engineSetEntry(string, trustedCertificateEntry, null);
    }

    @Override
    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        this.token.ensureValid();
        if (this.token.isWriteProtected()) {
            throw new KeyStoreException("token write-protected");
        }
        this.checkWrite();
        this.deleteEntry(string);
    }

    private boolean deleteEntry(String string) throws KeyStoreException {
        AliasInfo aliasInfo = this.aliasMap.get(string);
        if (aliasInfo != null) {
            this.aliasMap.remove(string);
            try {
                if (aliasInfo.type == ATTR_CLASS_CERT) {
                    return this.destroyCert(aliasInfo.id);
                }
                if (aliasInfo.type == ATTR_CLASS_PKEY) {
                    return this.destroyPkey(aliasInfo.id) && this.destroyChain(aliasInfo.id);
                }
                if (aliasInfo.type == ATTR_CLASS_SKEY) {
                    return this.destroySkey(string);
                }
                throw new KeyStoreException("unexpected entry type");
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new KeyStoreException(pKCS11Exception);
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
        }
        return false;
    }

    public synchronized Enumeration engineAliases() {
        this.token.ensureValid();
        return Collections.enumeration(new HashSet<String>(this.aliasMap.keySet()));
    }

    @Override
    public synchronized boolean engineContainsAlias(String string) {
        this.token.ensureValid();
        return this.aliasMap.containsKey(string);
    }

    @Override
    public synchronized int engineSize() {
        this.token.ensureValid();
        return this.aliasMap.size();
    }

    @Override
    public synchronized boolean engineIsKeyEntry(String string) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(string);
        return aliasInfo != null && aliasInfo.type != ATTR_CLASS_CERT;
    }

    @Override
    public synchronized boolean engineIsCertificateEntry(String string) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(string);
        return aliasInfo != null && aliasInfo.type == ATTR_CLASS_CERT;
    }

    @Override
    public synchronized String engineGetCertificateAlias(Certificate certificate) {
        this.token.ensureValid();
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Certificate certificate2 = this.engineGetCertificate(string);
            if (certificate2 == null || !certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (outputStream != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("output stream must be null");
        }
        if (cArray != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("password must be null");
        }
    }

    @Override
    public synchronized void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (loadStoreParameter != null) {
            throw new IllegalArgumentException("LoadStoreParameter must be null");
        }
    }

    @Override
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (inputStream != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("input stream must be null");
        }
        try {
            if (cArray == null) {
                this.login(null);
            } else {
                this.login(new PasswordCallbackHandler(cArray));
            }
            if (this.mapLabels()) {
                this.writeDisabled = true;
            }
            if (debug != null) {
                this.dumpTokenMap();
            }
        }
        catch (LoginException loginException) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(loginException);
            throw iOException;
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(keyStoreException);
            throw iOException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(pKCS11Exception);
            throw iOException;
        }
    }

    @Override
    public synchronized void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        CallbackHandler callbackHandler;
        this.token.ensureValid();
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("invalid null LoadStoreParameter");
        }
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            char[] cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            callbackHandler = cArray == null ? null : new PasswordCallbackHandler(cArray);
        } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be either PasswordProtection or CallbackHandlerProtection");
        }
        try {
            this.login(callbackHandler);
            if (this.mapLabels()) {
                this.writeDisabled = true;
            }
            if (debug != null) {
                this.dumpTokenMap();
            }
        }
        catch (LoginException loginException) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(loginException);
            throw iOException;
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(keyStoreException);
            throw iOException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            IOException iOException = new IOException("load failed");
            iOException.initCause(pKCS11Exception);
            throw iOException;
        }
    }

    private void login(CallbackHandler callbackHandler) throws LoginException {
        if ((this.token.tokenInfo.flags & 0x100L) == 0L) {
            this.token.provider.login(null, callbackHandler);
        } else {
            if (callbackHandler != null && !this.token.config.getKeyStoreCompatibilityMode()) {
                throw new LoginException("can not specify password if token supports protected authentication path");
            }
            this.token.provider.login(null, null);
        }
    }

    @Override
    public synchronized KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        this.token.ensureValid();
        if (protectionParameter != null && protectionParameter instanceof KeyStore.PasswordProtection && ((KeyStore.PasswordProtection)protectionParameter).getPassword() != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException("ProtectionParameter must be null");
        }
        AliasInfo aliasInfo = this.aliasMap.get(string);
        if (aliasInfo == null) {
            if (debug != null) {
                debug.println("engineGetEntry did not find alias [" + string + "] in map");
            }
            return null;
        }
        Session session = null;
        try {
            THandle tHandle;
            session = this.token.getOpSession();
            if (aliasInfo.type == ATTR_CLASS_CERT) {
                if (debug != null) {
                    debug.println("engineGetEntry found trusted cert entry");
                }
                KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(aliasInfo.cert);
                return trustedCertificateEntry;
            }
            if (aliasInfo.type == ATTR_CLASS_SKEY) {
                THandle tHandle2;
                if (debug != null) {
                    debug.println("engineGetEntry found secret key entry");
                }
                if ((tHandle2 = this.getTokenObject(session, ATTR_CLASS_SKEY, null, aliasInfo.label)).type != ATTR_CLASS_SKEY) {
                    throw new KeyStoreException("expected but could not find secret key");
                }
                SecretKey secretKey = this.loadSkey(session, tHandle2.handle);
                KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(secretKey);
                return secretKeyEntry;
            }
            if (debug != null) {
                debug.println("engineGetEntry found private key entry");
            }
            if ((tHandle = this.getTokenObject(session, ATTR_CLASS_PKEY, aliasInfo.id, null)).type != ATTR_CLASS_PKEY) {
                throw new KeyStoreException("expected but could not find private key");
            }
            PrivateKey privateKey = this.loadPkey(session, tHandle.handle);
            Certificate[] certificateArray = aliasInfo.chain;
            if (certificateArray != null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, certificateArray);
                return privateKeyEntry;
            }
            if (debug != null) {
                debug.println("engineGetEntry got null cert chain");
            }
            tHandle = null;
            return tHandle;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStoreException(pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void engineSetEntry(String var1_1, KeyStore.Entry var2_2, KeyStore.ProtectionParameter var3_3) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (var3_3 != null && var3_3 instanceof KeyStore.PasswordProtection && ((KeyStore.PasswordProtection)var3_3).getPassword() != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException(new UnsupportedOperationException("ProtectionParameter must be null"));
        }
        if (this.token.isWriteProtected()) {
            throw new KeyStoreException("token write-protected");
        }
        if (var2_2 instanceof KeyStore.TrustedCertificateEntry) {
            throw new KeyStoreException(new UnsupportedOperationException("trusted certificates may only be set by token initialization application"));
        }
        if (var2_2 instanceof KeyStore.PrivateKeyEntry) {
            var4_4 = ((KeyStore.PrivateKeyEntry)var2_2).getPrivateKey();
            if (!(var4_4 instanceof P11Key || var4_4 instanceof RSAPrivateKey || var4_4 instanceof DSAPrivateKey || var4_4 instanceof DHPrivateKey)) {
                throw new KeyStoreException("unsupported key type: " + var4_4.getClass().getName());
            }
            var5_7 = ((KeyStore.PrivateKeyEntry)var2_2).getCertificateChain();
            if (!(var5_7 instanceof X509Certificate[])) {
                throw new KeyStoreException(new UnsupportedOperationException("unsupported certificate array type: " + var5_7.getClass().getName()));
            }
            try {
                var6_9 = false;
                var7_13 = this.aliasMap.keySet();
                for (String var9_15 : var7_13) {
                    var10_16 = this.aliasMap.get(var9_15);
                    if (AliasInfo.access$400(var10_16) != P11KeyStore.ATTR_CLASS_PKEY || !AliasInfo.access$900(var10_16).getPublicKey().equals(var5_7[0].getPublicKey())) continue;
                    this.updatePkey(var1_1, AliasInfo.access$500(var10_16), (X509Certificate[])var5_7, AliasInfo.access$900(var10_16).equals(var5_7[0]) == false);
                    var6_9 = true;
                    break;
                }
                if (var6_9) ** GOTO lbl44
                this.engineDeleteEntry(var1_1);
                this.storePkey(var1_1, (KeyStore.PrivateKeyEntry)var2_2);
            }
            catch (PKCS11Exception var6_10) {
                throw new KeyStoreException(var6_10);
            }
            catch (CertificateException var6_11) {
                throw new KeyStoreException(var6_11);
            }
        } else if (var2_2 instanceof KeyStore.SecretKeyEntry) {
            var4_4 = (KeyStore.SecretKeyEntry)var2_2;
            var5_8 = var4_4.getSecretKey();
            try {
                if (this.updateSkey(var1_1)) ** GOTO lbl44
                this.engineDeleteEntry(var1_1);
                this.storeSkey(var1_1, (KeyStore.SecretKeyEntry)var4_4);
            }
            catch (PKCS11Exception var6_12) {
                throw new KeyStoreException(var6_12);
            }
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + var2_2.getClass().getName()));
        }
lbl44:
        // 4 sources

        try {
            this.mapLabels();
            if (P11KeyStore.debug != null) {
                this.dumpTokenMap();
            }
        }
        catch (PKCS11Exception var4_5) {
            throw new KeyStoreException(var4_5);
        }
        catch (CertificateException var4_6) {
            throw new KeyStoreException(var4_6);
        }
        if (P11KeyStore.debug != null) {
            P11KeyStore.debug.println("engineSetEntry added new entry for [" + var1_1 + "] to token");
        }
    }

    @Override
    public synchronized boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        this.token.ensureValid();
        return super.engineEntryInstanceOf(string, clazz);
    }

    private X509Certificate loadCert(Session session, long l) throws PKCS11Exception, CertificateException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        if (byArray == null) {
            throw new CertificateException("unexpectedly retrieved null byte array");
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }

    private X509Certificate[] loadChain(Session session, X509Certificate x509Certificate) throws PKCS11Exception, CertificateException {
        ArrayList<X509Certificate> arrayList = null;
        if (x509Certificate.getSubjectX500Principal().equals(x509Certificate.getIssuerX500Principal())) {
            return new X509Certificate[]{x509Certificate};
        }
        arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        X509Certificate x509Certificate2 = x509Certificate;
        do {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(257L, x509Certificate2.getIssuerX500Principal().getEncoded())};
            this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
            long[] lArray = this.token.p11.C_FindObjects(session.id(), 100L);
            this.token.p11.C_FindObjectsFinal(session.id());
            if (lArray == null || lArray.length == 0) break;
            if (debug != null && lArray.length > 1) {
                debug.println("engineGetEntry found " + lArray.length + " certificate entries for subject [" + x509Certificate2.getIssuerX500Principal().toString() + "] in token - using first entry");
            }
            x509Certificate2 = this.loadCert(session, lArray[0]);
            arrayList.add(x509Certificate2);
        } while (!x509Certificate2.getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal()));
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    private SecretKey loadSkey(Session session, long l) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
        this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
        long l2 = cK_ATTRIBUTEArray[0].getLong();
        String string = null;
        int n = -1;
        if (l2 == 19L || l2 == 21L) {
            if (l2 == 19L) {
                string = "DES";
                n = 64;
            } else if (l2 == 21L) {
                string = "DESede";
                n = 192;
            }
        } else {
            if (l2 == 31L) {
                string = "AES";
            } else if (l2 == 32L) {
                string = "Blowfish";
            } else if (l2 == 18L) {
                string = "ARCFOUR";
            } else {
                if (debug != null) {
                    debug.println("unknown key type [" + l2 + "] - using 'Generic Secret'");
                }
                string = "Generic Secret";
            }
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(353L)};
            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            n = (int)cK_ATTRIBUTEArray[0].getLong();
        }
        return P11Key.secretKey(session, l, string, n, null);
    }

    private PrivateKey loadPkey(Session session, long l) throws PKCS11Exception, KeyStoreException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
        this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
        long l2 = cK_ATTRIBUTEArray[0].getLong();
        String string = null;
        int n = 0;
        if (l2 == 0L) {
            string = "RSA";
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            BigInteger bigInteger = cK_ATTRIBUTEArray[0].getBigInteger();
            n = bigInteger.bitLength();
            return P11Key.privateKey(session, l, string, n, null);
        }
        if (l2 == 1L) {
            string = "DSA";
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L)};
            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            BigInteger bigInteger = cK_ATTRIBUTEArray[0].getBigInteger();
            n = bigInteger.bitLength();
            return P11Key.privateKey(session, l, string, n, null);
        }
        if (l2 == 2L) {
            string = "DH";
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L)};
            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            BigInteger bigInteger = cK_ATTRIBUTEArray[0].getBigInteger();
            n = bigInteger.bitLength();
            return P11Key.privateKey(session, l, string, n, null);
        }
        if (debug != null) {
            debug.println("unknown key type [" + l2 + "]");
        }
        throw new KeyStoreException("unknown key type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSkey(String string) throws KeyStoreException, PKCS11Exception {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_SKEY, null, string);
            if (tHandle.type != ATTR_CLASS_SKEY) {
                if (debug != null) {
                    debug.println("did not find secret key with CKA_LABEL [" + string + "]");
                }
                boolean bl = false;
                return bl;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
            this.token.p11.C_SetAttributeValue(session.id(), tHandle.handle, cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("updateSkey set new alias [" + string + "] for secret key entry");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePkey(String string, byte[] byArray, X509Certificate[] x509CertificateArray, boolean bl) throws KeyStoreException, CertificateException, PKCS11Exception {
        bl = true;
        Session session = null;
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_PKEY, byArray, null);
            if (tHandle.type != ATTR_CLASS_PKEY) {
                throw new KeyStoreException("expected but could not find private key with CKA_ID " + P11KeyStore.getID(byArray));
            }
            long l = tHandle.handle;
            tHandle = this.getTokenObject(session, ATTR_CLASS_CERT, byArray, null);
            if (tHandle.type != ATTR_CLASS_CERT) {
                throw new KeyStoreException("expected but could not find private key with CKA_ID " + P11KeyStore.getID(byArray));
            }
            if (bl) {
                this.destroyChain(byArray);
            } else {
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(258L, string)};
                this.token.p11.C_SetAttributeValue(session.id(), tHandle.handle, cK_ATTRIBUTEArray);
            }
            if (bl) {
                this.storeChain(string, x509CertificateArray);
            } else {
                this.storeCaCerts(x509CertificateArray, 1);
            }
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, string)};
            this.token.p11.C_SetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("updatePkey set new alias [" + string + "] for private key entry");
            }
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateP11Skey(String string, P11Key p11Key) throws PKCS11Exception {
        Session session = null;
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, new CK_ATTRIBUTE(3L, string)};
            this.token.p11.C_CopyObject(session.id(), p11Key.keyID, cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("updateP11Skey copied secret session key for [" + string + "] to token entry");
            }
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateP11Pkey(String string, P11Key p11Key) throws PKCS11Exception {
        Session session = null;
        try {
            session = this.token.getOpSession();
            if (p11Key.tokenObject) {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, string)};
                this.token.p11.C_SetAttributeValue(session.id(), p11Key.keyID, cK_ATTRIBUTEArray);
                if (debug != null) {
                    debug.println("updateP11Pkey set new alias [" + string + "] for key entry");
                }
            } else {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, new CK_ATTRIBUTE(258L, string)};
                this.token.p11.C_CopyObject(session.id(), p11Key.keyID, cK_ATTRIBUTEArray);
                if (debug != null) {
                    debug.println("updateP11Pkey copied private session key for [" + string + "] to token entry");
                }
            }
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCert(String string, X509Certificate x509Certificate) throws PKCS11Exception, CertificateException {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(ATTR_TOKEN_TRUE);
        arrayList.add(ATTR_CLASS_CERT);
        arrayList.add(ATTR_X509_CERT_TYPE);
        arrayList.add(new CK_ATTRIBUTE(257L, x509Certificate.getSubjectX500Principal().getEncoded()));
        arrayList.add(new CK_ATTRIBUTE(129L, x509Certificate.getIssuerX500Principal().getEncoded()));
        arrayList.add(new CK_ATTRIBUTE(130L, x509Certificate.getSerialNumber().toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(17L, x509Certificate.getEncoded()));
        if (string != null) {
            arrayList.add(new CK_ATTRIBUTE(3L, string));
            arrayList.add(new CK_ATTRIBUTE(258L, string));
        } else {
            arrayList.add(new CK_ATTRIBUTE(258L, this.getID(x509Certificate.getSubjectX500Principal().getName("CANONICAL"), x509Certificate)));
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_CreateObject(session.id(), arrayList.toArray(new CK_ATTRIBUTE[arrayList.size()]));
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private void storeChain(String string, X509Certificate[] x509CertificateArray) throws PKCS11Exception, CertificateException {
        this.storeCert(string, x509CertificateArray[0]);
        this.storeCaCerts(x509CertificateArray, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCaCerts(X509Certificate[] x509CertificateArray, int n) throws PKCS11Exception, CertificateException {
        Session session = null;
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT};
            this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
            long[] lArray = this.token.p11.C_FindObjects(session.id(), 100L);
            this.token.p11.C_FindObjectsFinal(session.id());
            for (long l : lArray) {
                hashSet.add(this.loadCert(session, l));
            }
        }
        finally {
            this.token.releaseSession(session);
        }
        for (int i = n; i < x509CertificateArray.length; ++i) {
            if (!hashSet.contains(x509CertificateArray[i])) {
                this.storeCert(null, x509CertificateArray[i]);
                continue;
            }
            if (debug == null) continue;
            debug.println("ignoring duplicate CA cert for [" + x509CertificateArray[i].getSubjectX500Principal() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSkey(String string, KeyStore.SecretKeyEntry secretKeyEntry) throws PKCS11Exception, KeyStoreException {
        SecretKey secretKey = secretKeyEntry.getSecretKey();
        long l = 16L;
        if (secretKey instanceof P11Key && this.token == ((P11Key)((Object)secretKey)).token) {
            this.updateP11Skey(string, (P11Key)((Object)secretKey));
            return;
        }
        if ("AES".equalsIgnoreCase(secretKey.getAlgorithm())) {
            l = 31L;
        } else if ("Blowfish".equalsIgnoreCase(secretKey.getAlgorithm())) {
            l = 32L;
        } else if ("DES".equalsIgnoreCase(secretKey.getAlgorithm())) {
            l = 19L;
        } else if ("DESede".equalsIgnoreCase(secretKey.getAlgorithm())) {
            l = 21L;
        } else if ("RC4".equalsIgnoreCase(secretKey.getAlgorithm()) || "ARCFOUR".equalsIgnoreCase(secretKey.getAlgorithm())) {
            l = 18L;
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, ATTR_CLASS_SKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, l), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, secretKey.getEncoded())};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 4L, l, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("storeSkey created token secret key for [" + string + "]");
            }
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePkey(String string, KeyStore.PrivateKeyEntry privateKeyEntry) throws PKCS11Exception, CertificateException, KeyStoreException {
        Object object;
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = null;
        if (privateKey instanceof P11Key && this.token == ((P11Key)((Object)privateKey)).token) {
            this.updateP11Pkey(string, (P11Key)((Object)privateKey));
            this.storeChain(string, (X509Certificate[])privateKeyEntry.getCertificateChain());
            return;
        }
        if (privateKey instanceof RSAPrivateKey) {
            object = (X509Certificate)privateKeyEntry.getCertificate();
            cK_ATTRIBUTEArray = this.getRsaPrivKeyAttrs(string, (RSAPrivateKey)privateKey, ((X509Certificate)object).getSubjectX500Principal());
        } else if (privateKey instanceof DSAPrivateKey) {
            object = (DSAPrivateKey)privateKey;
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 1L), new CK_ATTRIBUTE(258L, string), new CK_ATTRIBUTE(304L, object.getParams().getP()), new CK_ATTRIBUTE(305L, object.getParams().getQ()), new CK_ATTRIBUTE(306L, object.getParams().getG()), new CK_ATTRIBUTE(17L, object.getX())};
            cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 1L, cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("storePkey created DSA template");
            }
        } else if (privateKey instanceof DHPrivateKey) {
            object = (DHPrivateKey)privateKey;
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 2L), new CK_ATTRIBUTE(258L, string), new CK_ATTRIBUTE(304L, object.getParams().getP()), new CK_ATTRIBUTE(306L, object.getParams().getG()), new CK_ATTRIBUTE(17L, object.getX()), new CK_ATTRIBUTE(352L, object.getParams().getL())};
            cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 2L, cK_ATTRIBUTEArray);
        } else {
            throw new KeyStoreException("unsupported key type: " + privateKey);
        }
        object = null;
        try {
            object = this.token.getOpSession();
            this.token.p11.C_CreateObject(((Session)object).id(), cK_ATTRIBUTEArray);
            if (debug != null) {
                debug.println("storePkey created token key for [" + string + "]");
            }
        }
        finally {
            this.token.releaseSession((Session)object);
        }
        this.storeChain(string, (X509Certificate[])privateKeyEntry.getCertificateChain());
    }

    private CK_ATTRIBUTE[] getRsaPrivKeyAttrs(String string, RSAPrivateKey rSAPrivateKey, X500Principal x500Principal) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = null;
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            if (debug != null) {
                debug.println("creating RSAPrivateCrtKey attrs");
            }
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(258L, string), new CK_ATTRIBUTE(288L, rSAPrivateCrtKey.getModulus()), new CK_ATTRIBUTE(291L, rSAPrivateCrtKey.getPrivateExponent()), new CK_ATTRIBUTE(290L, rSAPrivateCrtKey.getPublicExponent()), new CK_ATTRIBUTE(292L, rSAPrivateCrtKey.getPrimeP()), new CK_ATTRIBUTE(293L, rSAPrivateCrtKey.getPrimeQ()), new CK_ATTRIBUTE(294L, rSAPrivateCrtKey.getPrimeExponentP()), new CK_ATTRIBUTE(295L, rSAPrivateCrtKey.getPrimeExponentQ()), new CK_ATTRIBUTE(296L, rSAPrivateCrtKey.getCrtCoefficient())};
            cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 0L, cK_ATTRIBUTEArray);
        } else {
            if (debug != null) {
                debug.println("creating RSAPrivateKey attrs");
            }
            RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey;
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(258L, string), new CK_ATTRIBUTE(288L, rSAPrivateKey2.getModulus()), new CK_ATTRIBUTE(291L, rSAPrivateKey2.getPrivateExponent())};
            cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 0L, cK_ATTRIBUTEArray);
        }
        return cK_ATTRIBUTEArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyCert(byte[] byArray) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_CERT, byArray, null);
            if (tHandle.type != ATTR_CLASS_CERT) {
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), tHandle.handle);
            if (debug != null) {
                debug.println("destroyCert destroyed cert with CKA_ID [" + P11KeyStore.getID(byArray) + "]");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyChain(byte[] byArray) throws PKCS11Exception, CertificateException, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_CERT, byArray, null);
            if (tHandle.type != ATTR_CLASS_CERT) {
                if (debug != null) {
                    debug.println("destroyChain could not find end entity cert with CKA_ID [0x" + Functions.toHexString(byArray) + "]");
                }
                boolean bl = false;
                return bl;
            }
            X509Certificate x509Certificate = this.loadCert(session, tHandle.handle);
            this.token.p11.C_DestroyObject(session.id(), tHandle.handle);
            if (debug != null) {
                debug.println("destroyChain destroyed end entity cert with CKA_ID [" + P11KeyStore.getID(byArray) + "]");
            }
            X509Certificate x509Certificate2 = x509Certificate;
            while (!x509Certificate2.getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) {
                X509Certificate x509Certificate3;
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(257L, x509Certificate2.getIssuerX500Principal().getEncoded())};
                this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
                long[] lArray = this.token.p11.C_FindObjects(session.id(), 100L);
                this.token.p11.C_FindObjectsFinal(session.id());
                if (lArray == null || lArray.length == 0) break;
                if (debug != null && lArray.length > 1) {
                    debug.println("destroyChain found " + lArray.length + " certificate entries for subject [" + x509Certificate2.getIssuerX500Principal() + "] in token - using first entry");
                }
                x509Certificate2 = this.loadCert(session, lArray[0]);
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(129L, x509Certificate2.getSubjectX500Principal().getEncoded())};
                this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
                long[] lArray2 = this.token.p11.C_FindObjects(session.id(), 100L);
                this.token.p11.C_FindObjectsFinal(session.id());
                boolean bl = false;
                if (lArray2 == null || lArray2.length == 0) {
                    bl = true;
                } else if (lArray2.length == 1 && x509Certificate2.equals(x509Certificate3 = this.loadCert(session, lArray2[0]))) {
                    bl = true;
                }
                if (bl) {
                    this.token.p11.C_DestroyObject(session.id(), lArray[0]);
                    if (debug == null) continue;
                    debug.println("destroyChain destroyed cert in chain with subject [" + x509Certificate2.getSubjectX500Principal() + "]");
                    continue;
                }
                if (debug == null) continue;
                debug.println("destroyChain did not destroy shared cert in chain with subject [" + x509Certificate2.getSubjectX500Principal() + "]");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroySkey(String string) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_SKEY, null, string);
            if (tHandle.type != ATTR_CLASS_SKEY) {
                if (debug != null) {
                    debug.println("destroySkey did not find secret key with CKA_LABEL [" + string + "]");
                }
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), tHandle.handle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyPkey(byte[] byArray) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle tHandle = this.getTokenObject(session, ATTR_CLASS_PKEY, byArray, null);
            if (tHandle.type != ATTR_CLASS_PKEY) {
                if (debug != null) {
                    debug.println("destroyPkey did not find private key with CKA_ID [" + P11KeyStore.getID(byArray) + "]");
                }
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), tHandle.handle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private String getID(String string, X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        return string + ALIAS_SEP + x500Principal.getName("CANONICAL") + ALIAS_SEP + bigInteger.toString();
    }

    private static String getID(byte[] byArray) {
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (DerValue.isPrintableStringChar((char)byArray[i])) continue;
            bl = false;
            break;
        }
        if (!bl) {
            return "0x" + Functions.toHexString(byArray);
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "0x" + Functions.toHexString(byArray);
        }
    }

    private THandle getTokenObject(Session session, CK_ATTRIBUTE cK_ATTRIBUTE, byte[] byArray, String string) throws PKCS11Exception, KeyStoreException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = cK_ATTRIBUTE == ATTR_CLASS_SKEY ? new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, new CK_ATTRIBUTE(3L, string), cK_ATTRIBUTE} : new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, new CK_ATTRIBUTE(258L, byArray), cK_ATTRIBUTE};
        this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray);
        long[] lArray = this.token.p11.C_FindObjects(session.id(), 100L);
        this.token.p11.C_FindObjectsFinal(session.id());
        if (lArray.length == 0) {
            if (debug != null) {
                if (cK_ATTRIBUTE == ATTR_CLASS_SKEY) {
                    debug.println("getTokenObject did not find secret key with CKA_LABEL [" + string + "]");
                } else if (cK_ATTRIBUTE == ATTR_CLASS_CERT) {
                    debug.println("getTokenObject did not find cert with CKA_ID [" + P11KeyStore.getID(byArray) + "]");
                } else {
                    debug.println("getTokenObject did not find private key with CKA_ID [" + P11KeyStore.getID(byArray) + "]");
                }
            }
        } else {
            if (lArray.length == 1) {
                return new THandle(lArray[0], cK_ATTRIBUTE);
            }
            if (cK_ATTRIBUTE == ATTR_CLASS_SKEY) {
                ArrayList<THandle> arrayList = new ArrayList<THandle>(lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                    this.token.p11.C_GetAttributeValue(session.id(), lArray[i], cK_ATTRIBUTEArray2);
                    if (cK_ATTRIBUTEArray2[0].pValue == null || !string.equals(new String(cK_ATTRIBUTEArray2[0].getCharArray()))) continue;
                    arrayList.add(new THandle(lArray[i], ATTR_CLASS_SKEY));
                }
                if (arrayList.size() == 1) {
                    return (THandle)arrayList.get(0);
                }
                throw new KeyStoreException("invalid KeyStore state: found " + arrayList.size() + " secret keys sharing CKA_LABEL [" + string + "]");
            }
            if (cK_ATTRIBUTE == ATTR_CLASS_CERT) {
                throw new KeyStoreException("invalid KeyStore state: found " + lArray.length + " certificates sharing CKA_ID " + P11KeyStore.getID(byArray));
            }
            throw new KeyStoreException("invalid KeyStore state: found " + lArray.length + " private keys sharing CKA_ID " + P11KeyStore.getID(byArray));
        }
        return new THandle(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean mapLabels() throws PKCS11Exception, CertificateException, KeyStoreException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(134L)};
        Session session = null;
        try {
            Object object;
            void object4;
            session = this.token.getOpSession();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY};
            this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray2);
            long[] lArray = this.token.p11.C_FindObjects(session.id(), 100L);
            this.token.p11.C_FindObjectsFinal(session.id());
            Object object2 = lArray;
            int n = ((long[])object2).length;
            boolean bl = false;
            while (object4 < n) {
                long l = object2[object4];
                cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                if (cK_ATTRIBUTEArray2[0].pValue != null) {
                    arrayList.add(cK_ATTRIBUTEArray2[0].getByteArray());
                }
                ++object4;
            }
            object2 = new HashMap();
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT};
            this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray2);
            lArray = this.token.p11.C_FindObjects(session.id(), 100L);
            this.token.p11.C_FindObjectsFinal(session.id());
            for (long l : lArray) {
                HashSet<AliasInfo> hashSet;
                boolean bl2;
                String string;
                block20: {
                    block19: {
                        cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                        string = null;
                        object = null;
                        try {
                            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                            if (cK_ATTRIBUTEArray2[0].pValue != null) {
                                string = new String(cK_ATTRIBUTEArray2[0].getCharArray());
                            }
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            if (pKCS11Exception.getErrorCode() == 18L) break block19;
                            throw pKCS11Exception;
                        }
                    }
                    cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                    this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                    if (cK_ATTRIBUTEArray2[0].pValue == null) {
                        if (string == null) {
                            continue;
                        }
                    } else {
                        if (string == null) {
                            string = P11KeyStore.getID(cK_ATTRIBUTEArray2[0].getByteArray());
                        }
                        object = cK_ATTRIBUTEArray2[0].getByteArray();
                    }
                    bl2 = false;
                    if (CKA_TRUSTED_SUPPORTED) {
                        try {
                            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
                            bl2 = cK_ATTRIBUTEArray[0].getBoolean();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            if (pKCS11Exception.getErrorCode() != 18L) break block20;
                            CKA_TRUSTED_SUPPORTED = false;
                            if (debug == null) break block20;
                            debug.println("CKA_TRUSTED attribute not supported");
                        }
                    }
                }
                if ((hashSet = (HashSet<AliasInfo>)((HashMap)object2).get(string)) == null) {
                    hashSet = new HashSet<AliasInfo>(2);
                    ((HashMap)object2).put(string, hashSet);
                }
                hashSet.add(new AliasInfo(string, (byte[])object, bl2, this.loadCert(session, l)));
            }
            Object object3 = new HashSet();
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, ATTR_CLASS_SKEY};
            this.token.p11.C_FindObjectsInit(session.id(), cK_ATTRIBUTEArray2);
            lArray = this.token.p11.C_FindObjects(session.id(), 100L);
            this.token.p11.C_FindObjectsFinal(session.id());
            for (long l : lArray) {
                cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                if (cK_ATTRIBUTEArray2[0].pValue == null) continue;
                object = new String(cK_ATTRIBUTEArray2[0].getCharArray());
                if (!((HashSet)object3).contains(object)) {
                    ((HashSet)object3).add(object);
                    continue;
                }
                throw new KeyStoreException("invalid KeyStore state: found multiple secret keys sharing same CKA_LABEL [" + (String)object + "]");
            }
            ArrayList<AliasInfo> arrayList2 = this.mapPrivateKeys(arrayList, (HashMap<String, HashSet<AliasInfo>>)object2);
            int n2 = this.mapCerts(arrayList2, (HashMap<String, HashSet<AliasInfo>>)object2) ? 1 : 0;
            this.mapSecretKeys((HashSet<String>)object3);
            int n3 = n2;
            return n3 != 0;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private ArrayList<AliasInfo> mapPrivateKeys(ArrayList<byte[]> arrayList, HashMap<String, HashSet<AliasInfo>> hashMap) throws PKCS11Exception, CertificateException {
        this.aliasMap = new HashMap();
        ArrayList<AliasInfo> arrayList2 = new ArrayList<AliasInfo>();
        for (byte[] byArray : arrayList) {
            boolean bl = false;
            Set<String> set = hashMap.keySet();
            for (String string : set) {
                HashSet<AliasInfo> hashSet = hashMap.get(string);
                for (AliasInfo aliasInfo : hashSet) {
                    if (!Arrays.equals(byArray, aliasInfo.id)) continue;
                    if (hashSet.size() == 1) {
                        aliasInfo.matched = true;
                        this.aliasMap.put(string, aliasInfo);
                    } else {
                        aliasInfo.matched = true;
                        this.aliasMap.put(this.getID(string, aliasInfo.cert), aliasInfo);
                    }
                    arrayList2.add(aliasInfo);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl || debug == null) continue;
            debug.println("did not find match for private key with CKA_ID [" + P11KeyStore.getID(byArray) + "] (ignoring entry)");
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapCerts(ArrayList<AliasInfo> arrayList, HashMap<String, HashSet<AliasInfo>> hashMap) throws PKCS11Exception, CertificateException {
        for (AliasInfo object22 : arrayList) {
            Object object = null;
            try {
                object = this.token.getOpSession();
                AliasInfo.access$802(object22, this.loadChain((Session)object, object22.cert));
            }
            finally {
                this.token.releaseSession((Session)object);
            }
        }
        boolean bl = false;
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            HashSet<AliasInfo> hashSet = hashMap.get(string);
            for (AliasInfo aliasInfo : hashSet) {
                if (aliasInfo.matched) {
                    aliasInfo.trusted = false;
                    continue;
                }
                if (!CKA_TRUSTED_SUPPORTED || !aliasInfo.trusted || !this.mapTrustedCert(string, aliasInfo, hashSet)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean mapTrustedCert(String string, AliasInfo aliasInfo, HashSet<AliasInfo> hashSet) {
        boolean bl = false;
        aliasInfo.type = P11KeyStore.ATTR_CLASS_CERT;
        aliasInfo.trusted = true;
        if (hashSet.size() == 1) {
            this.aliasMap.put(string, aliasInfo);
        } else {
            bl = true;
            this.aliasMap.put(this.getID(string, aliasInfo.cert), aliasInfo);
        }
        return bl;
    }

    private void mapSecretKeys(HashSet<String> hashSet) throws KeyStoreException {
        for (String string : hashSet) {
            if (!this.aliasMap.containsKey(string)) {
                this.aliasMap.put(string, new AliasInfo(string));
                continue;
            }
            throw new KeyStoreException("invalid KeyStore state: found secret key sharing CKA_LABEL [" + string + "] with another token object");
        }
    }

    private void dumpTokenMap() {
        Set<String> set = this.aliasMap.keySet();
        System.out.println("Token Alias Map:");
        if (set.size() == 0) {
            System.out.println("  [empty]");
        } else {
            for (String string : set) {
                System.out.println("  " + string + this.aliasMap.get(string));
            }
        }
    }

    private void checkWrite() throws KeyStoreException {
        if (this.writeDisabled) {
            throw new KeyStoreException("This PKCS11KeyStore does not support write capabilities");
        }
    }

    static {
        ATTR_SKEY_TOKEN_TRUE = ATTR_TOKEN_TRUE = new CK_ATTRIBUTE(1L, true);
        ATTR_TRUSTED_TRUE = new CK_ATTRIBUTE(134L, true);
        ATTR_PRIVATE_TRUE = new CK_ATTRIBUTE(2L, true);
        debug = Debug.getInstance("pkcs11keystore");
        CKA_TRUSTED_SUPPORTED = true;
    }

    private static class THandle {
        private final long handle;
        private final CK_ATTRIBUTE type;

        private THandle(long l, CK_ATTRIBUTE cK_ATTRIBUTE) {
            this.handle = l;
            this.type = cK_ATTRIBUTE;
        }
    }

    private static class PasswordCallbackHandler
    implements CallbackHandler {
        private char[] password;

        private PasswordCallbackHandler(char[] cArray) {
            if (cArray != null) {
                this.password = (char[])cArray.clone();
            }
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            if (!(callbackArray[0] instanceof PasswordCallback)) {
                throw new UnsupportedCallbackException(callbackArray[0]);
            }
            PasswordCallback passwordCallback = (PasswordCallback)callbackArray[0];
            passwordCallback.setPassword(this.password);
        }

        protected void finalize() throws Throwable {
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
            super.finalize();
        }
    }

    private static class AliasInfo {
        private CK_ATTRIBUTE type = null;
        private String label = null;
        private byte[] id = null;
        private boolean trusted = false;
        private X509Certificate cert = null;
        private X509Certificate[] chain = null;
        private boolean matched = false;

        public AliasInfo(String string) {
            this.type = ATTR_CLASS_SKEY;
            this.label = string;
        }

        public AliasInfo(String string, byte[] byArray, boolean bl, X509Certificate x509Certificate) {
            this.type = ATTR_CLASS_PKEY;
            this.label = string;
            this.id = byArray;
            this.trusted = bl;
            this.cert = x509Certificate;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type == ATTR_CLASS_PKEY) {
                stringBuilder.append("\ttype=[private key]\n");
            } else if (this.type == ATTR_CLASS_SKEY) {
                stringBuilder.append("\ttype=[secret key]\n");
            } else if (this.type == ATTR_CLASS_CERT) {
                stringBuilder.append("\ttype=[trusted cert]\n");
            }
            stringBuilder.append("\tlabel=[" + this.label + "]\n");
            if (this.id == null) {
                stringBuilder.append("\tid=[null]\n");
            } else {
                stringBuilder.append("\tid=" + P11KeyStore.getID(this.id) + "\n");
            }
            stringBuilder.append("\ttrusted=[" + this.trusted + "]\n");
            stringBuilder.append("\tmatched=[" + this.matched + "]\n");
            if (this.cert == null) {
                stringBuilder.append("\tcert=[null]\n");
            } else {
                stringBuilder.append("\tcert=[\tsubject: " + this.cert.getSubjectX500Principal() + "\n\t\tissuer: " + this.cert.getIssuerX500Principal() + "\n\t\tserialNum: " + this.cert.getSerialNumber().toString() + "]");
            }
            return stringBuilder.toString();
        }

        static /* synthetic */ X509Certificate[] access$802(AliasInfo aliasInfo, X509Certificate[] x509CertificateArray) {
            aliasInfo.chain = x509CertificateArray;
            return x509CertificateArray;
        }
    }
}

