/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.plugin.PlugIn;
import java.util.Locale;

public class SpectrJv01_
implements PlugIn {
    private String spjTitle = "SpectrJ v.01a";
    private boolean runTask = true;
    private String wrkCode;
    private int tskCode;
    private Locale runLocale;
    private int[][] exeState;

    public void run(String arg) {
        spjPluginInit pin = new spjPluginInit(this.spjTitle, arg);
        if (pin == null) {
            return;
        }
        this.runLocale = pin.getLocale();
        if (this.runLocale == null) {
            IJ.error("Debug!");
            return;
        }
        spjWorkCode wcd = new spjWorkCode(this.spjTitle, this.runLocale);
        if (wcd == null) {
            return;
        }
        this.wrkCode = wcd.getName();
        if (this.wrkCode == "") {
            return;
        }
        spjExecState est = new spjExecState(this.spjTitle, this.wrkCode);
        if (est == null) {
            return;
        }
        this.exeState = est.getState();
        if (this.exeState[0][0] == -1) {
            return;
        }
        while (this.runTask) {
            spjTaskCode tcd = new spjTaskCode(this.spjTitle, this.wrkCode, this.exeState, this.runLocale);
            if (tcd == null) {
                return;
            }
            this.tskCode = tcd.getTask();
            if (this.tskCode == 0) {
                this.runTask = false;
                break;
            }
            int nTask = this.tskCode / 100 - 1;
            int nObject = this.tskCode / 10 % 10 - 1;
            int nFrame = 2 * nObject + this.tskCode % 100 % 10 - 1;
            switch (nTask) {
                case 0: {
                    spjDetect spdet = new spjDetect(this.spjTitle, this.wrkCode, this.runLocale);
                    if (spdet == null) {
                        return;
                    }
                    this.exeState[nTask][nFrame] = 100;
                    break;
                }
                case 1: {
                    spjExtract spext = new spjExtract(this.spjTitle, this.wrkCode, this.runLocale);
                    if (spext == null) {
                        return;
                    }
                    this.exeState[nTask][nFrame] = 100;
                    break;
                }
                case 2: {
                    spjClassify spcla = new spjClassify(this.spjTitle, this.wrkCode, this.runLocale);
                    if (spcla == null) {
                        return;
                    }
                    this.exeState[nTask][nFrame] = 100;
                    break;
                }
                case 3: {
                    spjAnalyze spana = new spjAnalyze(this.spjTitle, this.wrkCode, this.runLocale);
                    if (spana == null) {
                        return;
                    }
                    this.exeState[nTask][nObject] = 100;
                    break;
                }
                case 4: {
                    spjResult spres = new spjResult(this.spjTitle, this.wrkCode, this.runLocale);
                    if (spres == null) {
                        return;
                    }
                    this.exeState[nTask][0] = 100;
                    this.runTask = false;
                }
            }
        }
        spjPluginEnd plg = new spjPluginEnd(this.spjTitle, this.wrkCode, this.runLocale);
    }
}

