/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.History;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.EuHouToolbar;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private ImagePlus iplus;
    private ImageJ ij;
    private Thread thread;
    private static ResourceBundle etiq;

    public Executer(String cmd) {
        this.command = cmd;
        this.iplus = WindowManager.getCurrentImage();
        this.ij = IJ.getInstance();
        etiq = IJ.getBundle();
    }

    public Executer(String cmd, ImagePlus imp) {
        this.iplus = imp;
        this.ij = IJ.getInstance();
        etiq = IJ.getBundle();
        String st = etiq.getString("RepeatCommand");
        int i = st.indexOf(32);
        if (cmd.startsWith(st.substring(0, i - 1))) {
            this.command = previousCommand;
        } else {
            this.command = cmd;
            if (!cmd.equals(etiq.getString("Undo")) && !cmd.equals(etiq.getString("Close"))) {
                previousCommand = cmd;
            }
        }
        this.thread = new Thread((Runnable)this, cmd);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block11: {
            if (this.command == null) {
                return;
            }
            ImagePlus imp = this.iplus;
            this.iplus = null;
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command, imp);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command, imp);
                }
            }
            catch (Throwable e) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (e instanceof RuntimeException && msg != null && msg.equals("Macro canceled")) break block11;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    if (s.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    s = Tools.fixNewLines(s);
                }
                try {
                    new TextWindow("Exception", s, 350, 250);
                }
                catch (Exception ex) {
                    System.out.println(e.getMessage() + "\n" + ex.getMessage());
                }
            }
        }
    }

    public static ImagePlus getImage() {
        Frame win = WindowManager.getFrontWindow();
        if (win == null) {
            return null;
        }
        if (win instanceof ImageWindow) {
            return ((ImageWindow)win).getImagePlus();
        }
        return WindowManager.getCurrentImage();
    }

    public void runCommand(String cmd, ImagePlus imp) {
        if (cmd.equals(etiq.getString("New"))) {
            new NewImage();
        } else if (cmd.equals(etiq.getString("Open"))) {
            if (Prefs.useJFileChooser && !IJ.macroRunning()) {
                new Opener().openMultiple();
            } else {
                new Opener().open();
            }
        } else if (cmd.equals(etiq.getString("Close"))) {
            this.close(Executer.getImage());
        } else if (cmd.equals(etiq.getString("Cut"))) {
            this.copy(Executer.getImage(), true);
        } else if (cmd.equals(etiq.getString("Copy"))) {
            this.copy(Executer.getImage(), false);
        } else if (cmd.equals(etiq.getString("ImageJ"))) {
            this.ij.toFront();
        } else if (cmd.equals(etiq.getString("PutBehind"))) {
            WindowManager.putBehind();
        } else if (cmd.equals(etiq.getString("Quit"))) {
            IJ.getInstance().quit();
        } else if (cmd.equals(etiq.getString("Photometer")) || cmd.equals(etiq.getString("DisablePhotometer"))) {
            EuHouToolbar.getInstance().photometerButtonAction();
        } else if (cmd.equals(etiq.getString("ClearPhotometer"))) {
            EuHouToolbar.getInstance();
            EuHouToolbar.clearPhotometer();
        } else if (cmd.equals(etiq.getString("PhotometrySettings"))) {
            EuHouToolbar.getInstance().settingsAction();
        } else {
            Hashtable table = Menus.getCommands();
            String plugIn = (String)table.get(cmd);
            if (EuHouToolbar.photometerSelected() && cmd.equals(IJ.getBundle().getString("Crop"))) {
                return;
            }
            Roi ri = null;
            if (EuHouToolbar.photometerSelected() && (cmd.equals(IJ.getBundle().getString("Invert")) || cmd.equals(IJ.getBundle().getString("Duplicate")) || cmd.equals(IJ.getBundle().getString("Scale")))) {
                ri = imp.getRoi();
                imp.killRoi();
            }
            if (plugIn != null) {
                this.runPlugIn(cmd, plugIn);
            } else {
                this.runImageCommand(cmd, imp);
            }
            if (cmd.equals("FITS...")) {
                FileInfo fi = imp.getOriginalFileInfo();
                History.addFiletoHistory(fi.directory + fi.fileName);
                History.synchronizeHistory(IJ.getInstance().getMenuBar().getMenu(0), false);
            }
            if (ri != null) {
                imp.setRoi(ri);
            }
        }
    }

    public void runImageCommand(String cmd, ImagePlus imp) {
        ImageWindow win = null;
        if (imp != null) {
            if (!imp.lock()) {
                return;
            }
            win = imp.getWindow();
        }
        if (cmd.equals(etiq.getString("Revert"))) {
            if (win != null) {
                imp.revert();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals(etiq.getString("Save"))) {
            if (win != null) {
                new FileSaver(imp).save();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals(etiq.getString("Paste"))) {
            if (win != null) {
                win.paste();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals(etiq.getString("Histogram"))) {
            if (win != null) {
                new HistogramWindow(imp);
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals(etiq.getString("Undo"))) {
            if (win != null) {
                Undo.undo();
            } else {
                IJ.noImage();
            }
        } else {
            System.out.println("/" + cmd + "/");
            IJ.error(etiq.getString("UnrecCmdErr") + " " + cmd);
        }
        if (imp != null) {
            imp.unlock();
        }
    }

    void runPlugIn(String cmd, String className) {
        int argStart;
        String arg = "";
        if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
            arg = className.substring(argStart + 2, className.length() - 2);
            className = className.substring(0, argStart);
        }
        IJ.runPlugIn(cmd, className, arg);
    }

    void roiRequired() {
        IJ.error(etiq.getString("SelReqErr"));
    }

    void copy(ImagePlus imp, boolean cut) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.getWindow().copy(cut);
    }

    void close(ImagePlus imp) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame != null && frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else if (imp == null) {
            IJ.noImage();
        } else {
            ImageWindow win = imp.getWindow();
            if (win != null) {
                win.close();
            } else if (IJ.macroRunning()) {
                WindowManager.setTempCurrentImage(null);
            }
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

