/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import javax.swing.JFrame;

public class PhotometerParams
extends JFrame {
    private static PhotometerParams instance = null;
    private CheckboxGroup coordcb;
    private CheckboxGroup skycb;
    private CheckboxGroup starcb;
    private TextField xtf;
    private TextField ytf;
    private TextField radtf;
    private TextField valtf;
    private TextField statf;

    public PhotometerParams() {
        super(IJ.getBundle().getString("PhotometrySettings"));
        Color c = Prefs.getColor("bcolor", new Color(255, 255, 255));
        Color c1 = c.darker();
        Panel p = new Panel();
        p.setBackground(c);
        p.setLayout(new BorderLayout());
        Panel ip1 = new Panel();
        ip1.setBackground(c);
        ip1.add(new Label(IJ.getBundle().getString("PhotomCoord")));
        this.coordcb = new CheckboxGroup();
        ip1.add(new Checkbox(IJ.getBundle().getString("Auto"), this.coordcb, true));
        Panel ip11 = new Panel();
        ip1.add(ip11);
        ip11.setBackground(c1);
        ip11.add(new Checkbox(IJ.getBundle().getString("Manual"), this.coordcb, false));
        this.xtf = new TextField(4);
        ip11.add(new Label("   X:"));
        ip11.add(this.xtf);
        this.ytf = new TextField(4);
        ip11.add(new Label("   Y:"));
        ip11.add(this.ytf);
        p.add((Component)ip1, "North");
        Panel ip2 = new Panel();
        ip2.setBackground(c);
        Panel ip22 = new Panel();
        ip22.setBackground(c);
        ip22.setLayout(new GridLayout(2, 1));
        ip2.add(new Label(IJ.getBundle().getString("SkyParam")));
        this.skycb = new CheckboxGroup();
        ip2.add(ip22);
        Panel ip21 = new Panel();
        ip21.setBackground(c);
        ip21.add(new Checkbox(IJ.getBundle().getString("AutoFWHM"), this.skycb, true));
        ip21.add(new Checkbox(IJ.getBundle().getString("AutoStar"), this.skycb, false));
        ip22.add(ip21);
        ip21 = new Panel();
        ip21.setBackground(c);
        Panel ip211 = new Panel();
        ip211.setBackground(c1);
        ip211.add(new Checkbox(IJ.getBundle().getString("ManRad"), this.skycb, false));
        this.radtf = new TextField(3);
        ip211.add(this.radtf);
        ip21.add(ip211);
        ip211 = new Panel();
        ip211.setBackground(c1);
        ip211.add(new Checkbox(IJ.getBundle().getString("Skyval"), this.skycb, false));
        this.valtf = new TextField(5);
        ip211.add(this.valtf);
        ip21.add(ip211);
        ip22.add(ip21);
        p.add((Component)ip2, "Center");
        Panel ip3 = new Panel();
        ip3.setBackground(c);
        this.starcb = new CheckboxGroup();
        ip3.add(new Label(IJ.getBundle().getString("StarRad")));
        ip3.add(new Checkbox(IJ.getBundle().getString("AutoFWHM"), this.starcb, true));
        Panel ip31 = new Panel();
        ip31.setBackground(c1);
        ip31.add(new Checkbox(IJ.getBundle().getString("ManRad"), this.starcb, false));
        this.statf = new TextField(3);
        ip31.add(this.statf);
        ip3.add(ip31);
        p.add((Component)ip3, "South");
        this.add(p);
        this.pack();
        this.setResizable(false);
        instance = this;
        GUI.center(this);
        this.show();
        WindowManager.addWindow(this);
    }

    public void dispose() {
        WindowManager.removeWindow(this);
        super.dispose();
        instance = null;
    }

    public short getStatus() {
        short res = 0;
        if (!this.coordcb.getSelectedCheckbox().getLabel().equals(IJ.getBundle().getString("Auto"))) {
            res = (short)(res | 0x100);
        }
        if (this.skycb.getSelectedCheckbox().getLabel().equals(IJ.getBundle().getString("ManRad"))) {
            res = (short)(res | 2);
        } else if (this.skycb.getSelectedCheckbox().getLabel().equals(IJ.getBundle().getString("Skyval"))) {
            res = (short)(res | 4);
        } else if (this.skycb.getSelectedCheckbox().getLabel().equals(IJ.getBundle().getString("AutoStar"))) {
            res = (short)(res | 8);
        }
        if (this.starcb.getSelectedCheckbox().getLabel().equals(IJ.getBundle().getString("ManRad"))) {
            res = (short)(res | 1);
        }
        return res;
    }

    public float getVal(short op) throws NumberFormatException {
        String s = null;
        if (op == 1) {
            s = this.statf.getText();
        } else if (op == 2) {
            s = this.radtf.getText();
        }
        if (s != null) {
            int i = Integer.parseInt(s);
            return i;
        }
        if (op == 4) {
            s = this.valtf.getText();
        }
        float f = Float.parseFloat(s);
        return f;
    }

    public int[] getCoord() throws NumberFormatException {
        int[] t = new int[]{Integer.parseInt(this.xtf.getText()), Integer.parseInt(this.ytf.getText())};
        return t;
    }

    public static PhotometerParams getInstance() {
        return instance;
    }
}

