/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected int[] xSpline;
    protected int[] ySpline;
    protected int[] xScreenSpline;
    protected int[] yScreenSpline;
    protected int splinePoints = 200;
    protected Graphics g;
    private int lastX;
    private int lastY;
    private double angle1 = -1.0;
    private double degrees = -1.0;
    private int xClipMin;
    private int yClipMin;
    private int xClipMax;
    private int yClipMax;
    private boolean splined = false;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        if (type == 2) {
            this.type = 2;
        } else if (type == 3) {
            this.type = 3;
        } else if (type == 4) {
            this.type = 4;
        } else if (type == 6) {
            this.type = 6;
        } else if (type == 7) {
            this.type = 7;
        } else if (type == 8) {
            this.type = 8;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        this.maxPoints = xPoints.length;
        this.xp = xPoints;
        this.yp = yPoints;
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = nPoints;
        if (type == 8 && nPoints == 3) {
            this.getAngleAsString();
        }
        this.finishPolygon();
    }

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, ImagePlus imp, int type) {
        this(xPoints, yPoints, nPoints, type);
        this.setImage(imp);
    }

    public PolygonRoi(int ox, int oy, ImagePlus imp) {
        super(ox, oy, imp);
        int tool = Toolbar.getToolId();
        this.type = tool == 2 ? 2 : (tool == 14 ? 8 : 6);
        this.xp = new int[this.maxPoints];
        this.yp = new int[this.maxPoints];
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 1;
        this.xp[0] = ox;
        this.yp[0] = oy;
        this.x = ox;
        this.y = oy;
        this.width = 1;
        this.height = 1;
        this.clipX = ox;
        this.clipY = oy;
        this.clipWidth = 1;
        this.clipHeight = 1;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            this.g = this.ic.getGraphics();
        }
        if (tool == 2 || tool == 5 || tool == 14) {
            this.g.setColor(ROIColor);
            this.lastX = this.x;
            this.lastY = this.y;
            this.drawStartBox();
        }
        this.state = 0;
    }

    private void drawStartBox() {
        if (this.type != 8) {
            this.g.drawRect(this.ic.screenX(this.startX) - 4, this.ic.screenY(this.startY) - 4, 8, 8);
        }
    }

    public void draw(Graphics g) {
        if (this.state != 0) {
            this.updatePolygon();
            g.setColor(ROIColor);
            if (this.xSpline != null) {
                if (this.type == 6 || this.type == 7) {
                    g.drawPolyline(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
                } else {
                    g.drawPolygon(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
                }
            } else if (this.type == 6 || this.type == 7 || this.type == 8) {
                g.drawPolyline(this.xp2, this.yp2, this.nPoints);
            } else {
                g.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            if ((this.xSpline != null || this.type == 2 || this.type == 6 || this.type == 8) && this.state != 0 && this.clipboard == null) {
                if (this.ic != null) {
                    this.mag = this.ic.getMagnification();
                }
                int size2 = 2;
                if (this.activeHandle > 0) {
                    this.drawHandle(g, this.xp2[this.activeHandle - 1] - size2, this.yp2[this.activeHandle - 1] - size2);
                }
                if (this.activeHandle < this.nPoints - 1) {
                    this.drawHandle(g, this.xp2[this.activeHandle + 1] - size2, this.yp2[this.activeHandle + 1] - size2);
                }
                for (int i = 0; i < this.nPoints; ++i) {
                    this.drawHandle(g, this.xp2[i] - size2, this.yp2[i] - size2);
                }
            }
            if (this.state != 4) {
                this.showStatus();
            }
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
    }

    public void drawPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        if (this.xSpline != null) {
            ip.moveTo(this.x + this.xSpline[0], this.y + this.ySpline[0]);
            for (int i = 1; i < this.splinePoints; ++i) {
                ip.lineTo(this.x + this.xSpline[i], this.y + this.ySpline[i]);
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + this.xSpline[0], this.y + this.ySpline[0]);
            }
        } else {
            ip.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
            for (int i = 1; i < this.nPoints; ++i) {
                ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
            }
        }
        if (this.xSpline != null || Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    protected void grow(int x, int y) {
    }

    protected void updatePolygon() {
        int i;
        Rectangle srcRect = this.ic.getSrcRect();
        if (this.ic.getMagnification() == 1.0 && srcRect.x == 0 && srcRect.y == 0) {
            for (i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.xp[i] + this.x;
                this.yp2[i] = this.yp[i] + this.y;
            }
        } else {
            for (i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.ic.screenX(this.xp[i] + this.x);
                this.yp2[i] = this.ic.screenY(this.yp[i] + this.y);
            }
        }
        if (this.xSpline != null) {
            for (i = 0; i < this.splinePoints; ++i) {
                this.xScreenSpline[i] = this.ic.screenX(this.xSpline[i] + this.x);
                this.yScreenSpline[i] = this.ic.screenY(this.ySpline[i] + this.y);
            }
        }
    }

    void handleMouseMove(int ox, int oy) {
        int tool = Toolbar.getToolId();
        if (tool != 2 && tool != 5 && tool != 14) {
            this.imp.killRoi();
            this.imp.draw();
            return;
        }
        this.g.setXORMode(Color.black);
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(this.lastX), this.ic.screenY(this.lastY));
        this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(ox), this.ic.screenY(oy));
        this.lastX = ox;
        this.lastY = oy;
        String angle = "";
        if (tool == 5 || tool == 14) {
            if (this.nPoints == 1) {
                this.angle1 = this.degrees = this.getAngle(this.xp[0], this.yp[0], ox, oy);
            } else if (this.nPoints == 2) {
                double angle2 = this.getAngle(this.xp[1], this.yp[1], ox, oy);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - angle2));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            } else {
                this.angle1 = -1.0;
            }
            if (this.angle1 > 0.0) {
                angle = ", angle=" + IJ.d2s(this.degrees);
            }
        }
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + angle);
    }

    void finishPolygon() {
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        if (this.nPoints < 2 || this.type != 7 && this.type != 6 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            this.imp.killRoi();
            return;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.xp[i] = this.xp[i] - this.x;
            this.yp[i] = this.yp[i] - this.y;
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void drawLineSegments() {
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        Rectangle r = poly.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.g.setPaintMode();
        this.g.setColor(ROIColor);
        this.drawStartBox();
        for (int i = 0; i < this.nPoints - 1; ++i) {
            this.g.drawLine(this.ic.screenX(this.xp[i]), this.ic.screenY(this.yp[i]), this.ic.screenX(this.xp[i + 1]), this.ic.screenY(this.yp[i + 1]));
        }
    }

    protected void moveHandle(int ox, int oy) {
        if (this.clipboard != null) {
            return;
        }
        this.xp[this.activeHandle] = ox - this.x;
        this.yp[this.activeHandle] = oy - this.y;
        if (this.xSpline != null) {
            this.fitSpline(this.splinePoints);
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        } else {
            this.resetBoundingRect();
            this.updateClipRectAndDraw();
        }
        String angle = this.type == 8 ? this.getAngleAsString() : "";
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + angle);
    }

    void updateClipRectAndDraw() {
        int y2;
        int x2;
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymax = 0;
        if (this.activeHandle > 0) {
            x2 = this.x + this.xp[this.activeHandle - 1];
            y2 = this.y + this.yp[this.activeHandle - 1];
        } else {
            x2 = this.x + this.xp[this.nPoints - 1];
            y2 = this.y + this.yp[this.nPoints - 1];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        x2 = this.x + this.xp[this.activeHandle];
        y2 = this.y + this.yp[this.activeHandle];
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (this.activeHandle < this.nPoints - 1) {
            x2 = this.x + this.xp[this.activeHandle + 1];
            y2 = this.y + this.yp[this.activeHandle + 1];
        } else {
            x2 = this.x + this.xp[0];
            y2 = this.y + this.yp[0];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        int xmin2 = xmin;
        int ymin2 = ymin;
        int xmax2 = xmax;
        int ymax2 = ymax;
        if (this.xClipMin < xmin2) {
            xmin2 = this.xClipMin;
        }
        if (this.yClipMin < ymin2) {
            ymin2 = this.yClipMin;
        }
        if (this.xClipMax > xmax2) {
            xmax2 = this.xClipMax;
        }
        if (this.yClipMax > ymax2) {
            ymax2 = this.yClipMax;
        }
        this.xClipMin = xmin;
        this.yClipMin = ymin;
        this.xClipMax = xmax;
        this.yClipMax = ymax;
        double mag = this.ic.getMagnification();
        int m = mag < 1.0 ? (int)(5.0 / mag) : 5;
        this.imp.draw(xmin2 - m, ymin2 - m, xmax2 - xmin2 + m * 2, ymax2 - ymin2 + m * 2);
    }

    void resetBoundingRect() {
        int i;
        int xmin = Integer.MAX_VALUE;
        int xmax = -xmin;
        int ymin = xmin;
        int ymax = xmax;
        for (i = 0; i < this.nPoints; ++i) {
            int yy;
            int xx = this.xp[i];
            if (xx < xmin) {
                xmin = xx;
            }
            if (xx > xmax) {
                xmax = xx;
            }
            if ((yy = this.yp[i]) < ymin) {
                ymin = yy;
            }
            if (yy <= ymax) continue;
            ymax = yy;
        }
        if (xmin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.xp[n] = this.xp[n] - xmin;
            }
        }
        if (ymin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.yp[n] = this.yp[n] - ymin;
            }
        }
        this.x += xmin;
        this.y += ymin;
        this.width = xmax - xmin;
        this.height = ymax - ymin;
    }

    String getAngleAsString() {
        double angle1 = this.getAngle(this.xp[0], this.yp[0], this.xp[1], this.yp[1]);
        double angle2 = this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
        this.degrees = Math.abs(180.0 - Math.abs(angle1 - angle2));
        if (this.degrees > 180.0) {
            this.degrees = 360.0 - this.degrees;
        }
        return ", angle=" + IJ.d2s(this.degrees);
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        int m = (int)(10.0 / this.ic.getMagnification());
        this.xClipMin = ox - m;
        this.yClipMin = oy - m;
        this.xClipMax = ox + m;
        this.yClipMax = oy + m;
    }

    public void fitSpline(int evaluationPoints) {
        int i;
        if (this.xSpline == null || this.splinePoints != evaluationPoints) {
            this.splinePoints = evaluationPoints;
            this.xSpline = new int[this.splinePoints];
            this.ySpline = new int[this.splinePoints];
            this.xScreenSpline = new int[this.splinePoints];
            this.yScreenSpline = new int[this.splinePoints];
        }
        int nNodes = this.nPoints;
        if (this.type == 2) {
            if (++nNodes >= this.xp.length) {
                this.enlargeArrays();
            }
            this.xp[nNodes - 1] = this.xp[0];
            this.yp[nNodes - 1] = this.yp[0];
        }
        int[] xindex = new int[nNodes];
        for (int i2 = 0; i2 < nNodes; ++i2) {
            xindex[i2] = i2;
        }
        SplineFitter sfx = new SplineFitter(xindex, this.xp, nNodes);
        SplineFitter sfy = new SplineFitter(xindex, this.yp, nNodes);
        double scale = (double)(nNodes - 1) / (double)(this.splinePoints - 1);
        int xs = 0;
        int ys = 0;
        int xmin = Integer.MAX_VALUE;
        int xmax = -xmin;
        int ymin = xmin;
        int ymax = xmax;
        for (i = 0; i < this.splinePoints; ++i) {
            double xvalue = (double)i * scale;
            xs = (int)Math.floor(sfx.evalSpline(xindex, this.xp, nNodes, xvalue) + 0.5);
            if (xs < xmin) {
                xmin = xs;
            }
            if (xs > xmax) {
                xmax = xs;
            }
            this.xSpline[i] = xs;
            ys = (int)Math.floor(sfy.evalSpline(xindex, this.yp, nNodes, xvalue) + 0.5);
            if (ys < ymin) {
                ymin = ys;
            }
            if (ys > ymax) {
                ymax = ys;
            }
            this.ySpline[i] = ys;
        }
        if (xmin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.xp[n] = this.xp[n] - xmin;
            }
            i = 0;
            while (i < this.splinePoints) {
                int n = i++;
                this.xSpline[n] = this.xSpline[n] - xmin;
            }
        }
        if (ymin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.yp[n] = this.yp[n] - ymin;
            }
            i = 0;
            while (i < this.splinePoints) {
                int n = i++;
                this.ySpline[n] = this.ySpline[n] - ymin;
            }
        }
        this.x += xmin;
        this.y += ymin;
        this.width = xmax - xmin;
        this.height = ymax - ymin;
        this.splined = true;
    }

    protected void handleMouseUp(int sx, int sy) {
        if (this.state == 1) {
            this.state = 3;
            return;
        }
        if (this.state == 4) {
            this.imp.getProcessor().setMask(null);
            this.state = 3;
            this.updateClipRect();
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            return;
        }
        if (this.state != 0) {
            return;
        }
        if (IJ.spaceBarDown()) {
            this.g.setXORMode(Color.black);
            this.g.drawLine(this.ic.screenX(this.xp[this.nPoints - 1]), this.ic.screenY(this.yp[this.nPoints - 1]), this.ic.screenX(this.lastX), this.ic.screenY(this.lastY));
            this.drawLineSegments();
            return;
        }
        boolean samePoint = this.xp[this.nPoints - 1] == this.lastX && this.yp[this.nPoints - 1] == this.lastY;
        Rectangle biggerStartBox = new Rectangle(this.ic.screenX(this.startX) - 5, this.ic.screenY(this.startY) - 5, 10, 10);
        if (this.nPoints > 2 && (biggerStartBox.contains(sx, sy) || this.ic.offScreenX(sx) == this.startX && this.ic.offScreenY(sy) == this.startY || samePoint && System.currentTimeMillis() - this.mouseUpTime <= 500L)) {
            this.finishPolygon();
            return;
        }
        if (!samePoint) {
            this.xp[this.nPoints] = this.lastX;
            this.yp[this.nPoints] = this.lastY;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLineSegments();
            this.mouseUpTime = System.currentTimeMillis();
            if (this.type == 8 && this.nPoints == 3) {
                this.finishPolygon();
                return;
            }
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.xScreenSpline != null) {
            Polygon poly = new Polygon(this.xScreenSpline, this.yScreenSpline, this.splinePoints);
            return poly.contains(this.ic.screenX(x), this.ic.screenY(y));
        }
        Polygon poly = new Polygon(this.xp2, this.yp2, this.nPoints);
        return poly.contains(this.ic.screenX(x), this.ic.screenY(y));
    }

    public int isHandle(int sx, int sy) {
        if (this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 || this.clipboard != null) {
            return -1;
        }
        int size = 10;
        int halfSize = size / 2;
        int handle = -1;
        for (int i = 0; i < this.nPoints; ++i) {
            int sx2 = this.xp2[i] - halfSize;
            int sy2 = this.yp2[i] - halfSize;
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            handle = i;
            break;
        }
        return handle;
    }

    public int[] getMask() {
        if (this.type == 6 || this.type == 7 || this.type == 8 || this.width == 0 || this.height == 0) {
            return null;
        }
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        if (this.xSpline != null) {
            g.fillPolygon(this.xSpline, this.ySpline, this.splinePoints);
        } else {
            g.fillPolygon(this.xp, this.yp, this.nPoints);
        }
        ColorProcessor cp = new ColorProcessor(img);
        img.flush();
        img = null;
        g.dispose();
        return (int[])cp.getPixels();
    }

    double getSmoothedLineLength() {
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double x2 = this.xp[0];
        double x3 = this.xp[0];
        double x4 = this.xp[1];
        double y2 = this.yp[0];
        double y3 = this.yp[0];
        double y4 = this.yp[1];
        for (int i = 0; i < this.nPoints - 1; ++i) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            double y1 = y2;
            y2 = y3;
            y3 = y4;
            if (i + 2 < this.nPoints) {
                x4 = this.xp[i + 2];
                y4 = this.yp[i + 2];
            }
            double dx = (x4 - x1) / 3.0;
            double dy = (y4 - y1) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        return length;
    }

    double getSmoothedPerimeter() {
        double dy;
        double dx;
        double y1;
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double x2 = this.xp[this.nPoints - 1];
        double x3 = this.xp[0];
        double x4 = this.xp[1];
        double y2 = this.yp[this.nPoints - 1];
        double y3 = this.yp[0];
        double y4 = this.yp[1];
        for (int i = 0; i < this.nPoints - 1; ++i) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            y1 = y2;
            y2 = y3;
            y3 = y4;
            if (i + 2 < this.nPoints) {
                x4 = this.xp[i + 2];
                y4 = this.yp[i + 2];
            } else {
                x4 = this.xp[0];
                y4 = this.yp[0];
            }
            dx = (x4 - x1) / 3.0;
            dy = (y4 - y1) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        double x1 = x2;
        x2 = x3;
        x3 = x4;
        x4 = this.xp[1];
        y1 = y2;
        y2 = y3;
        y3 = y4;
        y4 = this.yp[1];
        dx = (x4 - x1) / 3.0;
        dy = (y4 - y1) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getTracedPerimeter() {
        int sumdx = 0;
        int sumdy = 0;
        int nCorners = 0;
        int dx1 = this.xp[0] - this.xp[this.nPoints - 1];
        int dy1 = this.yp[0] - this.yp[this.nPoints - 1];
        int side1 = Math.abs(dx1) + Math.abs(dy1);
        boolean corner = false;
        for (int i = 0; i < this.nPoints; ++i) {
            int nexti = i + 1;
            if (nexti == this.nPoints) {
                nexti = 0;
            }
            int dx2 = this.xp[nexti] - this.xp[i];
            int dy2 = this.yp[nexti] - this.yp[i];
            sumdx += Math.abs(dx1);
            sumdy += Math.abs(dy1);
            int side2 = Math.abs(dx2) + Math.abs(dy2);
            if (side1 > 1 || !corner) {
                corner = true;
                ++nCorners;
            } else {
                corner = false;
            }
            dx1 = dx2;
            dy1 = dy2;
            side1 = side2;
        }
        double w = 1.0;
        double h = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w = cal.pixelWidth;
            h = cal.pixelHeight;
        }
        return (double)sumdx * w + (double)sumdy * h - (double)nCorners * (w + h - Math.sqrt(w * w + h * h));
    }

    public double getLength() {
        if (this.type == 4) {
            return this.getTracedPerimeter();
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter();
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength();
            }
        }
        double length = 0.0;
        Calibration cal = this.imp.getCalibration();
        double w2 = cal.pixelWidth * cal.pixelWidth;
        double h2 = cal.pixelHeight * cal.pixelHeight;
        if (this.xSpline != null) {
            int dy;
            int dx;
            for (int i = 0; i < this.splinePoints - 1; ++i) {
                dx = this.xSpline[i + 1] - this.xSpline[i];
                dy = this.ySpline[i + 1] - this.ySpline[i];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
            if (this.type == 2) {
                dx = this.xSpline[0] - this.xSpline[this.splinePoints - 1];
                dy = this.ySpline[0] - this.ySpline[this.splinePoints - 1];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
        } else {
            int dy;
            int dx;
            for (int i = 0; i < this.nPoints - 1; ++i) {
                dx = this.xp[i + 1] - this.xp[i];
                dy = this.yp[i + 1] - this.yp[i];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
            if (this.type == 2) {
                dx = this.xp[0] - this.xp[this.nPoints - 1];
                dy = this.yp[0] - this.yp[this.nPoints - 1];
                length += Math.sqrt((double)(dx * dx) * w2 + (double)(dy * dy) * h2);
            }
        }
        return length;
    }

    public double getFeretsDiameter() {
        double w2 = 1.0;
        double h2 = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double diameter = 0.0;
        for (int i = 0; i < this.nPoints; ++i) {
            for (int j = i; j < this.nPoints; ++j) {
                double dx = this.xp[i] - this.xp[j];
                double dy = this.yp[i] - this.yp[j];
                double d = Math.sqrt(dx * dx * w2 + dy * dy * h2);
                if (!(d > diameter)) continue;
                diameter = d;
            }
        }
        return diameter;
    }

    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        if (this.xSpline != null) {
            return this.splinePoints;
        }
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        if (this.xSpline != null) {
            return this.xSpline;
        }
        return this.xp;
    }

    public int[] getYCoordinates() {
        if (this.xSpline != null) {
            return this.ySpline;
        }
        return this.yp;
    }

    void enlargeArrays() {
        int[] xptemp = new int[this.maxPoints * 2];
        int[] yptemp = new int[this.maxPoints * 2];
        int[] xp2temp = new int[this.maxPoints * 2];
        int[] yp2temp = new int[this.maxPoints * 2];
        System.arraycopy(this.xp, 0, xptemp, 0, this.maxPoints);
        System.arraycopy(this.yp, 0, yptemp, 0, this.maxPoints);
        System.arraycopy(this.xp2, 0, xp2temp, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, yp2temp, 0, this.maxPoints);
        this.xp = xptemp;
        this.yp = yptemp;
        this.xp2 = xp2temp;
        this.yp2 = yp2temp;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points");
        }
        this.maxPoints *= 2;
    }
}

